/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormMeta;
import com.artfess.form.model.FormRight;
import com.artfess.form.model.FormRightXml;
import com.artfess.form.persistence.dao.FormRightDao;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.vo.FormRigthParam;
import com.artfess.uc.api.impl.util.PermissionCalc;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmFormRightManager")
public class FormRightManagerImpl
extends BaseManagerImpl<FormRightDao, FormRight>
implements FormRightManager {
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    PermissionCalc permssionCalc;
    @Resource
    BoDefManager boDefManager;

    @Override
    public JsonNode getDefaultByFormDefKey(String formKey, boolean isInstance) throws IOException {
        FormMeta formDef = this.formMetaManager.getByKey(formKey);
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        if (formDef != null) {
            String formDefId = formDef.getId();
            List<Map<String, String>> lowList = this.convertMapLower(formDef.getExpand());
            List<FormField> fieldList = this.formFieldManager.getExtByFormId(formDefId);
            List<FormField> noAttrFields = this.formFieldManager.getNoAttrByFormId(formDefId);
            if (BeanUtils.isNotEmpty(noAttrFields)) {
                this.setNoAttrFieldEntName(fieldList, noAttrFields);
                fieldList.addAll(noAttrFields);
            }
            Map<String, List<FormField>> fieldMap = this.convertFormGroup(fieldList);
            ObjectNode tableJson = JsonUtil.getMapper().createObjectNode();
            for (Map<String, String> entMap : lowList) {
                JsonNode json = this.buildTable(entMap, fieldMap, isInstance);
                if (json == null) continue;
                String entName = entMap.get("name_");
                tableJson.set(entName, json);
            }
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("form_id_", (Object)formDefId, QueryOP.EQUAL);
            filter.addFilter("ctrl_type_", (Object)"dataView", QueryOP.EQUAL);
            PageList query = this.formFieldManager.query(filter);
            if (BeanUtils.isNotEmpty((Object)query)) {
                for (FormField field : query.getRows()) {
                    BoDef byDefId = this.boDefManager.getByDefId(field.getBoDefId());
                    if (BeanUtils.isEmpty((Object)byDefId) || BeanUtils.isEmpty((Object)byDefId.getBoEnt())) continue;
                    ObjectNode rightJsonObj = JsonUtil.getMapper().createObjectNode();
                    ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
                    rightJson.put("hidden", false);
                    rightJson.put("add", !isInstance);
                    rightJson.put("del", !isInstance);
                    rightJson.put("edit", true);
                    rightJson.put("export", true);
                    rightJsonObj.put("main", false);
                    rightJsonObj.set("rights", (JsonNode)rightJson);
                    rightJsonObj.put("description", byDefId.getBoEnt().getDesc());
                    rightJsonObj.put("ctrlType", "dataView");
                    tableJson.set(byDefId.getAlias(), (JsonNode)rightJsonObj);
                }
            }
            jsonObj.set("table", (JsonNode)tableJson);
            String opinionJson = formDef.getOpinionConf();
            JsonNode opinionJsonObj = this.buildOpinion(opinionJson, isInstance);
            if (opinionJsonObj != null) {
                jsonObj.set("opinion", opinionJsonObj);
            }
        } else {
            jsonObj = null;
        }
        return jsonObj;
    }

    private void setNoAttrFieldEntName(List<FormField> fieldList, List<FormField> noAttrFields) {
        if (BeanUtils.isNotEmpty(fieldList) && BeanUtils.isNotEmpty(noAttrFields)) {
            HashMap<String, String> entNameMap = new HashMap<String, String>();
            for (FormField formField : fieldList) {
                entNameMap.put(formField.getEntId(), formField.getEntName());
            }
            for (FormField formField : noAttrFields) {
                formField.setEntName((String)entNameMap.get(formField.getEntId()));
            }
        }
    }

    private JsonNode buildOpinion(String json, boolean isInstance) throws IOException {
        if (StringUtil.isEmpty((String)json)) {
            return null;
        }
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        JsonNode ary = JsonUtil.toJsonNode((String)json);
        for (Object obj : ary) {
            JsonNode jsonObj = (JsonNode)obj;
            String name = jsonObj.get("name") + "";
            String desc = jsonObj.get("desc") + "";
            ObjectNode permissionJson = this.getPermissionJson(desc);
            permissionJson = isInstance ? this.getInstPermissionJson(desc) : this.getPermissionJson(desc);
            rtnJson.set(name, (JsonNode)permissionJson);
        }
        return rtnJson;
    }

    private JsonNode buildTable(Map<String, String> entMap, Map<String, List<FormField>> fieldMap, boolean isInstance) throws IOException {
        String entName = entMap.get("name_");
        String entDesc = entMap.get("desc_");
        String type = entMap.get("type_");
        List<FormField> list = fieldMap.get(entName);
        if (BeanUtils.isEmpty(list)) {
            return null;
        }
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        jsonObj.put("description", entDesc);
        if ("main".equalsIgnoreCase(type)) {
            jsonObj.put("main", true);
        } else {
            ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
            rightJson.put("hidden", false);
            rightJson.put("add", !isInstance);
            rightJson.put("del", !isInstance);
            if ("onetoone".equals(type)) {
                rightJson.put("required", true);
            } else {
                rightJson.put("required", false);
            }
            jsonObj.put("main", false);
            jsonObj.set("rights", (JsonNode)rightJson);
        }
        ObjectNode fieldsJson = JsonUtil.getMapper().createObjectNode();
        for (FormField field : list) {
            ObjectNode permissonJson = null;
            permissonJson = !isInstance ? this.getPermissionJson(field.getDesc(), field.getSn()) : this.getInstPermissionJson(field.getDesc(), field.getSn());
            permissonJson.put("fieldName", field.getName());
            fieldsJson.set(field.getName(), (JsonNode)permissonJson);
        }
        jsonObj.set("fields", (JsonNode)fieldsJson);
        return jsonObj;
    }

    private ObjectNode getPermissionJson(String desc) throws IOException {
        desc = desc.replaceAll("\"", "'");
        String json = "{\"read\": [{\"type\": \"everyone\"}],\"write\": [{\"type\": \"everyone\"}],\"required\": [{\"type\": \"none\"}]}";
        ObjectNode permissionJson = (ObjectNode)JsonUtil.toJsonNode((String)json);
        permissionJson.put("description", desc);
        return permissionJson;
    }

    private ObjectNode getPermissionJson(String desc, Integer sn) throws IOException {
        ObjectNode json = this.getPermissionJson(desc);
        json.put("sn", sn);
        return json;
    }

    private ObjectNode getInstPermissionJson(String desc) throws IOException {
        desc = desc.replaceAll("\"", "'");
        String json = "{\"description\": \"" + desc + "\",\"read\": [{\"type\": \"everyone\"}]}";
        return (ObjectNode)JsonUtil.toJsonNode((String)json);
    }

    private ObjectNode getInstPermissionJson(String desc, Integer sn) throws IOException {
        ObjectNode json = this.getInstPermissionJson(desc);
        json.put("sn", sn);
        return json;
    }

    private Map<String, List<FormField>> convertFormGroup(List<FormField> fieldList) {
        HashMap<String, List<FormField>> map = new HashMap<String, List<FormField>>();
        for (FormField field : fieldList) {
            List<FormField> list;
            String entName = field.getEntName();
            if (map.containsKey(entName)) {
                list = (List)map.get(entName);
                list.add(field);
                continue;
            }
            list = new ArrayList();
            list.add(field);
            map.put(entName, list);
        }
        return map;
    }

    private List<Map<String, String>> convertMapLower(String expand) throws IOException {
        JsonNode expandJson = JsonUtil.toJsonNode((String)expand);
        ArrayNode boDefList = (ArrayNode)expandJson.findValue("boDefList");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashSet<String> addBos = new HashSet<String>();
        for (JsonNode jsonNode : boDefList) {
            JsonNode aliasNode = jsonNode.get("alias");
            if (BeanUtils.isEmpty((Object)aliasNode) || addBos.contains(aliasNode.asText())) continue;
            addBos.add(aliasNode.asText());
            BoDef boDef = this.boDefManager.getByDefId(jsonNode.get("id").asText());
            BoEnt boEnt = boDef.getBoEnt();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("name_", boEnt.getName());
            map.put("desc_", boEnt.getDesc());
            map.put("type_", boEnt.getType());
            map.put("sn_", "0");
            map.put("grade_", "main");
            list.add(map);
            List childEntList = boEnt.getChildEntList();
            int i = 0;
            while (i < childEntList.size()) {
                BoEnt childEnt = (BoEnt)childEntList.get(i);
                map = new LinkedHashMap();
                map.put("name_", childEnt.getName());
                map.put("desc_", childEnt.getDesc());
                map.put("type_", childEnt.getType());
                map.put("sn_", i++ + "");
                map.put("grade_", "sub");
                list.add(map);
                List sunEntList = childEnt.getChildEntList();
                if (!BeanUtils.isNotEmpty((Object)sunEntList)) continue;
                int j = 0;
                while (j < sunEntList.size()) {
                    map = new LinkedHashMap();
                    map.put("name_", ((BoEnt)sunEntList.get(j)).getName());
                    map.put("desc_", ((BoEnt)sunEntList.get(j)).getDesc());
                    map.put("type_", ((BoEnt)sunEntList.get(j)).getType());
                    map.put("grade_", "sun");
                    map.put("sn_", j++ + "");
                    list.add(map);
                }
            }
        }
        return list;
    }

    private JsonNode getByFlowKey(String flowKey, String parentFlowKey, String formKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, parentFlowKey, 1);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    private JsonNode getByFlowNodeId(String flowKey, String nodeId, String parentFlowKey, String formKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowNodeId(flowKey, nodeId, parentFlowKey, 1);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Override
    public JsonNode getByFormKey(String formKey, boolean isReadOnly) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFormKey(formKey, isReadOnly);
        JsonNode rtnJson = null;
        if (right != null) {
            try {
                rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rtnJson;
        }
        String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(formKey);
        rtnJson = this.getDefaultByFormDefKey(formMetaKey, isReadOnly);
        return rtnJson;
    }

    private JsonNode getByInst(String flowKey) throws IOException {
        FormRight right = ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, "", 2);
        if (right != null) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)right.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Override
    @Transactional
    public void removeInst(String flowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, "", 2);
    }

    @Override
    @Transactional
    public void remove(String formKey, String flowKey, String nodeId, String parentFlowKey) {
        FormRight right = null;
        if (StringUtil.isNotEmpty((String)flowKey)) {
            right = StringUtil.isNotEmpty((String)nodeId) ? ((FormRightDao)this.baseMapper).getByFlowNodeId(flowKey, nodeId, parentFlowKey, 1) : ((FormRightDao)this.baseMapper).getByFlowKey(flowKey, parentFlowKey, 1);
        }
        if (right != null && !formKey.equals(right.getFormKey())) {
            this.remove(flowKey, nodeId, parentFlowKey);
        }
    }

    @Override
    @Transactional
    public void remove(String flowKey, String nodeId, String parentFlowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowNode(flowKey, nodeId, parentFlowKey);
    }

    @Override
    @Transactional
    public void remove(String flowKey, String parentFlowKey) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, parentFlowKey, 1);
    }

    @Override
    @Transactional
    public void save(FormRigthParam param) {
        if (StringUtil.isNotEmpty((String)param.getFlowKey())) {
            if (param.getType() == 1) {
                this.remove(param.getFlowKey(), param.getNodeId(), param.getParentflowKey());
            } else {
                this.removeInst(param.getFlowKey());
            }
        } else {
            this.removeByFormKeyType(param.getFormKey(), param.getType());
        }
        if (StringUtil.isNotEmpty((String)param.getDataKey())) {
            this.removeByDataKey(param.getDataKey(), param.getType());
        }
        String id = UniqueIdUtil.getSuid();
        FormRight right = new FormRight();
        right.setId(id);
        right.setFormKey(param.getFormKey());
        right.setFlowKey(param.getFlowKey());
        right.setNodeId(param.getNodeId());
        right.setParentFlowKey(param.getParentflowKey());
        right.setPermission(param.getPermission());
        right.setPermissionType(param.getType());
        right.setIsCheckOpinion(param.getIsCheckOpinion());
        right.setDataKey(param.getDataKey());
        this.create((Model)right);
    }

    @Override
    public JsonNode getPermissionSetting(FormRigthParam param) throws IOException {
        boolean isReadOnly;
        JsonNode json = null;
        if (StringUtil.isNotEmpty((String)param.getFlowKey())) {
            if (param.getType() == 1) {
                if (StringUtil.isEmpty((String)param.getNodeId())) {
                    json = this.getByFlowKey(param.getFlowKey(), param.getParentflowKey(), param.getFormKey());
                } else {
                    json = this.getByFlowNodeId(param.getFlowKey(), param.getNodeId(), param.getParentflowKey(), param.getFormKey());
                    if (json == null && StringUtil.isNotEmpty((String)param.getParentflowKey())) {
                        json = this.getByFlowKey(param.getParentflowKey(), "", param.getFormKey());
                    }
                }
            } else {
                json = this.getByInst(param.getFlowKey());
            }
        }
        if (StringUtil.isNotEmpty((String)param.getDataKey())) {
            json = this.getByDataKey(param.getDataKey(), param.getType());
        }
        boolean bl = isReadOnly = param.getType() == 2 || param.getType() == 5;
        if (json == null) {
            json = this.getByFormKey(param.getFormKey(), isReadOnly);
        }
        return json;
    }

    @Override
    public JsonNode getPermission(String formKey, String dataKey, Integer type) throws IOException {
        FormRigthParam param = new FormRigthParam();
        param.setFormKey(formKey);
        param.setFlowKey("");
        param.setParentflowKey("");
        param.setNodeId("");
        param.setType(type);
        param.setDataKey(dataKey);
        JsonNode json = this.getPermissionSetting(param);
        return this.calcFormPermission(json);
    }

    @Override
    public JsonNode getPermission(String formKey, String flowKey, String parentFlowKey, String nodeId, int type) throws IOException {
        FormRigthParam param = new FormRigthParam();
        param.setFormKey(formKey);
        param.setFlowKey(flowKey);
        param.setParentflowKey(parentFlowKey);
        param.setNodeId(nodeId);
        param.setType(type);
        JsonNode json = this.getPermissionSetting(param);
        return this.calcFormPermission(json);
    }

    @Override
    public JsonNode calcFormPermission(JsonNode permissionConf) throws IOException {
        ObjectNode tableJsons;
        Map profilesMap = this.permssionCalc.getCurrentProfiles();
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isEmpty((Object)permissionConf)) {
            return rtnJson;
        }
        if (BeanUtils.isNotEmpty((Object)permissionConf.get("subRowAuth"))) {
            rtnJson.set("subRowAuth", permissionConf.get("subRowAuth"));
        }
        if (BeanUtils.isNotEmpty((Object)(tableJsons = (ObjectNode)permissionConf.get("table")))) {
            ObjectNode rtnTableFieldJson = JsonUtil.getMapper().createObjectNode();
            ObjectNode rtnTableJson = JsonUtil.getMapper().createObjectNode();
            Iterator tableIt = tableJsons.fields();
            while (tableIt.hasNext()) {
                Map.Entry table = (Map.Entry)tableIt.next();
                JsonNode tableJson = tableJsons.get((String)table.getKey());
                JsonNode tableFieldJson = this.buildTablePermission(tableJson, profilesMap);
                rtnTableFieldJson.set((String)table.getKey(), tableFieldJson);
                boolean isMain = tableJson.get("main").asBoolean();
                if (isMain) continue;
                JsonNode tableRights = tableJson.get("rights");
                rtnTableJson.set((String)table.getKey(), tableRights);
            }
            rtnJson.set("fields", (JsonNode)rtnTableFieldJson);
            if (rtnTableJson.size() > 0) {
                rtnJson.set("table", (JsonNode)rtnTableJson);
            }
            if (permissionConf.get("opinion") != null || StringUtil.isEmpty((String)(permissionConf.get("opinion") + ""))) {
                return rtnJson;
            }
            ObjectNode rtnOpinionJson = JsonUtil.getMapper().createObjectNode();
            JsonNode opinionJson = permissionConf.get("opinion");
            if (BeanUtils.isNotEmpty((Object)opinionJson)) {
                Iterator opinionIt = opinionJson.fields();
                while (opinionIt.hasNext()) {
                    Map.Entry opinion = (Map.Entry)opinionIt.next();
                    JsonNode perJson = opinionJson.get((String)opinion.getKey());
                    String permission = this.calcPermission(perJson, profilesMap);
                    rtnOpinionJson.put((String)opinion.getKey(), permission);
                }
            }
            rtnJson.set("opinion", (JsonNode)rtnOpinionJson);
            return rtnJson;
        }
        return JsonUtil.getMapper().createObjectNode();
    }

    private JsonNode buildTablePermission(JsonNode tableJson, Map<String, Set<String>> profilesMap) throws IOException {
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        JsonNode fieldJsons = tableJson.get("fields");
        if (BeanUtils.isEmpty((Object)fieldJsons)) {
            return rtnJson;
        }
        Iterator fieldIt = fieldJsons.fields();
        while (fieldIt.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIt.next();
            JsonNode perJson = fieldJsons.get((String)field.getKey());
            String permission = this.calcPermission(perJson, profilesMap);
            rtnJson.put((String)field.getKey(), permission);
        }
        return rtnJson;
    }

    private String calcPermission(JsonNode perJson, Map<String, Set<String>> profilesMap) throws IOException {
        boolean hasRequired = this.hasRight(perJson, "required", profilesMap);
        String permission = "n";
        if (hasRequired) {
            permission = "b";
        } else {
            boolean hasWrite = this.hasRight(perJson, "write", profilesMap);
            if (hasWrite) {
                permission = "w";
            } else {
                boolean hasRead = this.hasRight(perJson, "read", profilesMap);
                if (hasRead) {
                    permission = "r";
                }
            }
        }
        return permission;
    }

    private boolean hasRight(JsonNode jsonObj, String type, Map<String, Set<String>> profilesMap) throws IOException {
        if (!jsonObj.has(type)) {
            return false;
        }
        JsonNode jsonArray = jsonObj.get(type);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode json = jsonArray.get(i);
            boolean hasRight = this.permssionCalc.hasRight(json.toString(), profilesMap);
            if (!hasRight) continue;
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void removeByFormKey(String formKey) {
        ((FormRightDao)this.baseMapper).removeByFormKey(formKey);
    }

    @Override
    public JsonNode getStartPermission(String formKey, String flowKey, String nodeId, String nextNodeId) throws IOException {
        JsonNode JsonNode2 = null;
        JsonNode2 = StringUtil.isNotEmpty((String)nodeId) ? this.getByFlowNodeId(flowKey, nodeId, "", formKey) : this.getByFlowKey(flowKey, "", formKey);
        if (BeanUtils.isEmpty((Object)JsonNode2)) {
            JsonNode2 = this.getByFormKey(formKey, false);
        }
        return this.calcFormPermission(JsonNode2);
    }

    @Override
    public List<FormRight> getByFlowKey(String flowKey) {
        return ((FormRightDao)this.baseMapper).getAllByFlowKey(flowKey);
    }

    @Override
    public List<Map<String, String>> getTableOrderBySn(String formKey) throws IOException {
        String formMetaKey = this.formMetaManager.getMetaKeyByFormKey(formKey);
        FormMeta formDef = this.formMetaManager.getByKey(formMetaKey);
        if (formDef != null) {
            List<Map<String, String>> retList = this.convertMapLower(formDef.getExpand());
            return retList;
        }
        return new ArrayList<Map<String, String>>();
    }

    @Override
    @Transactional
    public void importFormRights(String formRightsXml) {
        try {
            FormRightXml formRightList = (FormRightXml)JAXBUtil.unmarshall((String)formRightsXml, FormRightXml.class);
            List<FormRight> list = formRightList.getRightList();
            for (FormRight bpmFormRight : list) {
                FormRight right = ((FormRightDao)this.baseMapper).getByFlowNodeId(bpmFormRight.getFlowKey(), bpmFormRight.getNodeId(), bpmFormRight.getParentFlowKey(), bpmFormRight.getPermissionType());
                if (BeanUtils.isNotEmpty((Object)((Object)right))) {
                    bpmFormRight.setId(right.getId());
                    this.update((Model)bpmFormRight);
                    ThreadMsgUtil.addMsg((String)("\u6d41\u7a0b[" + bpmFormRight.getFlowKey() + "]\u4e2d\u8282\u70b9[ " + (Object)((Object)bpmFormRight) + " ]\u7684\u8868\u5355\u6388\u6743\u5df2\u7ecf\u5b58\u5728,\u66f4\u65b0\u6210\u529f"));
                    continue;
                }
                bpmFormRight.setId(UniqueIdUtil.getSuid());
                this.create((Model)bpmFormRight);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u5165\u8868\u5355\u6743\u9650\u5931\u8d25" + e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void removeByFlowKey(String flowKey, String parentFlowKey, int permissionType) {
        ((FormRightDao)this.baseMapper).removeByFlowKey(flowKey, parentFlowKey, permissionType);
    }

    @Override
    public JsonNode getDefaultByDesign(String formDefId, String expand, boolean isInstance) throws Exception {
        JsonNode expandJson = JsonUtil.toJsonNode((String)expand);
        if (BeanUtils.isEmpty((Object)expandJson)) {
            return JsonUtil.getMapper().createObjectNode();
        }
        List<Map<String, String>> lowList = this.convertMapLower(expand);
        List<FormField> fieldList = this.formFieldManager.getExtByFormId(formDefId);
        Map<String, List<FormField>> fieldMap = this.convertFormGroup(fieldList);
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        ObjectNode tableJson = JsonUtil.getMapper().createObjectNode();
        for (Map<String, String> entMap : lowList) {
            JsonNode json = this.buildTable(entMap, fieldMap, isInstance);
            if (json == null) continue;
            String entName = entMap.get("name_");
            tableJson.set(entName, json);
        }
        jsonObj.set("table", (JsonNode)tableJson);
        String opinionJson = JsonUtil.toJson((Object)expandJson.get("opinion"));
        JsonNode opinionJsonObj = this.buildOpinion(opinionJson, isInstance);
        if (opinionJsonObj != null) {
            jsonObj.set("opinion", opinionJsonObj);
        }
        return jsonObj;
    }

    @Override
    public String getByTeam(String flowKey, String nodeId) {
        return ((FormRightDao)this.baseMapper).getByTeam(flowKey, nodeId);
    }

    @Override
    @Transactional
    public void emptyAll(String flowKey) {
        ((FormRightDao)this.baseMapper).emptyAll(flowKey);
    }

    @Override
    public JsonNode getByDataKey(String dataKey, Integer type) throws IOException {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"data_key_", (Object)dataKey)).eq((Object)"permission_type_", (Object)type);
        FormRight formRight = (FormRight)((Object)((FormRightDao)this.baseMapper).selectOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)formRight))) {
            JsonNode rtnJson = JsonUtil.toJsonNode((String)formRight.getPermission());
            return rtnJson;
        }
        return null;
    }

    @Transactional
    public void removeByFormKeyType(String formKey, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"form_key_", (Object)formKey)).eq((Object)"permission_type_", (Object)type)).nested(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"flow_key_", (Object)"")).or()).isNull((Object)"flow_key_");
        });
        ((FormRightDao)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void removeByDataKey(String dataKey, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"data_key_", (Object)dataKey)).eq((Object)"permission_type_", (Object)type);
        ((FormRightDao)this.baseMapper).delete((Wrapper)wrapper);
    }
}

