package com.artfess.base.handler;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import javax.annotation.Resource;

import com.artfess.base.context.BaseContext;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;


/**
 * 字段自动填充处理器
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月8日
 */
@Component
public class AutoFillMetaObjectHandler implements MetaObjectHandler{
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Resource
	BaseContext baseContext;

	@Override
	public void insertFill(MetaObject metaObject) {
		logger.info("start insert fill ....");

		boolean hasCreateBy = metaObject.hasSetter("createBy");
		if(hasCreateBy){
			Object createByVal = this.getFieldValByName("createBy", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createBy", baseContext.getCurrentUserId(), metaObject);
			}
//			this.setFieldValByName("createBy", baseContext.getCurrentUserId(), metaObject);
		}
		boolean hasCreateName = metaObject.hasSetter("createName");
		if(hasCreateName){
			Object createByVal = this.getFieldValByName("createName", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createName", baseContext.getCurrentUserName(), metaObject);
			}
//			this.setFieldValByName("createName", baseContext.getCurrentUserName(), metaObject);
		}
		boolean hasCreateOrgId = metaObject.hasSetter("createOrgId");
		if(hasCreateOrgId){
			Object createByVal = this.getFieldValByName("createOrgId", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createOrgId", baseContext.getCurrentOrgId(), metaObject);
			}
//			this.setFieldValByName("createOrgId", baseContext.getCurrentOrgId(), metaObject);
		}
		boolean hasCreateOrgName = metaObject.hasSetter("createOrgName");
		if(hasCreateOrgName){
			Object createByVal = this.getFieldValByName("createOrgName", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createOrgName", baseContext.getCurrentOrgName(), metaObject);
			}
//			this.setFieldValByName("createOrgName", baseContext.getCurrentOrgName(), metaObject);
		}

		boolean hasCreateDeptId = metaObject.hasSetter("createDeptId");
		if(hasCreateDeptId){
			Object createByVal = this.getFieldValByName("createDeptId", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createDeptId", baseContext.getCurrentDeptName(), metaObject);
			}
//			this.setFieldValByName("createDeptId", baseContext.getCurrentDeptName(), metaObject);
		}

		boolean hasCreateDeptName = metaObject.hasSetter("createDeptName");
		if(hasCreateDeptName){
			Object createByVal = this.getFieldValByName("createDeptName", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createDeptName", baseContext.getCurrentDeptName(), metaObject);
			}
//			this.setFieldValByName("createDeptName", baseContext.getCurrentDeptName(), metaObject);
		}

		boolean hasCreateCompanyId = metaObject.hasSetter("createCompanyId");
		if(hasCreateCompanyId){
			Object createByVal = this.getFieldValByName("createCompanyId", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createCompanyId", baseContext.getCurrentDeptId(), metaObject);
			}
//			this.setFieldValByName("createCompanyId", baseContext.getCurrentDeptId(), metaObject);
		}

		boolean hasCreateCompanyName = metaObject.hasSetter("createCompanyName");
		if(hasCreateCompanyName){
			Object createByVal = this.getFieldValByName("createCompanyName", metaObject);
			if (createByVal == null) {
				this.setFieldValByName("createCompanyName", baseContext.getCurrentDeptName(), metaObject);
			}
//			this.setFieldValByName("createCompanyName", baseContext.getCurrentDeptName(), metaObject);
		}

		boolean hasCreateTime = metaObject.hasSetter("createTime");
		if(hasCreateTime){
			this.setFieldValByName("createTime", getSetterTypeOfLocal(metaObject, "createTime"), metaObject);
		}

		boolean hasLastTime = metaObject.hasSetter("lastTime");
		if(hasLastTime){
			this.setFieldValByName("lastTime", System.currentTimeMillis(), metaObject);
		}

		boolean hasCreateOrgFullId = metaObject.hasSetter("createOrgFullId");
		if(hasCreateOrgFullId){
			this.setFieldValByName("createOrgFullId", baseContext.getCurrentFullId(), metaObject);
		}
/*
	    String createBy = baseContext.getCurrentUserId();
		String createOrgId = baseContext.getCurrentOrgId();
		String createOrgName = baseContext.getCurrentOrgName();
		this.strictInsertFill(metaObject, "createBy", String.class, createBy);
		this.strictInsertFill(metaObject, "createOrgId", String.class, createOrgId);
		this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, (LocalDateTime)getSetterTypeOfLocal(metaObject, "createTime"));
*/
	}

	@Override
	public void updateFill(MetaObject metaObject) {
		logger.info("start update fill ....");

		boolean hasUpdateBy = metaObject.hasSetter("updateBy");
		if(hasUpdateBy){
			this.setFieldValByName("updateBy", baseContext.getCurrentUserId(), metaObject);
		}
		boolean hasUpdateName = metaObject.hasSetter("updateName");
		if(hasUpdateName){
			this.setFieldValByName("updateName", baseContext.getCurrentUserName(), metaObject);
		}
		boolean hasUpdateOrgId = metaObject.hasSetter("updateOrgId");
		if(hasUpdateOrgId){
			this.setFieldValByName("updateOrgId", baseContext.getCurrentOrgId(), metaObject);
		}
		boolean hasUpdateOrgName = metaObject.hasSetter("updateOrgName");
		if(hasUpdateOrgName){
			this.setFieldValByName("updateOrgName", baseContext.getCurrentOrgName(), metaObject);
		}
		boolean hasUpdateDeptId = metaObject.hasSetter("updateDeptId");
		if(hasUpdateDeptId){
			this.setFieldValByName("updateDeptId", baseContext.getCurrentDeptName(), metaObject);
		}
		boolean hasUpdateDeptName = metaObject.hasSetter("updateDeptName");
		if(hasUpdateDeptName){
			this.setFieldValByName("updateDeptName", baseContext.getCurrentDeptName(), metaObject);
		}

		boolean hasUpdateCompanyId = metaObject.hasSetter("updateCompanyId");
		if(hasUpdateCompanyId){
			this.setFieldValByName("updateCompanyId", baseContext.getCurrentDeptId(), metaObject);
		}
		boolean hasUpdateCompanyName = metaObject.hasSetter("updateCompanyName");
		if(hasUpdateCompanyName){
			this.setFieldValByName("updateCompanyName", baseContext.getCurrentDeptName(), metaObject);
		}

		boolean hasUpdateTime = metaObject.hasSetter("updateTime");
		if(hasUpdateTime){
			this.setFieldValByName("updateTime", getSetterTypeOfLocal(metaObject, "updateTime"), metaObject);
		}
		boolean hasLastTime = metaObject.hasSetter("lastTime");
		if(hasLastTime){
			this.setFieldValByName("lastTime", System.currentTimeMillis(), metaObject);
		}



	}

	/**
	 *  通过属性元信息获取指定属性的当前值
	 *  <p>主要解决不同的日期类型的字段当前值</p>
	 * @param metaObject
	 * @param propertyName
	 * @return
	 */
	private Object getSetterTypeOfLocal(MetaObject metaObject, String propertyName){
		Class<?> targetType = metaObject.getSetterType(propertyName);
		Object obj = null;
		if(LocalDateTime.class.equals(targetType)) {
			obj = LocalDateTime.now();
		}
		else if(LocalDate.class.equals(targetType)) {
			obj = LocalDate.now();
		}
		else if(Date.class.equals(targetType)) {
			obj = new Date();
		}
		return obj;
	}
}
