/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import java.util.HashMap;
import java.util.Map;

public enum LogType {
    BIZ("BIZ", "\u4e1a\u52a1\u65e5\u5fd7"),
    SYS("SYS", "\u7cfb\u7edf\u65e5\u5fd7"),
    OPERATION("OPERATION", "\u64cd\u4f5c\u65e5\u5fd7"),
    INTEGRATION("INTEGRATION", "\u96c6\u6210\u65e5\u5fd7"),
    WORKFLOW("WORKFLOW", "\u6d41\u7a0b\u65e5\u5fd7"),
    PERMISSION("PERMISSION", "\u6388\u6743\u65e5\u5fd7"),
    AUDIT("AUDIT", "\u5ba1\u8ba1\u65e5\u5fd7");

    private String id;
    private String name;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private LogType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static LogType fromId(String id) {
        switch (id) {
            case "BIZ": {
                return BIZ;
            }
            case "SYS": {
                return SYS;
            }
            case "INTEGRATION": {
                return INTEGRATION;
            }
            case "WORKFLOW": {
                return WORKFLOW;
            }
            case "PERMISSION": {
                return PERMISSION;
            }
        }
        throw new RuntimeException(String.format("\u65e0\u6548\u64cd\u4f5c\u7c7b\u578b\u7c7b\u578b\u201c%s\u201d\u3002", String.valueOf(id)));
    }

    public static Map<String, String> getData() {
        HashMap<String, String> map = new HashMap<String, String>(LogType.values().length);
        for (LogType c : LogType.values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }
}

