/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.entity;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.util.CommonUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.jsoup.helper.StringUtil;
import org.springframework.util.Assert;

public abstract class BaseTreeModel<T extends BaseTreeModel<?>>
extends BaseModel<T> {
    private static final long serialVersionUID = 1L;
    @TableId(value="ID_")
    @ApiModelProperty(value="\u4e3b\u952e")
    protected String id;
    @ApiModelProperty(value="\u7f16\u7801")
    @TableField(value="CODE_", condition="%s LIKE CONCAT('%%',#{%s},'%%')")
    protected String code;
    @ApiModelProperty(value="\u540d\u79f0")
    @TableField(value="NAME_", condition="%s LIKE CONCAT('%%',#{%s},'%%')")
    protected String name;
    @ApiModelProperty(value="\u4e0a\u7ea7_ID")
    @TableField(value="PARENT_ID_")
    protected String parentId;
    @ApiModelProperty(value="\u5b50\u8282\u70b9\u4e2a\u6570", hidden=true)
    @TableField(value="HAS_CHILDREN_")
    protected Integer hasChildren;
    @ApiModelProperty(value="ID_\u5168\u8def\u5f84", hidden=true)
    @TableField(value="FULL_ID_", condition="%s LIKE CONCAT(#{%s},'%%')")
    protected String fullId;
    @ApiModelProperty(value="\u540d\u79f0_\u5168\u8def\u5f84", hidden=true)
    @TableField(value="FULL_NAME_", condition="%s LIKE CONCAT(#{%s},'%%')")
    protected String fullName;
    @ApiModelProperty(value="\u6392\u5e8f\u53f7")
    @TableField(value="SN_")
    protected Integer sn;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(Integer hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getFullId() {
        return this.fullId;
    }

    public void setFullId(String fullId) {
        this.fullId = fullId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getSn() {
        return this.sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public void checkConstraints() {
        Assert.hasText((String)this.code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)this.name, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
    }

    public void checkConstraints(BaseTreeModel other) {
        this.checkConstraints();
        if (other != null) {
            Assert.isTrue((!this.getCode().equalsIgnoreCase(other.getCode()) ? 1 : 0) != 0, (String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002");
            Assert.isTrue((!this.getName().equalsIgnoreCase(other.getName()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002");
        }
    }

    public void buildFullIdAndName(BaseTreeModel parent) {
        String fullId = CommonUtil.createFileFullName(parent == null || parent.getFullId() == null ? "" : parent.getFullId(), this.getId().toString(), "");
        String fullName = CommonUtil.createFileFullName(parent == null || parent.getFullName() == null ? "" : parent.getFullName(), this.getName(), "");
        this.setFullId(fullId);
        this.setFullName(fullName);
    }

    @JsonIgnore(value=true)
    public boolean isNew() {
        return StringUtil.isBlank((String)this.id);
    }

    public boolean isUpdateName(String oldName) {
        return !this.isNew() && !this.name.equalsIgnoreCase(oldName);
    }
}

