/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.model.AlidayuSetting;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.util.TaoBaoUtil;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(SmsHandler.class);
    @Resource
    MessageLogManager messageLogManager;
    @Autowired
    AlidayuSetting alidayuSetting;
    @Resource
    MsgTemplateManager msgTemplateManager;

    @Override
    public String getType() {
        return NoticeMessageType.SMS.key();
    }

    @Override
    public boolean send(JmsMessage jmsMessage) {
        try {
            List recievers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            String templateCode = jmsMessage.getSmsTemplateNo();
            if (StringUtil.isEmpty((String)templateCode) && StringUtil.isNotEmpty((String)jmsMessage.getTemplateAlias())) {
                MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
                templateCode = msgTemplate.getSmsTemplateNo();
            }
            if (StringUtil.isEmpty((String)content) || BeanUtils.isEmpty((Object)recievers)) {
                return false;
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.alidayuSetting.getAppkey(), (String)this.alidayuSetting.getSecret());
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)this.alidayuSetting.getUrl());
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            for (JmsActor user : recievers) {
                if (StringUtil.isEmpty((String)user.getMobile())) continue;
                SendSmsRequest req = new SendSmsRequest();
                req.setMethod(MethodType.POST);
                req.setSmsUpExtendCode(this.alidayuSetting.getExtend());
                req.setSignName(this.alidayuSetting.getFreeSignName());
                jmsMessage.getExtendVars().remove("baseUrl");
                ArrayList parms = new ArrayList(jmsMessage.getExtendVars().keySet());
                jmsMessage.setParms(parms);
                String parmString = TaoBaoUtil.buildParams(jmsMessage);
                req.setTemplateParam(parmString);
                req.setPhoneNumbers(user.getMobile());
                if (StringUtil.isEmpty((String)templateCode)) {
                    templateCode = "SMS_0000";
                }
                req.setTemplateCode(templateCode);
                SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)req);
                logger.debug("\u53d1\u9001\u77ed\u4fe1\uff1a" + sendSmsResponse.getMessage());
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (ClientException e) {
            logger.error(e.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, e.getMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "\u77ed\u4fe1";
    }

    @Override
    public boolean getIsDefault() {
        return false;
    }

    @Override
    public boolean getSupportHtml() {
        return false;
    }
}

