package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核配置表
 *
 * @author huqi
 * @since 2025-11-11
 */
@Data
@TableName("biz_supplier_performance_evaluation_configuration")
@ApiModel(value="BizSupplierPerformanceEvaluationConfiguration对象", description="供应商绩效考核配置表")
public class BizSupplierPerformanceEvaluationConfiguration extends BizDelModel<BizSupplierPerformanceEvaluationConfiguration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "配置编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "配置名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "评分项")
    @TableField("ASSESSMENT_INDICATOR_NUM_")
    private Integer assessmentIndicatorNum;

    @ApiModelProperty(value = "总分值")
    @TableField("TOTAL_SCORE_")
    private Integer totalScore;

    @ApiModelProperty(value = "供应商分类ID（关联供应商分级表ID）")
    @TableField("SUPPLIER_CATEGORY_CONFIGURATION_ID_")
    private String supplierCategoryConfigurationId;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
