package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-客户抱怨（上年度）2
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-11
 */
@Data
@ApiModel(value="BizSupplierMainProductsPerformanceCustomerComplaints2对象", description="主营产品情况及质量业绩表-客户抱怨（上年度）2")
public class BizSupplierMainProductsPerformanceCustomerComplaints2 extends AutoFillFullModel<BizSupplierMainProductsPerformanceCustomerComplaints2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主营产品情况及质量业绩ID")
    @TableField("SUPPLIER_MAIN_PRODUCTS_PERFORMANCE_ID_")
    private String supplierMainProductsPerformanceId;

    @ApiModelProperty(value = "客户抱怨问题")
    @TableField("CUSTOMER_COMPLAINTS_")
    private String customerComplaints;

    @ApiModelProperty(value = "提出时间")
    @TableField("PROPOSED_TIME_")
    private LocalDate proposedTime;

    @ApiModelProperty(value = "控制措施")
    @TableField("CONTROL_MEASURES_")
    private String controlMeasures;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Long seq;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
