package com.artfess.gyl.supplierAccess.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入评审评分配置指标明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
@Data
@ApiModel(value="BizSupplierReviewConfigurationDetails对象", description="供应商准入评审评分配置指标明细表")
public class BizSupplierReviewConfigurationDetails extends AutoFillFullModel<BizSupplierReviewConfigurationDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评审配置ID")
    @TableField("REVIEW_CONFIGURATION_ID_")
    private String reviewConfigurationId;

    @ApiModelProperty(value = "指标类别名称")
    @TableField("CLASSIFICATION_NAME_")
    private String classificationName;

    @ApiModelProperty(value = "指标类别编码")
    @TableField("CLASSIFICATION_CODE_")
    private String classificationCode;

    @ApiModelProperty(value = "评审指标编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "评审内容")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    @TableField("WEIGHT_")
    private Float weight;

    @ApiModelProperty(value = "默认评分人ID")
    @TableField("RATING_ID_")
    private String ratingId;

    @ApiModelProperty(value = "默认评分人ACCOUNT")
    @TableField("RATING_ACCOUNT_")
    private String ratingAccount;

    @ApiModelProperty(value = "默认评分人")
    @TableField("RATING_NAME_")
    private String ratingName;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
