package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物资分类&基本物料分类关联表
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Data
@TableName("BIZ_SUPPLIER_MATERIAL_CATEGORY_DETAILS")
@ApiModel(value="BizSupplierMaterialCategoryDetails对象", description="物资分类&基本物料分类关联表")
public class BizSupplierMaterialCategoryDetails extends BizDelModel<BizSupplierMaterialCategoryDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "物资分类ID")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_ID_")
    private String supplierMaterialCategoryId;

    @ApiModelProperty(value = "物资分类CODE")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_CODE_")
    private String supplierMaterialCategoryCode;

    @ApiModelProperty(value = "基础物料分类ID")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
