package com.artfess.gyl.base.manager.impl;

import com.artfess.gyl.base.model.BizSupplierMaterialCategoryDetails;
import com.artfess.gyl.base.dao.BizSupplierMaterialCategoryDetailsDao;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 物资分类&基本物料分类关联表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Service
public class BizSupplierMaterialCategoryDetailsManagerImpl extends BaseManagerImpl<BizSupplierMaterialCategoryDetailsDao, BizSupplierMaterialCategoryDetails> implements BizSupplierMaterialCategoryDetailsManager {

    @Override
    public boolean bathBind(List<BizSupplierMaterialCategoryDetails> details) {
        List<String> ids = details.stream()
                .filter(f -> f.getCategoryId() != null)
                .map(BizSupplierMaterialCategoryDetails::getCategoryId)
                .distinct()
                .collect(Collectors.toList());

        if (ids.isEmpty()) {
            return false;
        }

        // 查询已存在的记录
        List<BizSupplierMaterialCategoryDetails> existList = this.list(
                new LambdaQueryWrapper<BizSupplierMaterialCategoryDetails>()
                        .in(BizSupplierMaterialCategoryDetails::getCategoryId, ids)
        );

        if (existList.isEmpty()) {
            return super.saveBatch(details);
        }

       // 构建已存在记录的复合键映射，避免重复查询
        Set<String> existKeys = existList.stream()
                .map(item -> buildCompositeKey(item.getCategoryId(), item.getSupplierMaterialCategoryId()))
                .collect(Collectors.toSet());

        // 过滤出需要新增的记录
        List<BizSupplierMaterialCategoryDetails> addList = details.stream()
                .filter(detail -> {
                    String compositeKey = buildCompositeKey(detail.getCategoryId(), detail.getSupplierMaterialCategoryId());
                    return !existKeys.contains(compositeKey);
                })
                .collect(Collectors.toList());

        return addList.isEmpty() || super.saveBatch(addList);
    }

    /**
     * 构建复合键，用于唯一性判断
     */
    private String buildCompositeKey(String categoryId, String supplierMaterialCategoryId) {
        return categoryId + ":" + supplierMaterialCategoryId;
    }

    @Override
    public boolean bathCancel(List<String> materialCategoryIds) {
        LambdaQueryWrapper<BizSupplierMaterialCategoryDetails> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizSupplierMaterialCategoryDetails::getCategoryId,materialCategoryIds);
        super.remove(wrapper);
        return true;
    }
}
