package com.artfess.gyl.thirdParty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;

/**
 *  前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-10
 */
@RestController
@RequestMapping("/bizCategory/v1/")
@Api(tags = "第三方数据-平台物料分类")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizCategoryController extends BaseController<BizCategoryManager, BizCategory> {

    @PostMapping(value="/queryPermission", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<BizCategory> queryPermission(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCategory> queryFilter) {
        return baseService.queryByPage(queryFilter);
    }
}
