package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizSupplierMaterialCategoryDetails;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryDetailsManager;

import java.util.List;

/**
 * 物资分类&基本物料分类关联表 前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@RestController
@RequestMapping("/bizSupplierMaterialCategoryDetails/v1/")
@Api(tags = "物资分类&基本物料分类关联")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierMaterialCategoryDetailsController extends BaseController<BizSupplierMaterialCategoryDetailsManager, BizSupplierMaterialCategoryDetails> {

    @PostMapping("/bathBind")
    @ApiOperation(value = "批量绑定")
    public CommonResult<String> updateStatus(@RequestParam List<BizSupplierMaterialCategoryDetails> details) {
        boolean res = baseService.bathBind(details);
        return new CommonResult(res?"绑定成功":"绑定失败");
    }

    @PostMapping("/bathCancel")
    @ApiOperation(value = "批量清除")
    public CommonResult<String> bathCancel(@RequestParam("materialCategoryIds") List<String> materialCategoryIds) {
        boolean res = baseService.bathCancel(materialCategoryIds);
        return new CommonResult(res?"清除成功":"清除失败");
    }

}
