package com.artfess.gyl.supplierAccess.manager;

import com.artfess.gyl.supplierAccess.dto.BizSupplierReviewConfigurationDto;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;

/**
 * 供应商准入评审评分配置表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
public interface BizSupplierReviewConfigurationManager extends BaseManager<BizSupplierReviewConfiguration> {

    /**
     * 保存供应商准入评审评分配置
     * @param dto
     * @return
     */
    Boolean saveModel(BizSupplierReviewConfigurationDto dto);

    /**
     * 根据id集合批量删除
     * @param ids
     * @return
     */
    Boolean batchDelete(String[] ids);

    /**
     * 修改供应商准入评审评分配置
     * @param dto
     * @return
     */
    Boolean updateModel(BizSupplierReviewConfigurationDto dto);

    /**
     * 供应商准入评审评分配置详情
     * @param id
     * @return
     */
    BizSupplierReviewConfigurationVo getInfo(String id);
}
