package com.artfess.gyl.supplierAccess.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.dto.BizSupplierReviewConfigurationDto;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.gyl.supplierAccess.manager.BizSupplierReviewConfigurationManager;

/**
 * 供应商准入评审评分配置表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-09
 */
@RestController
@RequestMapping("/bizSupplierReviewConfiguration/v1/")
@Api(tags = "供应商准入评审评分配置表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierReviewConfigurationController extends BaseController<BizSupplierReviewConfigurationManager, BizSupplierReviewConfiguration> {

    @PostMapping("/saveModel")
    @ApiOperation("保存供应商准入评审评分配置")
    public CommonResult<String> saveModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizSupplierReviewConfigurationDto dto) {
        Boolean result = baseService.saveModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        Boolean result = baseService.batchDelete(ids);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/updateModel")
    @ApiOperation("修改供应商准入评审评分配置")
    public CommonResult<String> updateModel(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizSupplierReviewConfigurationDto dto) {
        Boolean result = baseService.updateModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"修改成功");
    }

    @GetMapping("/getInfo/{id}")
    @ApiOperation("供应商准入评审评分配置详情")
    public BizSupplierReviewConfigurationVo getInfo(@ApiParam(name = "id", value = "实体id") @PathVariable String id){
        return baseService.getInfo(id);
    }
}
