package com.artfess.gyl.base.manager.impl;

import com.artfess.gyl.base.model.BizSupplierMaterialCategoryDetails;
import com.artfess.gyl.base.dao.BizSupplierMaterialCategoryDetailsDao;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 物资分类&基本物料分类关联表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Service
public class BizSupplierMaterialCategoryDetailsManagerImpl extends BaseManagerImpl<BizSupplierMaterialCategoryDetailsDao, BizSupplierMaterialCategoryDetails> implements BizSupplierMaterialCategoryDetailsManager {

    @Override
    public boolean bathBind(List<BizSupplierMaterialCategoryDetails> details) {
        return super.saveBatch(details);
    }

    @Override
    public boolean bathCancel(List<String> materialCategoryIds) {
        LambdaQueryWrapper<BizSupplierMaterialCategoryDetails> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizSupplierMaterialCategoryDetails::getCategoryId,materialCategoryIds);
        super.remove(wrapper);
        return true;
    }
}
