/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.thirdParty.manager.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.FluentUtil;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.thirdParty.dao.BizCategoryDao;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.vo.CategoryNumVo;
import com.artfess.gyl.utils.HttpUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BizCategoryManagerImpl
extends BaseManagerImpl<BizCategoryDao, BizCategory>
implements BizCategoryManager {
    @Resource
    private BizSupplierMaterialCategoryManager categoryManager;
    @Value(value="${zsj.synCategoryUrl}")
    private String synCategoryUrl;
    @Value(value="${zsj.getTokenUrl}")
    private String zsjGetTokenUrl;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public List<BizCategory> tree(QueryFilter<BizCategory> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryByPage((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()), orgId);
        List records = iPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        return this.buildCategoryTree(records);
    }

    @Override
    public List<CategoryNumVo> countByType(QueryFilter<BizCategory> queryFilter) {
        ArrayList<CategoryNumVo> dataList = new ArrayList<CategoryNumVo>();
        List categories = this.categoryManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierMaterialCategory::getStatus, (Object)1)).orderByAsc((Object[])new SFunction[]{BizSupplierMaterialCategory::getSeq, AutoFillModel::getCreateTime}));
        String orgId = ContextUtil.getCurrentOrgId();
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryByPage((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()), orgId);
        List records = iPage.getRecords();
        dataList.add(new CategoryNumVo("\u603b\u6570", records.size()));
        List fiterList = records.stream().filter(category -> category.getCategoryId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fiterList) && !CollectionUtils.isEmpty((Collection)categories)) {
            Map<String, String> categoryMap = categories.stream().collect(Collectors.toMap(BizSupplierMaterialCategory::getId, BizSupplierMaterialCategory::getName));
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (String categoryId2 : categoryMap.keySet()) {
                for (BizCategory item : fiterList) {
                    if (!item.getCategoryId().contains(categoryId2)) continue;
                    countMap.put(categoryId2, countMap.getOrDefault(categoryId2, 0) + 1);
                }
            }
            countMap.forEach((categoryId, count) -> dataList.add(new CategoryNumVo((String)categoryId, (String)categoryMap.get(categoryId), (int)count)));
        }
        return dataList;
    }

    @Override
    public List<BizCategory> queryUnconfiguredTree(QueryFilter<BizCategory> queryFilter) {
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryUnconfigured((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = iPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        return this.buildCategoryTree(records);
    }

    @Override
    public boolean synCategory(com.alibaba.fastjson.JSONObject json) {
        try {
            String userInfo;
            com.alibaba.fastjson.JSONObject jsonObject;
            String code;
            String token = this.getToken();
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            tokenMap.put("Authorization", token);
            if (json.getString("startTime") == null || json.getString("startTime").isEmpty()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -3);
                String defaultStartTime = sdf.format(calendar.getTime());
                json.put("startTime", (Object)defaultStartTime);
            }
            if ("0".equals(code = (jsonObject = JSON.parseObject((String)(userInfo = HttpUtils.post(this.synCategoryUrl, (Map<String, Object>)json, tokenMap, "application/json", 3000, 3000, "UTF-8")))).getString("code"))) {
                List categories = JSON.parseArray((String)jsonObject.getJSONObject("data").getJSONArray("records").toJSONString(), BizCategory.class);
                super.saveOrUpdateBatch((Collection)categories);
                return true;
            }
            String errorMsg = jsonObject.getString("msg");
            throw new Exception(errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<BizCategory> queryConfiguredTree(QueryFilter<BizCategory> queryFilter) {
        IPage<BizCategory> iPage = ((BizCategoryDao)this.baseMapper).queryConfigured((IPage<BizCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = iPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        return this.buildCategoryTree(records);
    }

    private List<BizCategory> buildCategoryTree(List<BizCategory> records) {
        HashMap<String, BizCategory> categoryMap = new HashMap<String, BizCategory>();
        ArrayList<BizCategory> rootCategories = new ArrayList<BizCategory>();
        for (BizCategory category : records) {
            categoryMap.put(category.getId(), category);
            if (!this.isRootCategory(category)) continue;
            rootCategories.add(category);
        }
        for (BizCategory category : records) {
            String parentId = category.getCatPid();
            if (this.isRootCategory(category) || !categoryMap.containsKey(parentId)) continue;
            BizCategory parent = (BizCategory)((Object)categoryMap.get(parentId));
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList<BizCategory>());
            }
            parent.getChildren().add(category);
        }
        return rootCategories;
    }

    private boolean isRootCategory(BizCategory category) {
        return "0".equals(category.getCatPid()) || StringUtils.isEmpty((CharSequence)category.getCatPid());
    }

    public String getToken() {
        String token = "";
        String redisKey = "zsjToken";
        Object redisToken = this.redisUtil.get(redisKey);
        if (BeanUtils.isEmpty((Object)redisToken)) {
            JSONObject jsonObject;
            String url = this.zsjGetTokenUrl;
            HashMap<String, String> getTokenMap = new HashMap<String, String>();
            String key = null;
            String tokenString = null;
            try {
                key = EncryptUtil.md5Hex((String)"cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                getTokenMap.put("key", key);
                getTokenMap.put("sysCode", "cgpt");
                tokenString = FluentUtil.post((String)url, null, getTokenMap);
            }
            catch (Exception e) {
                throw new BaseException("\u83b7\u53d6TOKEN\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (BeanUtils.isNotEmpty((Object)tokenString) && BeanUtils.isNotEmpty((Object)(jsonObject = JSONUtil.parseObj((String)tokenString)).get((Object)"value"))) {
                String tokenValue = "Bearer " + jsonObject.get((Object)"value").toString();
                this.redisUtil.set(redisKey, (Object)tokenValue, 3600L);
                token = tokenValue;
            }
        } else {
            token = redisToken.toString();
        }
        return token;
    }
}

