/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.ecologyOa.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.ecologyOa.manager.EcologyOaManager;
import com.artfess.gyl.ecologyOa.vo.CreateWorkVo;
import com.artfess.gyl.utils.RSAUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EcologyOaManagerImpl
implements EcologyOaManager {
    @Value(value="${ecologyOa.host}")
    private String host;
    @Value(value="${ecologyOa.spk}")
    private String spk;
    @Value(value="${ecologyOa.appid}")
    private String appid;
    @Value(value="${ecologyOa.secret}")
    private String secret;
    @Value(value="${ecologyOa.getTokenUrl}")
    private String getTokenUrl;
    @Value(value="${ecologyOa.getUserIdUrl}")
    private String getUserIdUrl;
    @Value(value="${ecologyOa.getTaskCountUrl}")
    private String getTaskCountUrl;
    @Value(value="${ecologyOa.getToDoWorkListUrl}")
    private String getToDoWorkListUrl;
    @Value(value="${ecologyOa.getHandledWorkListUrl}")
    private String getHandledWorkListUrl;
    @Value(value="${ecologyOa.getRequestWorkListUrl}")
    private String getRequestWorkListUrl;
    @Value(value="${ecologyOa.createWorkUrl}")
    private String createWorkUrl;
    @Value(value="${ecologyOa.deleteWorkUrl}")
    private String deleteWorkUrl;
    @Value(value="${ecologyOa.getSsoTokenUrl}")
    private String getSsoTokenUrl;
    @Value(value="${ecologyOa.ssoAppid}")
    private String ssoAppid;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public String getToken() {
        String result = null;
        Object oaToken = this.redisUtil.get("oaToken");
        if (BeanUtil.isNotEmpty((Object)oaToken, (String[])new String[0])) {
            return oaToken.toString();
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.host + this.getTokenUrl);
            httpPost.setHeader("appid", this.appid);
            httpPost.setHeader("secret", this.secret);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                JSONObject jsonObject = JSONUtil.parseObj((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                String code = jsonObject.getStr((Object)"code");
                if (!code.equals("0")) {
                    throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + jsonObject.getStr((Object)"msg"));
                }
                result = jsonObject.getStr((Object)"token");
                this.redisUtil.set("oaToken", (Object)result, 1740L);
            }
        }
        catch (IOException e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public String getOaUserId(String mobile) {
        String result = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.host + this.getUserIdUrl);
            uriBuilder.addParameter("mobile", mobile);
            URI uri = uriBuilder.build();
            HttpGet httpGet = new HttpGet(uri);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                JSONObject jsonObject = JSONUtil.parseObj((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                result = jsonObject.getStr((Object)"hrmBillid");
            }
        }
        catch (Exception e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public Integer getTaskCount() {
        Integer result = 0;
        String token = this.getToken();
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String oaUserId = this.getOaUserId(mobile);
        if (BeanUtils.isEmpty((Object)oaUserId)) {
            return result;
        }
        String encrypt = null;
        try {
            encrypt = RSAUtils.encrypt(this.spk, oaUserId);
        }
        catch (Exception e) {
            throw new BaseException("RSA\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.host + this.getTaskCountUrl);
            httpPost.setHeader("appid", this.appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                String s = EntityUtils.toString((HttpEntity)response.getEntity());
                result = Integer.valueOf(s.toString());
            }
        }
        catch (IOException e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public JSONArray getWorkList(String url) {
        return this.getToDoWorkList(url);
    }

    public JSONArray getToDoWorkList(String url) {
        JSONArray result = null;
        String token = this.getToken();
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String oaUserId = this.getOaUserId(mobile);
        if (BeanUtils.isEmpty((Object)oaUserId)) {
            return result;
        }
        String encrypt = null;
        try {
            encrypt = RSAUtils.encrypt(this.spk, oaUserId);
        }
        catch (Exception e) {
            throw new BaseException("RSA\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.host + url);
            httpPost.setHeader("appid", this.appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                result = JSONUtil.parseArray((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (IOException e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject createWork(CreateWorkVo createWorkVo, String createUserMobile) {
        String oaUserId;
        JSONObject result = null;
        String token = this.getToken();
        if (BeanUtils.isEmpty((Object)createUserMobile)) {
            createUserMobile = ContextUtil.getCurrentUser().getMobile();
        }
        if (BeanUtils.isEmpty((Object)(oaUserId = this.getOaUserId(createUserMobile)))) {
            throw new BaseException("\u8bf7\u63a8\u9001\u5f53\u524d\u7528\u6237\u5230\u6d41\u7a0b\u5ba1\u6279\u7cfb\u7edf");
        }
        String encrypt = null;
        try {
            encrypt = RSAUtils.encrypt(this.spk, oaUserId);
        }
        catch (Exception e) {
            throw new BaseException("RSA\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.host + this.createWorkUrl);
            httpPost.setHeader("appid", this.appid);
            httpPost.setHeader("token", token);
            httpPost.setHeader("userid", encrypt);
            String json = new Gson().toJson((Object)createWorkVo);
            StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                result = JSONUtil.parseObj((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (IOException e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public String getSsoToken() {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.host + this.getSsoTokenUrl);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("appid", this.ssoAppid));
            params.add(new BasicNameValuePair("loginid", ContextUtil.getCurrentUserAccount()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            System.out.println();
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u7cfb\u7edfssoToken\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }
}

