/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.base.dao.BizSupplierMaterialCategoryDetailsDao;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryDetailsManager;
import com.artfess.gyl.base.model.BizSupplierMaterialCategoryDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BizSupplierMaterialCategoryDetailsManagerImpl
extends BaseManagerImpl<BizSupplierMaterialCategoryDetailsDao, BizSupplierMaterialCategoryDetails>
implements BizSupplierMaterialCategoryDetailsManager {
    @Override
    public boolean bathBind(List<BizSupplierMaterialCategoryDetails> details) {
        List ids = details.stream().filter(f -> f.getCategoryId() != null).map(BizSupplierMaterialCategoryDetails::getCategoryId).distinct().collect(Collectors.toList());
        if (ids.isEmpty()) {
            return false;
        }
        List existList = this.list((Wrapper)new LambdaQueryWrapper().in(BizSupplierMaterialCategoryDetails::getCategoryId, ids));
        if (existList.isEmpty()) {
            return super.saveBatch(details);
        }
        Set existKeys = existList.stream().map(item -> this.buildCompositeKey(item.getCategoryId(), item.getSupplierMaterialCategoryId())).collect(Collectors.toSet());
        List addList = details.stream().filter(detail -> {
            String compositeKey = this.buildCompositeKey(detail.getCategoryId(), detail.getSupplierMaterialCategoryId());
            return !existKeys.contains(compositeKey);
        }).collect(Collectors.toList());
        return addList.isEmpty() || super.saveBatch(addList);
    }

    private String buildCompositeKey(String categoryId, String supplierMaterialCategoryId) {
        return categoryId + ":" + supplierMaterialCategoryId;
    }

    @Override
    public boolean bathCancel(List<String> materialCategoryIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizSupplierMaterialCategoryDetails::getCategoryId, materialCategoryIds);
        super.remove((Wrapper)wrapper);
        return true;
    }
}

