/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.utils;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OrgUtils {
    @Resource
    private BizEnterpriseManager enterpriseManager;

    public static QueryFilter addFilterByHisOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column, BizEnterpriseManager enterpriseManager) {
        IUser user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            CommonResult userNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if (BeanUtils.isNotEmpty((Object)orgInfo)) {
                orgCode = orgInfo.get("code").asText();
            }
            if ((userNode = ucFeignService.getUserById(userId)).getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                BizEnterprise enterprise = enterpriseManager.getByOrgIdOrCode(orgId, orgCode);
                queryFilter.addFilter(column, (Object)orgCode, QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
                if (BeanUtils.isNotEmpty((Object)((Object)enterprise))) {
                    queryFilter.addFilter(column, (Object)enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
                }
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        IUser user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            CommonResult userNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if (BeanUtils.isNotEmpty((Object)orgInfo)) {
                orgCode = orgInfo.get("code").asText();
            }
            if ((userNode = ucFeignService.getUserById(userId)).getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)orgCode, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }

    public static QueryFilter addFilterByUserOrgAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column) {
        IUser user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult userNode = ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("qrsk") || set.contains("ld") || set.contains("yyadmin"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                queryFilter.addFilter(column, (Object)orgId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }
}

