/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply3.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierApply3.dao.BizSupplierEnterpriseRegisterInformationDao;
import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierApply3.manager.BizSupplierAccessBasicInformation3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseCategory3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseGrading3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseQualification3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseRegisterInformationManager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsPerformance3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsSalesStatus3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainRawMaterialsSuppliers3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainSupplyMaterialCategory3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierOtherSpecialNotes3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionInspectionEquipment3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionProcessPerformance3Manager;
import com.artfess.gyl.supplierApply3.model.BizSupplierAccessBasicInformation3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseCategory3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseGrading3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseQualification3;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformance3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsSalesStatus3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainRawMaterialsSuppliers3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainSupplyMaterialCategory3;
import com.artfess.gyl.supplierApply3.model.BizSupplierOtherSpecialNotes3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionInspectionEquipment3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessPerformance3;
import com.artfess.gyl.supplierApply3.vo.SupplierRegisterVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEnterpriseRegisterInformationManagerImpl
extends BaseManagerImpl<BizSupplierEnterpriseRegisterInformationDao, BizSupplierEnterpriseRegisterInformation>
implements BizSupplierEnterpriseRegisterInformationManager {
    @Resource
    private BizSupplierAccessBasicInformation3Manager information3Manager;
    @Resource
    private BizSupplierEnterpriseCategory3Manager category3Manager;
    @Resource
    private BizSupplierEnterpriseGrading3Manager grading3Manager;
    @Resource
    private BizSupplierEnterpriseQualification3Manager qualification3Manager;
    @Resource
    private BizSupplierMainProductsPerformance3Manager productsPerformance3Manager;
    @Resource
    private BizSupplierMainProductsSalesStatus3Manager mainProductsSalesStatus3Manager;
    @Resource
    private BizSupplierMainRawMaterialsSuppliers3Manager suppliers3Manager;
    @Resource
    private BizSupplierMainSupplyMaterialCategory3Manager materialCategory3Manager;
    @Resource
    private BizSupplierOtherSpecialNotes3Manager notes3Manager;
    @Resource
    private BizSupplierProductionInspectionEquipment3Manager equipment3Manager;
    @Resource
    private BizSupplierProductionProcessPerformance3Manager processPerformance3Manager;
    @Resource
    private FileManager fileManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateModel(SupplierRegisterDTO dto) {
        if (dto.getEnterpriseId() == null) {
            throw new ApplicationException("\u8bf7\u5148\u4fdd\u5b58\u4f9b\u5e94\u5546\u57fa\u672c\u4fe1\u606f");
        }
        boolean save = super.saveOrUpdate((Object)dto);
        if (!save) {
            return false;
        }
        String id = dto.getId();
        Long version = dto.getVersion();
        String code = dto.getCode();
        if (code != null) {
            this.saveAllRelatedData(dto, id, version, code);
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public SupplierRegisterVo getById(String id) {
        BizSupplierEnterpriseRegisterInformation information = (BizSupplierEnterpriseRegisterInformation)super.get((Serializable)((Object)id));
        if (information == null) {
            return null;
        }
        SupplierRegisterVo vo = new SupplierRegisterVo(information);
        this.getAllRelatedData(vo, id, information.getVersion());
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public SupplierRegisterVo getBySupplierId(String supplierId) {
        BizSupplierEnterpriseRegisterInformation information = (BizSupplierEnterpriseRegisterInformation)((Object)super.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseRegisterInformation::getEnterpriseId, (Object)supplierId)).orderByDesc(BizDelModel::getVersion)).last("limit 1")));
        if (information == null) {
            return null;
        }
        SupplierRegisterVo vo = new SupplierRegisterVo(information);
        this.getAllRelatedData(vo, information.getId(), information.getVersion());
        return vo;
    }

    @Override
    public PageList<BizSupplierEnterpriseRegisterInformation> queryByVersion(QueryFilter<BizSupplierEnterpriseRegisterInformation> queryFilter) {
        queryFilter.addFilter("i.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizSupplierEnterpriseRegisterInformation> iPage = ((BizSupplierEnterpriseRegisterInformationDao)this.baseMapper).queryByVersion((IPage<BizSupplierEnterpriseRegisterInformation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierEnterpriseRegisterInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    private void saveAllRelatedData(SupplierRegisterDTO dto, String id, Long version, String code) {
        if (!StringUtils.isEmpty((String)id)) {
            this.deleteRelatedDataByCode(id, code, version);
        }
        if ("-1".equals(code)) {
            this.processAllModules(dto, id, version);
        } else {
            this.processSingleModule(dto, id, version, code);
        }
    }

    private void processAllModules(SupplierRegisterDTO dto, String id, Long version) {
        this.processBasicInformation(dto.getBasicInformation(), id, version);
        this.processCategoryData(dto.getEnterpriseCategory(), id, version);
        this.processGradingData(dto.getEnterpriseGrading(), id, version);
        this.processSuppliersData(dto.getSuppliers(), id, version);
        this.processMaterialCategoryData(dto.getCategory(), id, version);
        this.processOtherSpecialNotesData(dto.getOtherSpecialNotes(), id, version);
        this.processProdEquipmentData(dto, id, version);
        this.processMonitEquipmentData(dto, id, version);
        this.processQualificationData(dto.getQualification(), version);
        this.processProductsPerformanceData(dto.getPerformance(), id, version);
        this.processProcessPerformanceData(dto.getProcessPerformance(), id, version);
        this.processMainProductsSalesData(dto.getSalesStatus(), id, version);
    }

    private void processSingleModule(SupplierRegisterDTO dto, String id, Long version, String code) {
        switch (code) {
            case "1": {
                this.processBasicInformation(dto.getBasicInformation(), id, version);
                break;
            }
            case "4": {
                this.processSuppliersData(dto.getSuppliers(), id, version);
                break;
            }
            case "5": {
                this.processMaterialCategoryData(dto.getCategory(), id, version);
                break;
            }
            case "6": {
                this.processOtherSpecialNotesData(dto.getOtherSpecialNotes(), id, version);
                break;
            }
            case "7": {
                this.processProdEquipmentData(dto, id, version);
                break;
            }
            case "9": {
                this.processProductsPerformanceData(dto.getPerformance(), id, version);
                break;
            }
            case "10": {
                this.processProcessPerformanceData(dto.getProcessPerformance(), id, version);
                break;
            }
            case "11": {
                this.processMainProductsSalesData(dto.getSalesStatus(), id, version);
                break;
            }
            case "12": {
                this.processMonitEquipmentData(dto, id, version);
            }
        }
    }

    private void processBasicInformation(BizSupplierAccessBasicInformation3 entity, String id, Long version) {
        if (entity != null) {
            entity.setId(null);
            entity.setSupplierEnterpriseId(id);
            entity.setVersion(version);
            this.information3Manager.save((Object)entity);
        }
    }

    private void processCategoryData(List<BizSupplierEnterpriseCategory3> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setId(null);
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
            });
            this.category3Manager.saveBatch(list);
        }
    }

    private void processGradingData(List<BizSupplierEnterpriseGrading3> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setId(null);
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
            });
            this.grading3Manager.saveBatch(list);
        }
    }

    private void processSuppliersData(List<BizSupplierMainRawMaterialsSuppliers3> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.suppliers3Manager.saveBatch(list);
        }
    }

    private void processMaterialCategoryData(List<BizSupplierMainSupplyMaterialCategory3> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.materialCategory3Manager.saveBatch(list);
        }
    }

    private void processOtherSpecialNotesData(BizSupplierOtherSpecialNotes3 entity, String id, Long version) {
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            entity.setSupplierEnterpriseId(id);
            entity.setVersion(version);
            entity.setId(null);
            this.notes3Manager.save((Object)entity);
            List<DefaultFile> files = entity.getFiles();
            if (files != null && files.size() > 0) {
                List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
                this.fileManager.removeFileByBizId(entity.getId(), fileIds);
                this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
            } else {
                this.fileManager.removeFileByBizId(entity.getId(), null);
            }
        }
    }

    private void processProdEquipmentData(SupplierRegisterDTO dto, String id, Long version) {
        ArrayList<BizSupplierProductionInspectionEquipment3> equipmentList = new ArrayList<BizSupplierProductionInspectionEquipment3>();
        if (CollectionUtils.isNotEmpty(dto.getProdEquipment())) {
            equipmentList.addAll(dto.getProdEquipment());
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            equipmentList.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.equipment3Manager.saveBatch(equipmentList);
        }
    }

    private void processMonitEquipmentData(SupplierRegisterDTO dto, String id, Long version) {
        ArrayList<BizSupplierProductionInspectionEquipment3> equipmentList = new ArrayList<BizSupplierProductionInspectionEquipment3>();
        if (CollectionUtils.isNotEmpty(dto.getMonitEquipment())) {
            equipmentList.addAll(dto.getMonitEquipment());
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            equipmentList.forEach(entity -> {
                entity.setSupplierEnterpriseId(id);
                entity.setVersion(version);
                entity.setId(null);
            });
            this.equipment3Manager.saveBatch(equipmentList);
        }
    }

    private void processQualificationData(List<BizSupplierEnterpriseQualification3> list, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setVersion(version);
                entity.setId(null);
            });
            this.qualification3Manager.saveBatch(list);
        }
    }

    private void processProductsPerformanceData(BizSupplierMainProductsPerformance3 entity, String id, Long version) {
        if (entity != null) {
            this.productsPerformance3Manager.fillModel(entity, id, version);
        }
    }

    private void processMainProductsSalesData(List<BizSupplierMainProductsSalesStatus3> list, String id, Long version) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(entity -> {
                entity.setVersion(version);
                entity.setId(null);
                entity.setSupplierEnterpriseId(id);
            });
            this.mainProductsSalesStatus3Manager.saveBatch(list);
            for (BizSupplierMainProductsSalesStatus3 salesStatus3 : list) {
                List<DefaultFile> files = salesStatus3.getFiles();
                if (files != null && files.size() > 0) {
                    List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
                    this.fileManager.removeFileByBizId(salesStatus3.getId(), fileIds);
                    this.fileManager.updateFileBizIdByIds(fileIds, salesStatus3.getId());
                    continue;
                }
                this.fileManager.removeFileByBizId(salesStatus3.getId(), null);
            }
        }
    }

    private void processProcessPerformanceData(BizSupplierProductionProcessPerformance3 entity, String id, Long version) {
        if (entity != null) {
            this.processPerformance3Manager.fillModel(entity, id, version);
        }
    }

    private void getAllRelatedData(SupplierRegisterVo vo, String id, Long version) {
        vo.setBasicInformation(this.getBasicInformation(id));
        vo.setSuppliers(this.getSuppliersData(id));
        vo.setCategory(this.getMaterialCategoryData(id));
        vo.setOtherSpecialNotes(this.getOtherSpecialNotesData(id));
        Map<String, List<BizSupplierProductionInspectionEquipment3>> equipmentMap = this.getEquipmentData(id);
        vo.setProdEquipment(equipmentMap.getOrDefault("1", Collections.emptyList()));
        vo.setMonitEquipment(equipmentMap.getOrDefault("2", Collections.emptyList()));
        vo.setPerformance(this.getProductsPerformanceData(id));
        vo.setProcessPerformance(this.getProcessPerformanceData(id));
        vo.setSalesStatus(this.getProcessMainProductsSalesData(id));
    }

    private BizSupplierAccessBasicInformation3 getBasicInformation(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierAccessBasicInformation3::getSupplierEnterpriseId, (Object)id);
        return (BizSupplierAccessBasicInformation3)((Object)this.information3Manager.getOne((Wrapper)query));
    }

    private List<BizSupplierMainRawMaterialsSuppliers3> getSuppliersData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainRawMaterialsSuppliers3::getSupplierEnterpriseId, (Object)id);
        return this.suppliers3Manager.list((Wrapper)query);
    }

    private List<BizSupplierMainSupplyMaterialCategory3> getMaterialCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainSupplyMaterialCategory3::getSupplierEnterpriseId, (Object)id);
        return this.materialCategory3Manager.list((Wrapper)query);
    }

    private BizSupplierOtherSpecialNotes3 getOtherSpecialNotesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierOtherSpecialNotes3::getSupplierEnterpriseId, (Object)id);
        return (BizSupplierOtherSpecialNotes3)((Object)this.notes3Manager.getOne((Wrapper)query));
    }

    private Map<String, List<BizSupplierProductionInspectionEquipment3>> getEquipmentData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierProductionInspectionEquipment3::getSupplierEnterpriseId, (Object)id);
        return this.equipment3Manager.list((Wrapper)query).stream().collect(Collectors.groupingBy(BizSupplierProductionInspectionEquipment3::getDeviceType));
    }

    private List<BizSupplierEnterpriseQualification3> getQualificationData(Long version) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizDelModel::getVersion, (Object)version);
        return this.qualification3Manager.list((Wrapper)query);
    }

    private List<BizSupplierMainProductsSalesStatus3> getProcessMainProductsSalesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainProductsSalesStatus3::getSupplierEnterpriseId, (Object)id);
        return this.mainProductsSalesStatus3Manager.list((Wrapper)query);
    }

    private BizSupplierMainProductsPerformance3 getProductsPerformanceData(String id) {
        return this.productsPerformance3Manager.getModel(id);
    }

    private BizSupplierProductionProcessPerformance3 getProcessPerformanceData(String id) {
        return this.processPerformance3Manager.getModel(id);
    }

    private void deleteRelatedDataByCode(String id, String code, Long version) {
        if ("-1".equals(code)) {
            this.deleteAllModules(id, version);
        } else {
            this.deleteSingleModule(id, code, version);
        }
    }

    private void deleteAllModules(String id, Long version) {
        this.deleteBasicInformation(id);
        this.deleteCategoryData(id);
        this.deleteGradingData(id);
        this.deleteSuppliersData(id);
        this.deleteMaterialCategoryData(id);
        this.deleteOtherSpecialNotesData(id);
        this.deleteEquipmentData(id, null);
        this.deleteQualificationData(version);
        this.deleteProductsPerformanceData(id);
        this.deleteProcessPerformanceData(id);
        this.deleteProcessMainProductsSalesData(id);
    }

    private void deleteSingleModule(String id, String code, Long version) {
        switch (code) {
            case "1": {
                this.deleteBasicInformation(id);
                break;
            }
            case "2": {
                this.deleteCategoryData(id);
                break;
            }
            case "3": {
                this.deleteGradingData(id);
                break;
            }
            case "4": {
                this.deleteSuppliersData(id);
                break;
            }
            case "5": {
                this.deleteMaterialCategoryData(id);
                break;
            }
            case "6": {
                this.deleteOtherSpecialNotesData(id);
                break;
            }
            case "7": {
                this.deleteEquipmentData(id, "1");
                break;
            }
            case "9": {
                this.deleteProductsPerformanceData(id);
                break;
            }
            case "10": {
                this.deleteProcessPerformanceData(id);
                break;
            }
            case "11": {
                this.deleteProcessMainProductsSalesData(id);
                break;
            }
            case "12": {
                this.deleteEquipmentData(id, "2");
            }
        }
    }

    private void deleteBasicInformation(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierAccessBasicInformation3::getSupplierEnterpriseId, (Object)id);
        this.information3Manager.remove((Wrapper)query);
    }

    private void deleteCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseCategory3::getSupplierEnterpriseId, (Object)id);
        this.category3Manager.remove((Wrapper)query);
    }

    private void deleteGradingData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierEnterpriseGrading3::getSupplierEnterpriseId, (Object)id);
        this.grading3Manager.remove((Wrapper)query);
    }

    private void deleteSuppliersData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainRawMaterialsSuppliers3::getSupplierEnterpriseId, (Object)id);
        this.suppliers3Manager.remove((Wrapper)query);
    }

    private void deleteMaterialCategoryData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainSupplyMaterialCategory3::getSupplierEnterpriseId, (Object)id);
        this.materialCategory3Manager.remove((Wrapper)query);
    }

    private void deleteOtherSpecialNotesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierOtherSpecialNotes3::getSupplierEnterpriseId, (Object)id);
        this.notes3Manager.remove((Wrapper)query);
    }

    private void deleteData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierOtherSpecialNotes3::getSupplierEnterpriseId, (Object)id);
        this.notes3Manager.remove((Wrapper)query);
    }

    private void deleteEquipmentData(String id, String deviceType) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierProductionInspectionEquipment3::getSupplierEnterpriseId, (Object)id);
        if (deviceType != null) {
            query.eq(BizSupplierProductionInspectionEquipment3::getDeviceType, (Object)deviceType);
        }
        this.equipment3Manager.remove((Wrapper)query);
    }

    private void deleteQualificationData(Long version) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizDelModel::getVersion, (Object)version);
        this.qualification3Manager.remove((Wrapper)query);
    }

    private void deleteProductsPerformanceData(String id) {
        this.productsPerformance3Manager.deleteModelById(id);
    }

    private void deleteProcessPerformanceData(String id) {
        this.processPerformance3Manager.deleteModelById(id);
    }

    private void deleteProcessMainProductsSalesData(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BizSupplierMainProductsSalesStatus3::getSupplierEnterpriseId, (Object)id);
        this.mainProductsSalesStatus3Manager.remove((Wrapper)query);
    }
}

