/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply3.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierApply3.dao.BizSupplierMainProductsPerformance3Dao;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsPerformance3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsPerformanceCustomerComplaints3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsQualityPerformance3Manager;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformance3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformanceCustomerComplaints3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsQualityPerformance3;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierMainProductsPerformance3ManagerImpl
extends BaseManagerImpl<BizSupplierMainProductsPerformance3Dao, BizSupplierMainProductsPerformance3>
implements BizSupplierMainProductsPerformance3Manager {
    @Resource
    private BizSupplierMainProductsPerformanceCustomerComplaints3Manager complaints3Manager;
    @Resource
    private FileManager fileManager;
    @Resource
    private BizSupplierMainProductsQualityPerformance3Manager qualityPerformance3Manager;

    @Override
    public boolean fillModel(BizSupplierMainProductsPerformance3 performance3, String id, Long version) {
        if (performance3 != null) {
            performance3.setId(null);
            performance3.setSupplierEnterpriseId(id);
            performance3.setVersion(version);
            if (!super.save((Object)performance3)) {
                throw new ApplicationException("\u4e3b\u8425\u4ea7\u54c1\u60c5\u51b5\u53ca\u8d28\u91cf\u4e1a\u7ee9\u4fdd\u5b58\u5931\u8d25");
            }
            List<DefaultFile> files = performance3.getFiles();
            if (files != null && files.size() > 0) {
                List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
                this.fileManager.removeFileByBizId(performance3.getId(), fileIds);
                this.fileManager.updateFileBizIdByIds(fileIds, performance3.getId());
            } else {
                this.fileManager.removeFileByBizId(performance3.getId(), null);
            }
            if (performance3.getComplaints() != null && !performance3.getComplaints().isEmpty()) {
                List complaints3List = performance3.getComplaints().stream().peek(complaint -> {
                    complaint.setId(null);
                    complaint.setSupplierMainProductsPerformanceId(performance3.getId());
                    complaint.setVersion(performance3.getVersion());
                }).collect(Collectors.toList());
                this.complaints3Manager.saveBatch(complaints3List);
            }
            if (performance3.getQualityPerformance() != null && !performance3.getQualityPerformance().isEmpty()) {
                List qualityPerformance3List = performance3.getQualityPerformance().stream().peek(qualityPerformance3 -> {
                    qualityPerformance3.setId(null);
                    qualityPerformance3.setSupplierMainProductsPerformanceId(performance3.getId());
                    qualityPerformance3.setVersion(performance3.getVersion());
                }).collect(Collectors.toList());
                this.qualityPerformance3Manager.saveBatch(qualityPerformance3List);
            }
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public BizSupplierMainProductsPerformance3 getModel(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizSupplierMainProductsPerformance3::getSupplierEnterpriseId, (Object)id);
        BizSupplierMainProductsPerformance3 performance = (BizSupplierMainProductsPerformance3)((Object)this.getOne((Wrapper)queryWrapper));
        if (performance == null) {
            return null;
        }
        String performanceId = performance.getId();
        LambdaQueryWrapper complaintsQuery = new LambdaQueryWrapper();
        complaintsQuery.eq(BizSupplierMainProductsPerformanceCustomerComplaints3::getSupplierMainProductsPerformanceId, (Object)performanceId);
        List complaintsList = this.complaints3Manager.list((Wrapper)complaintsQuery);
        LambdaQueryWrapper qualityQuery = new LambdaQueryWrapper();
        qualityQuery.eq(BizSupplierMainProductsQualityPerformance3::getSupplierMainProductsPerformanceId, (Object)performanceId);
        List qualityList = this.qualityPerformance3Manager.list((Wrapper)qualityQuery);
        List<BizSupplierMainProductsPerformanceCustomerComplaints3> performanceComplaints = complaintsList.stream().filter(complaint -> complaint.getSupplierMainProductsPerformanceId().equals(performance.getId())).collect(Collectors.toList());
        performance.setComplaints(performanceComplaints);
        List<BizSupplierMainProductsQualityPerformance3> performanceQuality = qualityList.stream().filter(quality -> quality.getSupplierMainProductsPerformanceId().equals(performance.getId())).collect(Collectors.toList());
        performance.setQualityPerformance(performanceQuality);
        return performance;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteModelById(String id) {
        try {
            BizSupplierMainProductsPerformance3 performance4 = (BizSupplierMainProductsPerformance3)((Object)super.getOne((Wrapper)new LambdaQueryWrapper().eq(BizSupplierMainProductsPerformance3::getSupplierEnterpriseId, (Object)id)));
            if (performance4 == null) {
                return true;
            }
            String mainId = performance4.getId();
            LambdaQueryWrapper qualityWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierMainProductsQualityPerformance3::getSupplierMainProductsPerformanceId, (Object)mainId);
            this.qualityPerformance3Manager.remove((Wrapper)qualityWrapper);
            LambdaQueryWrapper complaintsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierMainProductsPerformanceCustomerComplaints3::getSupplierMainProductsPerformanceId, (Object)mainId);
            this.complaints3Manager.remove((Wrapper)complaintsWrapper);
            boolean removeMain = super.removeById((Serializable)((Object)mainId));
            if (!removeMain) {
                throw new ApplicationException("\u4e3b\u8425\u4ea7\u54c1\u60c5\u51b5\u53ca\u8d28\u91cf\u4e1a\u7ee9\u4e3b\u8868\u5220\u9664\u5931\u8d25");
            }
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("\u5220\u9664\u4e3b\u8425\u4ea7\u54c1\u60c5\u51b5\u53ca\u8d28\u91cf\u4e1a\u7ee9\u5931\u8d25: " + e.getMessage());
        }
    }
}

