/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.vo.EvaluationOptVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizSupplierPerformanceEvaluation/v1/"})
@Api(tags={"\u4f9b\u5e94\u5546\u7ee9\u6548\u8003\u6838-\u8003\u6838\u8bc4\u4ef7"})
@ApiGroup(group={"group_biz_gyl"})
public class BizSupplierPerformanceEvaluationController
extends BaseController<BizSupplierPerformanceEvaluationManager, BizSupplierPerformanceEvaluation> {
    @PostMapping(value={"/saveModel"})
    @ApiOperation(value="\u4fdd\u5b58\u4f9b\u5e94\u5546\u7ee9\u6548\u8003\u6838\u914d\u7f6e")
    public CommonResult<String> saveModel(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Valid @RequestBody EvaluationDTO dto) {
        Boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).saveModel(dto);
        if (!result.booleanValue()) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)((Object)dto), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateModel"})
    @ApiOperation(value="\u7f16\u8f91\u4f9b\u5e94\u5546\u7ee9\u6548\u8003\u6838\u914d\u7f6e")
    public CommonResult<String> updateModel(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Valid @RequestBody EvaluationDTO dto) {
        Boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).updateModel(dto);
        if (!result.booleanValue()) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)((Object)dto), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/getModel/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<String> getModel(@PathVariable(value="id") String id) {
        EvaluationVo model = ((BizSupplierPerformanceEvaluationManager)this.baseService).getModelById(id);
        return CommonResult.success((Object)((Object)model), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/getUserModel/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<String> getModelByUser(@PathVariable(value="id") String id) {
        EvaluationOptVo model = ((BizSupplierPerformanceEvaluationManager)this.baseService).getModelByUser(id);
        return CommonResult.success((Object)((Object)model), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/getRatingUser/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u8bc4\u5206\u60c5\u51b5")
    public CommonResult<String> getUserRatings(@PathVariable(value="id") String id) {
        List<BizSupplierPerformanceEvaluationRatingUser> userRatings = ((BizSupplierPerformanceEvaluationManager)this.baseService).getUserRatings(id);
        return CommonResult.success(userRatings, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a-\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizSupplierPerformanceEvaluation> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("INITIATOR_ACCOUNT_", (Object)user.getAccount(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/queryByUser"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e13\u5bb6-\u6839\u636e\u7528\u6237\u67e5\u8be2\u5ba1\u8bc4")
    public PageList<EvaluationVo> queryByUser(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryByUser(queryFilter, user.getAccount());
    }

    @PostMapping(value={"/queryByHistory"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a-\u5206\u9875\u67e5\u8be2\u5386\u53f2\u8003\u6838\u6570\u636e")
    public PageList<BizSupplierPerformanceEvaluation> queryByHistory(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)"1", QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/queryByEarly"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f9b\u5e94\u5546-\u6839\u636e\u4f9b\u5e94\u5546\u67e5\u8be2\u9884\u8b66\u901a\u77e5")
    public PageList<EvaluationVo> queryByEarly(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("nt.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("eva.SUPPLIER_ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryByEarly(queryFilter);
    }

    @PostMapping(value={"/queryBySupplier"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f9b\u5e94\u5546-\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizSupplierPerformanceEvaluation> queryBySupplier(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("SUPPLIER_ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/queryByManagement"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a-\u4f01\u4e1a\u7ba1\u7406\u754c\u9762")
    public PageList<EvaluationVo> queryByManagement(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("nt.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("eva.INITIATOR_ACCOUNT_", (Object)user.getAccount(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryByEarly(queryFilter);
    }

    @PostMapping(value={"/userRating"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u5206")
    public CommonResult<String> userRating(@RequestBody List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).userRating(ratingList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success(ratingList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/userEva"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u4ef7")
    public CommonResult<String> userEva(@RequestBody ResultEvaDTO dto) {
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).userEva(dto);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)dto, (String)"\u64cd\u4f5c\u6210\u529f");
    }
}

