/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationDao;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRating;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationDao, BizSupplierPerformanceEvaluation>
implements BizSupplierPerformanceEvaluationManager {
    @Resource
    private BizSupplierPerformanceEvaluationRatingManager ratingManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;
    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;
    @Resource
    private BizSupplierPerformanceEvaluationApprovalRecordManager recordManager;
    @Resource
    private FileManager fileManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveModel(EvaluationDTO dto) {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        dto.setInitiatorId(user.getUserId());
        dto.setInitiatorAccount(user.getAccount());
        dto.setInitiatorName(user.getFullname());
        dto.setStatus("2");
        dto.setAssessmentStartDate(LocalDate.now());
        List<BizSupplierPerformanceEvaluationRating> details = dto.getDetails();
        Asserts.notNull(details, (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        int totalScore = details.stream().mapToInt(BizSupplierPerformanceEvaluationRating::getScore).sum();
        dto.setTotalScore(totalScore);
        boolean save = super.save((Object)dto);
        if (!save) {
            return false;
        }
        for (BizSupplierPerformanceEvaluationRating item : details) {
            item.setId(null);
            item.setPerformanceEvaluationId(dto.getId());
            item.setStatus("0");
        }
        boolean saveBatch = this.ratingManager.saveBatch(details);
        if (!saveBatch) {
            throw new ApplicationException("\u8be6\u60c5\u66f4\u65b0\u5931\u8d25");
        }
        BizSupplierPerformanceEvaluationApprovalRecord record = new BizSupplierPerformanceEvaluationApprovalRecord();
        record.setStatus(dto.getStatus());
        record.setPerformanceEvaluationId(dto.getId());
        record.setApprovalId(user.getUserId());
        record.setApprovalAccount(user.getAccount());
        record.setApprovalName(user.getFullname());
        record.setApprovalOrgId(ContextUtil.getCurrentOrgId());
        record.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        record.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        record.setApprovalResult("1");
        this.recordManager.fillModel(record);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateModel(EvaluationDTO dto) {
        List<BizSupplierPerformanceEvaluationRating> details = dto.getDetails();
        Asserts.notNull(details, (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        int totalScore = details.stream().mapToInt(BizSupplierPerformanceEvaluationRating::getScore).sum();
        dto.setTotalScore(totalScore);
        boolean update = super.updateById((Object)dto);
        if (!update) {
            return false;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)dto.getId());
        this.ratingManager.remove((Wrapper)wrapper);
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(dto.getId());
            item.setStatus("0");
        });
        boolean saveBatch = this.ratingManager.saveBatch(details);
        if (!saveBatch) {
            throw new ApplicationException("\u8be6\u60c5\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationVo getModelById(String id) {
        List<BizSupplierPerformanceEvaluationApprovalRecord> records;
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationVo vo = new EvaluationVo(evaluation);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)id);
        List ratings = this.ratingManager.list((Wrapper)wrapper);
        if (ratings != null && !ratings.isEmpty()) {
            vo.setDetails(ratings);
        }
        LambdaQueryWrapper notificationWrapper = new LambdaQueryWrapper();
        notificationWrapper.eq(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, (Object)id);
        List notifications = this.notificationManager.list((Wrapper)notificationWrapper);
        if (notifications != null && !notifications.isEmpty()) {
            BizSupplierPerformanceEvaluationCorrectionReport report;
            BizSupplierPerformanceEvaluationNotification notification = (BizSupplierPerformanceEvaluationNotification)((Object)notifications.get(0));
            vo.setNotification(notification);
            if (evaluation.getProcessType() != null && evaluation.getProcessType().equals("2") && (report = this.notificationManager.getReport(notification.getId())) != null) {
                vo.setReport(report);
                List files = this.fileManager.queryFileByBizId(report.getId());
                report.setFiles(files);
            }
        }
        if ((records = this.getRecords(id)) != null && !records.isEmpty()) {
            vo.setRecords(records);
        }
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationVo getModelByUser(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationVo vo = new EvaluationVo(evaluation);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)id);
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (!user.isAdmin()) {
            wrapper.eq(BizSupplierPerformanceEvaluationRating::getRatingAccount, (Object)user.getAccount());
        }
        List ratings = this.ratingManager.list((Wrapper)wrapper);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    public PageList<EvaluationVo> queryByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByUser((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account);
        return new PageList(iPage);
    }

    @Override
    public PageList<EvaluationVo> queryByEarly(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByEarly((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean userRating(List<BizSupplierPerformanceEvaluationRating> ratingList) {
        LocalDateTime now = LocalDateTime.now();
        IUser user = ContextUtil.getCurrentUser();
        ratingList.forEach(item -> {
            item.setStatus("1");
            item.setRatingTime(now);
            item.setOperationRatingId(user.getUserId());
            item.setOperationRatingAccount(user.getAccount());
            item.setOperationRatingName(user.getFullname());
        });
        if (!this.ratingManager.updateBatchById(ratingList)) {
            return false;
        }
        BizSupplierPerformanceEvaluationRating firstRating = ratingList.get(0);
        String performanceEvaluationId = firstRating.getPerformanceEvaluationId();
        List<BizSupplierPerformanceEvaluationRating> unfinishedRatings = this.getUnfinishedRatings(performanceEvaluationId);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BizSupplierPerformanceEvaluation::getId, (Object)performanceEvaluationId);
        BizSupplierPerformanceEvaluationApprovalRecord record = new BizSupplierPerformanceEvaluationApprovalRecord();
        if (!unfinishedRatings.isEmpty()) {
            updateWrapper.set(BizSupplierPerformanceEvaluation::getStatus, (Object)"3");
            record.setStatus("3");
        } else {
            this.updateEvaluationWithScore(firstRating, (LambdaUpdateWrapper<BizSupplierPerformanceEvaluation>)updateWrapper);
            record.setStatus("4");
        }
        record.setPerformanceEvaluationId(firstRating.getPerformanceEvaluationId());
        record.setApprovalId(user.getUserId());
        record.setApprovalAccount(user.getAccount());
        record.setApprovalName(user.getFullname());
        record.setApprovalOrgId(ContextUtil.getCurrentOrgId());
        record.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        record.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        record.setApprovalResult("1");
        this.recordManager.fillModel(record);
        return super.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean userEva(ResultEvaDTO dto) {
        IUser user = ContextUtil.getCurrentUser();
        this.notificationManager.saveEva(dto);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluation::getId, (Object)dto.getPerformanceEvaluationId())).set(BizSupplierPerformanceEvaluation::getAssessmentResult, (Object)dto.getAssessmentResult())).set(BizSupplierPerformanceEvaluation::getStatus, (Object)"1")).set(BizSupplierPerformanceEvaluation::getProcessType, (Object)dto.getProcessType());
        BizSupplierPerformanceEvaluationApprovalRecord record = new BizSupplierPerformanceEvaluationApprovalRecord();
        record.setStatus("1");
        record.setPerformanceEvaluationId(dto.getPerformanceEvaluationId());
        record.setApprovalId(user.getUserId());
        record.setApprovalAccount(user.getAccount());
        record.setApprovalName(user.getFullname());
        record.setApprovalOrgId(ContextUtil.getCurrentOrgId());
        record.setApprovalOrgName(ContextUtil.getCurrentOrgName());
        record.setApprovalOrgCode(ContextUtil.getCurrentOrgCode());
        record.setApprovalResult("1");
        this.recordManager.fillModel(record);
        return super.update((Wrapper)wrapper);
    }

    private List<BizSupplierPerformanceEvaluationRating> getUnfinishedRatings(String performanceEvaluationId) {
        return this.ratingManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)performanceEvaluationId)).eq(BizSupplierPerformanceEvaluationRating::getStatus, (Object)"0"));
    }

    private void updateEvaluationWithScore(BizSupplierPerformanceEvaluationRating rating, LambdaUpdateWrapper<BizSupplierPerformanceEvaluation> wrapper) {
        List allRatings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationId, (Object)rating.getPerformanceEvaluationId()));
        BigDecimal totalScore = allRatings.stream().map(BizSupplierPerformanceEvaluationRating::getOperationScore).reduce(BigDecimal.ZERO, BigDecimal::add);
        String level = this.calculateLevel(rating.getPerformanceEvaluationConfigurationId(), totalScore);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(BizSupplierPerformanceEvaluation::getStatus, (Object)"4")).set(BizSupplierPerformanceEvaluation::getOperationScore, (Object)totalScore)).set(BizSupplierPerformanceEvaluation::getLevel, (Object)level);
    }

    private String calculateLevel(String configurationId, BigDecimal totalScore) {
        List intervals = this.intervalManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)configurationId));
        return intervals.stream().filter(interval -> totalScore.compareTo(BigDecimal.valueOf(interval.getMinScore().intValue())) >= 0 && totalScore.compareTo(BigDecimal.valueOf(interval.getMaxScore().intValue())) <= 0).findFirst().map(BizSupplierPerformanceEvaluationInterval::getLevel).orElse("1");
    }

    private List<BizSupplierPerformanceEvaluationApprovalRecord> getRecords(String performanceEvaluationId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BizSupplierPerformanceEvaluationApprovalRecord::getPerformanceEvaluationId, (Object)performanceEvaluationId)).orderByAsc(AutoFillModel::getCreateTime);
        return this.recordManager.list((Wrapper)wrapper);
    }
}

