/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierApply.dao.BizSupplierEnterpriseCreditLimitDao;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseCreditLimitManager;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterpriseCreditLimit;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEnterpriseCreditLimitManagerImpl
extends BaseManagerImpl<BizSupplierEnterpriseCreditLimitDao, BizSupplierEnterpriseCreditLimit>
implements BizSupplierEnterpriseCreditLimitManager {
    private static final Logger log = LoggerFactory.getLogger(BizSupplierEnterpriseCreditLimitManagerImpl.class);
    @Resource
    private BizSupplierEnterpriseManager bizSupplierEnterpriseManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String batchAllocateCustomer(List<String> ids, BigDecimal creditLimit) {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\u7cfb\u7edf");
        }
        if (creditLimit == null || creditLimit.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ApplicationException("\u6388\u4fe1\u989d\u5ea6\u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        if (ids.isEmpty()) {
            throw new ApplicationException("\u5ba2\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BizSupplierEnterprise::getId, ids);
        queryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        List supplierEnterprises = this.bizSupplierEnterpriseManager.list((Wrapper)queryWrapper);
        if (supplierEnterprises.isEmpty()) {
            throw new ApplicationException("\u672a\u627e\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684 ID \u662f\u5426\u6b63\u786e");
        }
        ArrayList<BizSupplierEnterpriseCreditLimit> insertList = new ArrayList<BizSupplierEnterpriseCreditLimit>();
        ArrayList<BizSupplierEnterpriseCreditLimit> updateList = new ArrayList<BizSupplierEnterpriseCreditLimit>();
        for (BizSupplierEnterprise supplierEnterprise : supplierEnterprises) {
            String supplierEnterpriseId = supplierEnterprise.getId();
            String supplierId = supplierEnterprise.getSupplierId();
            String supplierName = supplierEnterprise.getSupplierName();
            String enterpriseId = supplierEnterprise.getEnterpriseId();
            String enterpriseName = supplierEnterprise.getEnterpriseName();
            LambdaQueryWrapper creditQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)creditQueryWrapper.eq(BizSupplierEnterpriseCreditLimit::getSupplierEnterpriseId, (Object)supplierEnterpriseId)).eq(BizSupplierEnterpriseCreditLimit::getCreditType, (Object)"1")).eq(BizSupplierEnterpriseCreditLimit::getIsDele, (Object)"0");
            BizSupplierEnterpriseCreditLimit existing = (BizSupplierEnterpriseCreditLimit)((Object)this.getOne((Wrapper)creditQueryWrapper));
            if (existing != null) {
                existing.setCreditLimit(creditLimit);
                updateList.add(existing);
                continue;
            }
            BizSupplierEnterpriseCreditLimit newLimit = new BizSupplierEnterpriseCreditLimit();
            newLimit.setSupplierId(supplierId);
            newLimit.setSupplierName(supplierName);
            newLimit.setCreditLimit(creditLimit);
            newLimit.setCreditType("1");
            newLimit.setEnterpriseId(enterpriseId);
            newLimit.setEnterpriseName(enterpriseName);
            newLimit.setSupplierEnterpriseId(supplierEnterpriseId);
            insertList.add(newLimit);
        }
        if (!updateList.isEmpty()) {
            this.updateBatchById(updateList);
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList);
        }
        return "\u5ba2\u6237\u540d\u5f55\u6388\u4fe1\u989d\u5ea6\u5206\u914d\u6210\u529f";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object batchAllocateSupplier(List<String> ids, BigDecimal creditLimit) {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\u7cfb\u7edf");
        }
        if (creditLimit == null || creditLimit.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ApplicationException("\u6388\u4fe1\u989d\u5ea6\u5fc5\u987b\u4e3a\u6b63\u6570");
        }
        if (ids.isEmpty()) {
            throw new ApplicationException("\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(BizSupplierEnterprise::getId, ids)).eq(BizDelModel::getIsDele, (Object)"0");
        List supplierEnterprises = this.bizSupplierEnterpriseManager.list((Wrapper)queryWrapper);
        if (supplierEnterprises.isEmpty()) {
            throw new ApplicationException("\u672a\u627e\u5230\u6709\u6548\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684 ID \u662f\u5426\u6b63\u786e");
        }
        ArrayList<BizSupplierEnterpriseCreditLimit> insertList = new ArrayList<BizSupplierEnterpriseCreditLimit>();
        ArrayList<BizSupplierEnterpriseCreditLimit> updateList = new ArrayList<BizSupplierEnterpriseCreditLimit>();
        for (BizSupplierEnterprise supplierEnterprise : supplierEnterprises) {
            String supplierEnterpriseId = supplierEnterprise.getId();
            String supplierId = supplierEnterprise.getSupplierId();
            String supplierName = supplierEnterprise.getSupplierName();
            String enterpriseId = supplierEnterprise.getEnterpriseId();
            String enterpriseName = supplierEnterprise.getEnterpriseName();
            LambdaQueryWrapper creditQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)creditQueryWrapper.eq(BizSupplierEnterpriseCreditLimit::getSupplierEnterpriseId, (Object)supplierEnterpriseId)).eq(BizSupplierEnterpriseCreditLimit::getCreditType, (Object)"2")).eq(BizSupplierEnterpriseCreditLimit::getIsDele, (Object)"0");
            BizSupplierEnterpriseCreditLimit existing = (BizSupplierEnterpriseCreditLimit)((Object)this.getOne((Wrapper)creditQueryWrapper));
            if (existing != null) {
                existing.setCreditLimit(creditLimit);
                updateList.add(existing);
                continue;
            }
            BizSupplierEnterpriseCreditLimit newLimit = new BizSupplierEnterpriseCreditLimit();
            newLimit.setSupplierId(supplierId);
            newLimit.setSupplierName(supplierName);
            newLimit.setCreditLimit(creditLimit);
            newLimit.setCreditType("2");
            newLimit.setEnterpriseId(enterpriseId);
            newLimit.setEnterpriseName(enterpriseName);
            newLimit.setSupplierEnterpriseId(supplierEnterpriseId);
            insertList.add(newLimit);
        }
        if (!updateList.isEmpty()) {
            this.updateBatchById(updateList);
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList);
        }
        return "\u4f9b\u5e94\u5546\u540d\u5f55\u6388\u4fe1\u989d\u5ea6\u5206\u914d\u6210\u529f";
    }
}

