/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationNotificationDao;
import com.artfess.gyl.supplierEva.dto.ProcessDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationAcknowledgementManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationAcknowledgement;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationNotificationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationNotificationDao, BizSupplierPerformanceEvaluationNotification>
implements BizSupplierPerformanceEvaluationNotificationManager {
    @Resource
    private BizSupplierPerformanceEvaluationAcknowledgementManager acknowledgementManager;
    @Resource
    private BizSupplierPerformanceEvaluationCorrectionReportManager reportManager;
    @Resource
    private FileManager fileManager;

    @Override
    public void saveEva(ResultEvaDTO dto) {
        Asserts.notNull((Object)dto.getSupplierId(), (String)"\u9700\u901a\u77e5\u7684\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        String processType = dto.getProcessType();
        String PROCESS_TYPE_NORMAL = "0";
        String PROCESS_TYPE_DEADLINE = "2";
        if ("0".equals(processType)) {
            return;
        }
        BizSupplierPerformanceEvaluationNotification notification = new BizSupplierPerformanceEvaluationNotification();
        if (StringUtils.isNotBlank((String)dto.getId())) {
            notification.setId(dto.getId());
        }
        boolean isDeadlineProcess = "2".equals(processType);
        Integer distributeType = dto.getDistributeType();
        IUser user = ContextUtil.getCurrentUser();
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgName = ContextUtil.getCurrentOrgName();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        notification.setInitiatorId(user.getUserId());
        notification.setInitiatorAccount(user.getAccount());
        notification.setInitiatorName(user.getFullname());
        notification.setEnterpriseId(BeanUtils.isNotEmpty((Object)dto.getEnterpriseId()) ? dto.getEnterpriseId() : currentOrgId);
        notification.setEnterpriseName(BeanUtils.isNotEmpty((Object)dto.getEnterpriseName()) ? dto.getEnterpriseName() : currentOrgName);
        notification.setEnterpriseCode(BeanUtils.isNotEmpty((Object)dto.getEnterpriseCode()) ? dto.getEnterpriseCode() : currentOrgCode);
        notification.setAssessmentType(dto.getAssessmentType());
        notification.setAssessmentMonth(dto.getAssessmentMonth());
        notification.setAssessmentYear(dto.getAssessmentYear());
        notification.setAssessmentQuater(dto.getAssessmentQuarter());
        notification.setAssessmentResult(dto.getAssessmentResult());
        notification.setOperationScore(dto.getOperationScore());
        notification.setValuationConfigurationName(dto.getValuationConfigurationName());
        notification.setLevel(dto.getLevel());
        notification.setSupplierId(dto.getSupplierId());
        notification.setSupplierName(dto.getSupplierName());
        notification.setSupplierCode(dto.getSupplierCode());
        notification.setDistributeType(distributeType != null ? distributeType : 1);
        notification.setPerformanceEvaluationId(dto.getPerformanceEvaluationId());
        notification.setProcessType(processType);
        notification.setNotificationTitle(dto.getNotificationTitle());
        notification.setNotificationContent(dto.getNotificationContent());
        notification.setNotifyDate(dto.getNotifyDate());
        notification.setNotificationStatus("1");
        if (isDeadlineProcess) {
            notification.setReplyDeadline(dto.getReplyDeadline());
            notification.setFinishDeadline(dto.getFinishDeadline());
            notification.setEnterpriseAddress(dto.getEnterpriseAddress());
            notification.setEnterpriseContact(dto.getEnterpriseContact());
            notification.setEnterpriseTel(dto.getEnterpriseTel());
        }
        super.saveOrUpdate((Object)notification);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean confirmNotification(ProcessDTO dto) {
        this.validateParams(dto);
        IUser user = this.getUser();
        BizSupplierPerformanceEvaluationNotification existingNotification = this.getAndValidateNotification(dto.getNotificationId());
        this.updateNotificationStatus(dto.getNotificationId());
        this.createAcknowledgementRecord(dto.getNotificationId(), user);
        this.processCorrectionReport(dto, existingNotification);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateReportStatus(ProcessDTO dto) {
        BizSupplierPerformanceEvaluationCorrectionReport report = (BizSupplierPerformanceEvaluationCorrectionReport)((Object)this.reportManager.getById((Serializable)((Object)dto.getReportId())));
        if (report == null) {
            throw new ApplicationException("\u6574\u6539\u62a5\u544a\u4e0d\u5b58\u5728");
        }
        try {
            report.setCorrectionStatus(dto.getStatus());
            if ("2".equals(dto.getStatus())) {
                report.setResultDescription(dto.getResultDescription());
                report.setActualCompleteDate(dto.getActualCompleteDate());
                if (dto.getFiles() != null && !dto.getFiles().isEmpty()) {
                    List fileIds = dto.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    this.fileManager.updateFileBizIdByIds(fileIds, dto.getReportId());
                }
            } else if ("3".equals(dto.getStatus()) || "5".equals(dto.getStatus())) {
                this.updateNotificationStatus(report.getNotificationId(), "4");
            }
            this.updateReportAndSaveResult(report, dto.getApprovalOpinion());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void updateNotificationStatus(String notificationId, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluationNotification::getId, (Object)notificationId)).set(BizSupplierPerformanceEvaluationNotification::getNotificationStatus, (Object)status);
        super.update((Wrapper)wrapper);
    }

    private void updateReportAndSaveResult(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion) {
        this.reportManager.updateById((Object)report);
        this.reportManager.saveReportResult(report, approvalOpinion);
    }

    @Override
    public BizSupplierPerformanceEvaluationCorrectionReport getReport(String notificationId) {
        LambdaQueryWrapper reportWrapper = new LambdaQueryWrapper();
        reportWrapper.eq(BizSupplierPerformanceEvaluationCorrectionReport::getNotificationId, (Object)notificationId);
        return (BizSupplierPerformanceEvaluationCorrectionReport)((Object)this.reportManager.getOne((Wrapper)reportWrapper));
    }

    public BizSupplierPerformanceEvaluationNotification getById(Serializable id) {
        BizSupplierPerformanceEvaluationNotification entity = (BizSupplierPerformanceEvaluationNotification)((Object)super.getById(id));
        if (entity == null) {
            return null;
        }
        BizSupplierPerformanceEvaluationCorrectionReport report = this.getReport(entity.getId());
        if (report != null) {
            entity.setReport(report);
            List files = this.fileManager.queryFileByBizId(report.getId());
            report.setFiles(files);
        }
        return entity;
    }

    @Override
    public PageList<BizSupplierPerformanceEvaluationNotification> queryEarlyEvaluationList(QueryFilter<BizSupplierPerformanceEvaluationNotification> queryFilter) {
        IPage<BizSupplierPerformanceEvaluationNotification> iPage = ((BizSupplierPerformanceEvaluationNotificationDao)this.baseMapper).queryByEarly((IPage<BizSupplierPerformanceEvaluationNotification>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluationNotification>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    private void validateParams(ProcessDTO dto) {
        if (dto == null || StringUtils.isBlank((String)dto.getNotificationId())) {
            throw new ApplicationException("\u901a\u77e5ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private IUser getUser() {
        return ContextUtil.getCurrentUser();
    }

    private BizSupplierPerformanceEvaluationNotification getAndValidateNotification(String notificationId) {
        BizSupplierPerformanceEvaluationNotification existingNotification = (BizSupplierPerformanceEvaluationNotification)((Object)super.getById((Serializable)((Object)notificationId)));
        if (existingNotification == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8003\u6838\u901a\u77e5");
        }
        if ("2".equals(existingNotification.getNotificationStatus())) {
            throw new ApplicationException("\u8be5\u901a\u77e5\u5df2\u88ab\u786e\u8ba4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        return existingNotification;
    }

    private void updateNotificationStatus(String notificationId) {
        LambdaUpdateWrapper notificationWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)notificationWrapper.eq(BizSupplierPerformanceEvaluationNotification::getId, (Object)notificationId)).set(BizSupplierPerformanceEvaluationNotification::getNotificationStatus, (Object)"2");
        boolean update = super.update((Wrapper)notificationWrapper);
        if (!update) {
            throw new ApplicationException("\u66f4\u65b0\u901a\u77e5\u72b6\u6001\u5931\u8d25");
        }
    }

    private void createAcknowledgementRecord(String notificationId, IUser user) {
        BizSupplierPerformanceEvaluationAcknowledgement acknowledgement = new BizSupplierPerformanceEvaluationAcknowledgement();
        acknowledgement.setNotificationId(notificationId);
        acknowledgement.setAckStatus("1");
        acknowledgement.setAckTime(LocalDateTime.now());
        acknowledgement.setAcknowledgedById(user.getUserId());
        acknowledgement.setAcknowledgedByAccount(user.getAccount());
        acknowledgement.setAcknowledgedByName(user.getFullname());
        acknowledgement.setAckMethod("1");
        this.acknowledgementManager.save((Object)acknowledgement);
    }

    private void processCorrectionReport(ProcessDTO dto, BizSupplierPerformanceEvaluationNotification existingNotification) {
        if (!"2".equals(existingNotification.getProcessType())) {
            return;
        }
        BizSupplierPerformanceEvaluationCorrectionReport report = new BizSupplierPerformanceEvaluationCorrectionReport();
        report.setPerformanceEvaluationId(dto.getNotificationId());
        report.setNotificationId(dto.getNotificationId());
        report.setRootCauseAnalysis(dto.getRootCauseAnalysis());
        report.setTemporaryMeasure(dto.getTemporaryMeasure());
        report.setLongTermCorrection(dto.getLongTermCorrection());
        report.setPlanCompleteDate(dto.getPlanCompleteDate());
        report.setCorrectionStatus("1");
        this.reportManager.save((Object)report);
    }
}

