/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.tool;

import com.artfess.base.exception.ApplicationException;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierApply3.manager.BizSupplierEnterpriseRegisterInformationManager;
import com.artfess.gyl.supplierApply4.dto.SupplierChangeDTO;
import com.artfess.gyl.supplierApply4.dto.SupplierRegister4DTO;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseAccessApprovalRecord3Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierEnterpriseChangeLogManager;
import com.artfess.gyl.supplierApply4.model.BizSupplierEnterpriseAccessApprovalRecord3;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SupplierAsyncProcessor {
    private static final Logger log = LoggerFactory.getLogger(SupplierAsyncProcessor.class);
    @Resource
    private BizSupplierEnterpriseManager enterpriseManager;
    @Resource
    private BizSupplierEnterpriseAccessApprovalRecord3Manager record3Manager;
    @Resource
    private BizSupplierEnterpriseRegisterInformationManager registerInformationManager;
    @Resource
    private BizSupplierEnterpriseChangeLogManager manager;

    @Async(value="taskExecutor")
    public void processApprovalResultAsync(SupplierChangeDTO dto) {
        long startTime = System.currentTimeMillis();
        String changeLogId = dto.getId();
        log.info("\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u5ba1\u6279\u7ed3\u679c, changeLogId: {}", (Object)changeLogId);
        try {
            if (this.isAllEnterpriseProcessed(dto)) {
                this.processApprovalResult(dto);
                log.info("\u5f02\u6b65\u5904\u7406\u5ba1\u6279\u7ed3\u679c\u5b8c\u6210, changeLogId: {}, \u8017\u65f6: {}ms", (Object)changeLogId, (Object)(System.currentTimeMillis() - startTime));
            } else {
                log.debug("\u4f01\u4e1a\u5ba1\u6279\u672a\u5168\u90e8\u5b8c\u6210, \u8df3\u8fc7\u5904\u7406, changeLogId: {}", (Object)changeLogId);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u5904\u7406\u5ba1\u6279\u7ed3\u679c\u5931\u8d25, changeLogId: {}", (Object)changeLogId, (Object)e);
        }
    }

    private boolean isAllEnterpriseProcessed(SupplierChangeDTO dto) {
        List enterprises = this.enterpriseManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierEnterprise::getSupplierId, (Object)dto.getSupplierId())).groupBy(BizSupplierEnterprise::getEnterpriseId));
        if (CollectionUtils.isEmpty((Collection)enterprises)) {
            return false;
        }
        List approvalRecords = this.record3Manager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseAccessApprovalRecord3::getSupplierEnterpriseChangeLogId, (Object)dto.getId()));
        return enterprises.size() == approvalRecords.size();
    }

    private void processApprovalResult(SupplierChangeDTO dto) {
        List approvalRecords = this.record3Manager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierEnterpriseAccessApprovalRecord3::getSupplierEnterpriseChangeLogId, (Object)dto.getId()));
        long approvedCount = approvalRecords.stream().filter(record -> "1".equals(record.getApprovalResult())).count();
        if (approvedCount > 0L) {
            this.updateSupplierRegistration(dto);
            log.info("\u4f9b\u5e94\u5546\u6ce8\u518c\u4fe1\u606f\u66f4\u65b0\u5b8c\u6210, changeLogId: {}, \u901a\u8fc7\u4f01\u4e1a\u6570: {}", (Object)dto.getId(), (Object)approvedCount);
        }
    }

    private void updateSupplierRegistration(SupplierChangeDTO dto) {
        try {
            SupplierRegister4DTO information = dto.getInformation();
            information.setId(null);
            information.setVersion(information.getVersion() + 1L);
            SupplierRegisterDTO dto3 = new SupplierRegisterDTO();
            BeanUtils.copyProperties((Object)((Object)dto3), (Object)((Object)information));
            this.registerInformationManager.saveOrUpdateModel(dto3);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("\u66f4\u65b0\u4f9b\u5e94\u5546\u6ce8\u518c\u4fe1\u606f\u5931\u8d25, changeLogId: {}", (Object)dto.getId(), (Object)e);
            throw new ApplicationException("\u66f4\u65b0\u4f9b\u5e94\u5546\u6ce8\u518c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

