/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierApply4.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierApply4.dao.BizSupplierMainProductsPerformance4Dao;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainProductsPerformance4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainProductsPerformanceCustomerComplaints4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainProductsQualityPerformance4Manager;
import com.artfess.gyl.supplierApply4.manager.BizSupplierMainProductsSalesStatus4Manager;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsPerformance4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsPerformanceCustomerComplaints4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsQualityPerformance4;
import com.artfess.gyl.supplierApply4.model.BizSupplierMainProductsSalesStatus4;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierMainProductsPerformance4ManagerImpl
extends BaseManagerImpl<BizSupplierMainProductsPerformance4Dao, BizSupplierMainProductsPerformance4>
implements BizSupplierMainProductsPerformance4Manager {
    @Resource
    private BizSupplierMainProductsPerformanceCustomerComplaints4Manager complaints4Manager;
    @Resource
    private BizSupplierMainProductsSalesStatus4Manager status4Manager;
    @Resource
    private BizSupplierMainProductsQualityPerformance4Manager qualityPerformance4Manager;

    @Override
    public boolean fillModel(BizSupplierMainProductsPerformance4 performance4, String id, Long version) {
        if (performance4 != null) {
            performance4.setId(null);
            performance4.setSupplierEnterpriseId(id);
            performance4.setVersion(version);
            if (!super.save((Object)performance4)) {
                throw new ApplicationException("\u4e3b\u8425\u4ea7\u54c1\u60c5\u51b5\u53ca\u8d28\u91cf\u4e1a\u7ee9\u4fdd\u5b58\u5931\u8d25");
            }
            if (performance4.getComplaints() != null && !performance4.getComplaints().isEmpty()) {
                List complaints4List = performance4.getComplaints().stream().peek(complaint -> {
                    complaint.setId(null);
                    complaint.setSupplierMainProductsPerformanceId(performance4.getId());
                    complaint.setVersion(performance4.getVersion());
                }).collect(Collectors.toList());
                this.complaints4Manager.saveBatch(complaints4List);
            }
            if (performance4.getSalesStatus() != null && !performance4.getSalesStatus().isEmpty()) {
                List salesStatus4List = performance4.getSalesStatus().stream().peek(salesStatus -> {
                    salesStatus.setId(null);
                    salesStatus.setSupplierMainProductsPerformanceId(performance4.getId());
                    salesStatus.setVersion(performance4.getVersion());
                }).collect(Collectors.toList());
                this.status4Manager.saveBatch(salesStatus4List);
            }
            if (performance4.getQualityPerformance() != null && !performance4.getQualityPerformance().isEmpty()) {
                List qualityPerformance4List = performance4.getQualityPerformance().stream().peek(qualityPerformance4 -> {
                    qualityPerformance4.setId(null);
                    qualityPerformance4.setSupplierMainProductsPerformanceId(performance4.getId());
                    qualityPerformance4.setVersion(performance4.getVersion());
                }).collect(Collectors.toList());
                this.qualityPerformance4Manager.saveBatch(qualityPerformance4List);
            }
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true)
    public BizSupplierMainProductsPerformance4 getModel(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizSupplierMainProductsPerformance4::getSupplierEnterpriseId, (Object)id);
        BizSupplierMainProductsPerformance4 performance = (BizSupplierMainProductsPerformance4)((Object)this.getOne((Wrapper)queryWrapper));
        if (performance == null) {
            return null;
        }
        String performanceId = performance.getId();
        LambdaQueryWrapper complaintsQuery = new LambdaQueryWrapper();
        complaintsQuery.eq(BizSupplierMainProductsPerformanceCustomerComplaints4::getSupplierMainProductsPerformanceId, (Object)performanceId);
        List complaintsList = this.complaints4Manager.list((Wrapper)complaintsQuery);
        LambdaQueryWrapper salesStatusQuery = new LambdaQueryWrapper();
        salesStatusQuery.eq(BizSupplierMainProductsSalesStatus4::getSupplierMainProductsPerformanceId, (Object)performanceId);
        List salesStatusList = this.status4Manager.list((Wrapper)salesStatusQuery);
        LambdaQueryWrapper qualityQuery = new LambdaQueryWrapper();
        qualityQuery.eq(BizSupplierMainProductsQualityPerformance4::getSupplierMainProductsPerformanceId, (Object)performanceId);
        List qualityList = this.qualityPerformance4Manager.list((Wrapper)qualityQuery);
        List<BizSupplierMainProductsPerformanceCustomerComplaints4> performanceComplaints = complaintsList.stream().filter(complaint -> complaint.getSupplierMainProductsPerformanceId().equals(performance.getId())).collect(Collectors.toList());
        performance.setComplaints(performanceComplaints);
        List<BizSupplierMainProductsSalesStatus4> performanceSalesStatus = salesStatusList.stream().filter(salesStatus -> salesStatus.getSupplierMainProductsPerformanceId().equals(performance.getId())).collect(Collectors.toList());
        performance.setSalesStatus(performanceSalesStatus);
        List<BizSupplierMainProductsQualityPerformance4> performanceQuality = qualityList.stream().filter(quality -> quality.getSupplierMainProductsPerformanceId().equals(performance.getId())).collect(Collectors.toList());
        performance.setQualityPerformance(performanceQuality);
        return performance;
    }
}

