/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.dao.BizEnterprisePersonnelDao;
import com.artfess.gyl.base.manager.BizEnterprisePersonnelManager;
import com.artfess.gyl.base.model.BizEnterprisePersonnel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizEnterprisePersonnelManagerImpl
extends BaseManagerImpl<BizEnterprisePersonnelDao, BizEnterprisePersonnel>
implements BizEnterprisePersonnelManager {
    @Resource
    private FileManager fileManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizEnterprisePersonnel entity) {
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.save((Object)entity)) {
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if (files != null && files.size() > 0) {
            List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizEnterprisePersonnel entity) {
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.updateById((Object)entity)) {
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if (files != null && files.size() > 0) {
            List fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            this.fileManager.removeFileByBizId(entity.getId(), fileIds);
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        } else {
            this.fileManager.removeFileByBizId(entity.getId(), null);
        }
        return true;
    }

    public BizEnterprisePersonnel getById(Serializable id) {
        BizEnterprisePersonnel entity = ((BizEnterprisePersonnelDao)this.baseMapper).getModel(id);
        if (entity == null) {
            return null;
        }
        List files = this.fileManager.queryFileByBizId(entity.getId(), null);
        entity.setFiles(files);
        return entity;
    }

    @Override
    public PageList<BizEnterprisePersonnel> queryByPage(QueryFilter<BizEnterprisePersonnel> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizEnterprisePersonnel> iPage = ((BizEnterprisePersonnelDao)this.baseMapper).queryByPage((IPage<BizEnterprisePersonnel>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEnterprisePersonnel>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }
}

