/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final int CONNECT_TIME_OUT = 30000;
    private static final int READ_TIME_OUT = 30000;
    private static final String CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "application/json";

    public static String postJson(String url, String json, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrlJson(url, json, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokeUrlJson(String url, String json, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String encoding, HttpMethod method) {
        StringBuilder paramsStr = null;
        URL uUrl = null;
        HttpURLConnection conn = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        if (encoding == null || encoding.trim().equals("")) {
            encoding = CHARSET;
        }
        if (content_type == null || content_type.trim().equals("")) {
            content_type = CONTENT_TYPE;
        }
        try {
            String line;
            uUrl = new URL(url);
            conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestProperty("content-type", content_type);
            conn.setRequestMethod(method.toString());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (connectTimeout == 0) {
                conn.setConnectTimeout(30000);
            } else {
                conn.setConnectTimeout(connectTimeout);
            }
            if (readTimeout == 0) {
                conn.setConnectTimeout(30000);
            } else {
                conn.setReadTimeout(readTimeout);
            }
            if (headers != null && headers.size() > 0) {
                Set<String> headerSet = headers.keySet();
                for (String key : headerSet) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (paramsStr != null && method == HttpMethod.POST && !content_type.toLowerCase().equals(CONTENT_TYPE)) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write(paramsStr.toString());
                out.flush();
            }
            if (json != null && method == HttpMethod.POST && content_type.toLowerCase().equals(CONTENT_TYPE)) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write(json);
                System.out.println(json.toString());
                out.flush();
            }
            StringBuilder result = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            if (in != null) {
                line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            System.out.println(url);
            System.out.println("\u540c\u6b65\u62db\u5546:" + result.toString());
            line = result.toString();
            return line;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a5\u53e3[" + url + "]\u5931\u8d25\uff01\u8bf7\u6c42URL\uff1a" + url + "\uff0c\u53c2\u6570\uff1a" + json, (Throwable)e);
            try {
                byte[] buf = new byte[100];
                InputStream es = conn.getErrorStream();
                if (es != null) {
                    while (es.read(buf) > 0) {
                    }
                    es.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokeUrl(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String encoding, HttpMethod method) {
        StringBuilder paramsStr = null;
        if (params != null) {
            paramsStr = new StringBuilder();
            Set<Map.Entry<String, Object>> entries = params.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                paramsStr.append(entry.getKey() + "=" + value + "&");
            }
            if (method != HttpMethod.POST) {
                url = url + "?" + paramsStr.toString();
            }
        }
        URL uUrl = null;
        HttpURLConnection conn = null;
        BufferedWriter out = null;
        BufferedReader in = null;
        if (encoding == null || encoding.trim().equals("")) {
            encoding = CHARSET;
        }
        if (content_type == null || content_type.trim().equals("")) {
            content_type = CONTENT_TYPE;
        }
        try {
            String line;
            uUrl = new URL(url);
            conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestProperty("content-type", content_type);
            conn.setRequestMethod(method.toString());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (connectTimeout == 0) {
                conn.setConnectTimeout(30000);
            } else {
                conn.setConnectTimeout(connectTimeout);
            }
            if (readTimeout == 0) {
                conn.setConnectTimeout(30000);
            } else {
                conn.setReadTimeout(readTimeout);
            }
            if (headers != null && headers.size() > 0) {
                Set<String> headerSet = headers.keySet();
                for (String key : headerSet) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (paramsStr != null && method == HttpMethod.POST && !content_type.toLowerCase().equals(CONTENT_TYPE)) {
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write(paramsStr.toString());
                out.flush();
            }
            if (params != null && params.size() > 0 && method == HttpMethod.POST && content_type.toLowerCase().equals(CONTENT_TYPE)) {
                JSONObject jsons = new JSONObject(params);
                out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), encoding));
                out.write("[" + jsons.toString() + "]");
                System.out.println(jsons.toString());
                out.flush();
            }
            StringBuilder result = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
            if (in != null) {
                line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            System.out.println(url);
            System.out.println("\u540c\u6b65\u62db\u5546:" + result.toString());
            line = result.toString();
            return line;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a5\u53e3[" + url + "]\u5931\u8d25\uff01\u8bf7\u6c42URL\uff1a" + url + "\uff0c\u53c2\u6570\uff1a" + params, (Throwable)e);
            try {
                byte[] buf = new byte[100];
                InputStream es = conn.getErrorStream();
                if (es != null) {
                    while (es.read(buf) > 0) {
                    }
                    es.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static String post(String url, Map<String, Object> params, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, null, content_type, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.POST);
    }

    public static String get(String url) {
        return HttpUtils.invokeUrl(url, null, null, null, 5000, 5000, "utf-8", HttpMethod.GET);
    }

    public static String get(String url, Map<String, Object> params) {
        return HttpUtils.invokeUrl(url, params, null, null, 5000, 5000, "utf-8", HttpMethod.GET);
    }

    public static String get(String url, Map<String, Object> params, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, null, content_type, connectTimeout, readTimeout, charset, HttpMethod.GET);
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.GET);
    }

    public static String put(String url, Map<String, Object> params, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, null, content_type, connectTimeout, readTimeout, charset, HttpMethod.PUT);
    }

    public static String put(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.PUT);
    }

    public static String delete(String url, Map<String, Object> params, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, null, content_type, connectTimeout, readTimeout, charset, HttpMethod.DELETE);
    }

    public static String delete(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.DELETE);
    }

    public static String head(String url, Map<String, Object> params, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, null, content_type, connectTimeout, readTimeout, charset, HttpMethod.HEAD);
    }

    public static String head(String url, Map<String, Object> params, Map<String, String> headers, String content_type, int connectTimeout, int readTimeout, String charset) {
        return HttpUtils.invokeUrl(url, params, headers, content_type, connectTimeout, readTimeout, charset, HttpMethod.HEAD);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String entity = HttpUtils.get("http://localhost:8001/plat/actuator/health");
        JSONObject jsonObject = JSONObject.parseObject((String)entity);
        String systemStatus = jsonObject.getString("status");
        System.out.println(systemStatus);
        JSONObject json = jsonObject.getJSONObject("components");
        for (String str : json.keySet()) {
            System.out.println(str + "***" + json.getJSONObject(str).getString("status"));
        }
    }

    private static enum HttpMethod {
        POST,
        DELETE,
        GET,
        PUT,
        HEAD;

    }
}

