/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.file.util.OfficeToPdf;
import com.artfess.gyl.base.dao.BizAccessoryDao;
import com.artfess.gyl.base.manager.BizAccessoryManager;
import com.artfess.gyl.base.model.BizAccessory;
import com.artfess.gyl.base.vo.Chunk;
import com.artfess.gyl.utils.MinioUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizAccessoryManagerImpl
extends BaseManagerImpl<BizAccessoryDao, BizAccessory>
implements BizAccessoryManager {
    @Resource
    private MinioUtils utils;
    @Resource
    private OfficeToPdf officeToPdf;

    @Override
    public List<BizAccessory> getAccessoryBySourceId(String sourceId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("SOURCE_ID_", (Object)sourceId, QueryOP.EQUAL);
        if (BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        }
        IPage<BizAccessory> accessoryIPage = ((BizAccessoryDao)this.baseMapper).selectPageBySourceId((IPage<BizAccessory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizAccessory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return accessoryIPage.getRecords();
    }

    @Override
    public List<BizAccessory> getAccessoryBySourceIdList(List<String> sourceIds) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("SOURCE_ID_", sourceIds, QueryOP.IN);
        if (BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        }
        IPage<BizAccessory> accessoryIPage = ((BizAccessoryDao)this.baseMapper).selectPageBySourceId((IPage<BizAccessory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizAccessory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return accessoryIPage.getRecords();
    }

    @Override
    public boolean saveAccessory(List<BizAccessory> list) {
        for (BizAccessory ele : list) {
            String currentUserId = ContextUtil.getCurrentUserId();
            String currentUserName = ContextUtil.getCurrentUserName();
            if (StringUtils.isBlank((CharSequence)ele.getId())) {
                ele.setCreateBy(currentUserId);
                ele.setCreateName(currentUserName);
                ele.setCreateTime(LocalDateTime.now());
                continue;
            }
            ele.setUpdateName(currentUserName);
            ele.setUpdateBy(currentUserId);
            ele.setUpdateTime(LocalDateTime.now());
        }
        boolean result = this.saveBatch(list);
        return result;
    }

    @Override
    public String fileUploadPost(Chunk chunk, HttpServletResponse response) throws IOException {
        String path = this.utils.getFileDir(chunk.getFilename());
        File file = new File(path, "" + chunk.getChunkNumber());
        if (!file.exists()) {
            new File(path).mkdirs();
            file.createNewFile();
        }
        try (InputStream fos = chunk.getFile().getInputStream();
             RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            int len = -1;
            byte[] buffer = new byte[1024];
            while ((len = fos.read(buffer)) != -1) {
                raf.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (chunk.getChunkNumber() == 1) {
                file.delete();
            }
            response.setStatus(507);
            return "exception:\u6587\u4ef6\u5199\u5165\u5f02\u5e38";
        }
        if (chunk.getChunkNumber().equals(chunk.getTotalChunks())) {
            response.setStatus(200);
            return "over";
        }
        response.setStatus(201);
        return "ok";
    }

    @Override
    public List<BizAccessory> minioBatchUpload(List<MultipartFile> fileList, String bizPath, HttpServletResponse response) throws Exception {
        ArrayList<BizAccessory> accessoryList = new ArrayList<BizAccessory>(fileList.size());
        for (MultipartFile file : fileList) {
            accessoryList.add(this.minioUpload(file, bizPath, response));
        }
        return accessoryList;
    }

    @Override
    public PageList<BizAccessory> getAccessoryPageBySourceId(QueryFilter<BizAccessory> queryFilter) {
        String sourceID = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"SOURCE_ID_".equals(ele.getProperty())) continue;
            sourceID = String.valueOf(ele.getValue());
            break;
        }
        Assert.notNull(sourceID, (String)"SOURCE_ID_\u4e0d\u80fd\u4e3a\u7a7a");
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizAccessory> accessoryIPage = ((BizAccessoryDao)this.baseMapper).selectPageBySourceId((IPage<BizAccessory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizAccessory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = accessoryIPage.getRecords();
        return new PageList(accessoryIPage);
    }

    @Override
    public boolean removeBySourceId(String sourceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizAccessory::getSourceId, (Object)sourceId);
        boolean remove = this.remove((Wrapper)wrapper);
        return remove;
    }

    @Override
    public boolean removeBySourceIds(List<String> sourceIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizAccessory::getSourceId, sourceIds);
        boolean remove = this.remove((Wrapper)wrapper);
        return remove;
    }

    @Override
    public BizAccessory minioUpload(String bizPath, String fileName) throws Exception {
        Assert.notNull((Object)fileName, (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        File file = this.mergeFile(fileName);
        BizAccessory accessory = new BizAccessory();
        if (null == file || file.length() == 0L || !file.exists()) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        accessory.setSuffix(suffix);
        List<String> suffixList = Arrays.asList("png,jpg,jpeg,xlsx,xls,pdf,docx,doc,zip,rar,excel,pptx".split(","));
        if (!suffixList.contains(suffix.toLowerCase())) {
            throw new BaseException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e0a\u4f20");
        }
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = ContextUtil.getCurrentUserId();
        String userName = ContextUtil.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizAccessoryManagerImpl.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.length() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name);
        boolean a = false;
        return accessory;
    }

    @Override
    public BizAccessory minioUpload(String bizPath, String fileName, String bucketName) throws Exception {
        Assert.notNull((Object)fileName, (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        File file = this.mergeFile(fileName);
        BizAccessory accessory = new BizAccessory();
        if (null == file || file.length() == 0L || !file.exists()) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        accessory.setSuffix(suffix);
        List<String> suffixList = Arrays.asList("png,jpg,jpeg,xlsx,xls,pdf,docx,doc,zip,rar,excel,pptx,stp".split(","));
        if (!suffixList.contains(suffix.toLowerCase())) {
            throw new BaseException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e0a\u4f20");
        }
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = ContextUtil.getCurrentUserId();
        String userName = ContextUtil.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizAccessoryManagerImpl.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.length() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name, bucketName);
        accessory.setBidSignStatus(1);
        return accessory;
    }

    @Override
    public String minIoDownFile(BizAccessory accessory, String bizPath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath + "/" + accessory.getId();
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String url = accessory.getUrl();
        String dir = url.substring(url.lastIndexOf("/"));
        String suffix = accessory.getSuffix();
        File fileFullPath = new File(file + "/" + accessory.getName());
        if (fileFullPath.exists()) {
            return filePath + "/";
        }
        FileOutputStream out = new FileOutputStream(file + "/" + accessory.getName());
        MinioUtil.downFile((String)customBucket, (String)(bizPath + dir), (OutputStream)out, (boolean)false);
        String downPath = filePath + "/";
        return downPath;
    }

    @Override
    public void minIoDownFile(String ids, String bizPath, HttpServletResponse response) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idList;
            List accessories;
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            if ((accessories = this.listByIds(idList = Arrays.asList(ids.split(",")))).size() == 1) {
                BizAccessory accessory = (BizAccessory)((Object)accessories.get(0));
                String url = accessory.getUrl();
                String newUrl = url.substring(0, url.lastIndexOf("&"));
                String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
                FileOutputStream out = new FileOutputStream(path + "/" + accessory.getName());
                MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + substring), (OutputStream)out, (boolean)false);
                HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + accessory.getName()), (String)accessory.getName());
                FileUtil.deleteFile((String)(filePath + "/" + accessory.getName()));
                return;
            }
            accessories.forEach(s -> {
                String url = s.getUrl();
                String newUrl = url.substring(0, url.lastIndexOf("&"));
                String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + s.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + substring), (OutputStream)out, (boolean)false);
            });
            this.zip(filePath, true);
            String zipPath = filePath + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)zipPath.substring(zipPath.lastIndexOf("/") + 1));
            FileUtil.deleteFile((String)zipPath);
        }
    }

    @Override
    public void minIoDownFileBySourceId(String sourceIds, String bizPath, HttpServletResponse response) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        if (StringUtils.isNotBlank((CharSequence)sourceIds)) {
            List<String> idList;
            LambdaQueryWrapper wrapper;
            List accessories;
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            if ((accessories = this.list((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BizAccessory::getSourceId, idList = Arrays.asList(sourceIds.split(",")))))).size() == 1) {
                BizAccessory accessory = (BizAccessory)((Object)accessories.get(0));
                String url = accessory.getUrl();
                String newUrl = url.substring(0, url.lastIndexOf("&"));
                String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
                FileOutputStream out = new FileOutputStream(path + "/" + accessory.getName());
                MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + substring), (OutputStream)out, (boolean)false);
                HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + accessory.getName()), (String)accessory.getName());
                FileUtil.deleteFile((String)(filePath + "/" + accessory.getName()));
                return;
            }
            accessories.forEach(s -> {
                String url = s.getUrl();
                String newUrl = url.substring(0, url.lastIndexOf("&"));
                String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + s.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + substring), (OutputStream)out, (boolean)false);
            });
            this.zip(filePath, true);
            String zipPath = filePath + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)zipPath.substring(zipPath.lastIndexOf("/") + 1));
            FileUtil.deleteFile((String)zipPath);
        }
    }

    @Override
    public void minIoDown(String name, String bizPath, HttpServletResponse response) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            LambdaQueryWrapper accessoryQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)accessoryQW.like(BizAccessory::getUrl, (Object)name)).orderByDesc(BizAccessory::getCreateTime)).last("limit 1");
            BizAccessory accessory = (BizAccessory)((Object)((BizAccessoryDao)this.baseMapper).selectOne((Wrapper)accessoryQW));
            if (BeanUtils.isEmpty((Object)((Object)accessory))) {
                throw new BaseException("\u6587\u4ef6\u672a\u627e\u5230");
            }
            FileOutputStream out = new FileOutputStream(path + "/" + accessory.getName());
            MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + name), (OutputStream)out, (boolean)false);
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + accessory.getName()), (String)accessory.getName());
            FileUtil.deleteFile((String)(filePath + "/" + accessory.getName()));
            return;
        }
    }

    @Override
    public void minIoDown(String name, String bizPath, String bucketName, HttpServletResponse response) throws Exception {
        String customBucket = "cgpt";
        if (BeanUtils.isNotEmpty((Object)bucketName)) {
            customBucket = bucketName;
        }
        String fileName = name;
        String filePath = "download/" + bizPath;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            LambdaQueryWrapper accessoryQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)accessoryQW.like(BizAccessory::getUrl, (Object)name)).orderByDesc(BizAccessory::getCreateTime)).last("limit 1");
            BizAccessory accessory = (BizAccessory)((Object)((BizAccessoryDao)this.baseMapper).selectOne((Wrapper)accessoryQW));
            if (BeanUtils.isNotEmpty((Object)((Object)accessory))) {
                fileName = accessory.getName();
            }
            FileOutputStream out = new FileOutputStream(path + "/" + fileName);
            MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + name), (OutputStream)out, (boolean)false);
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + fileName), (String)fileName);
            FileUtil.deleteFile((String)(filePath + "/" + fileName));
            return;
        }
    }

    @Override
    public FileOutputStream minIoDownFile(String id, String bizPath) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        BizAccessory accessory = (BizAccessory)((Object)this.getById((Serializable)((Object)id)));
        String url = accessory.getUrl();
        String newUrl = url.substring(0, url.lastIndexOf("&"));
        String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
        FileOutputStream out = new FileOutputStream(path + "/" + accessory.getName());
        MinioUtil.downFile((String)customBucket, (String)(bizPath + "/" + substring), (OutputStream)out, (boolean)false);
        return out;
    }

    @Override
    public InputStream minIoGetFile(String id, String bizPath) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        BizAccessory accessory = (BizAccessory)((Object)this.getById((Serializable)((Object)id)));
        String url = accessory.getUrl();
        String newUrl = url.substring(0, url.lastIndexOf("&"));
        String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
        InputStream inputSteam = MinioUtil.getInputSteam((String)customBucket, (String)(bizPath + "/" + substring), (boolean)false);
        return inputSteam;
    }

    @Override
    public InputStream minIoGetFileByUrl(String url, String bizPath) throws Exception {
        String customBucket = "cgpt";
        String filePath = "download/" + bizPath;
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        String newUrl = url.lastIndexOf("&") != -1 ? url.substring(0, url.lastIndexOf("&")) : url;
        String substring = newUrl.substring(newUrl.lastIndexOf("=") + 1);
        return MinioUtil.getInputSteam((String)customBucket, (String)(bizPath + "/" + substring), (boolean)false);
    }

    private void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            ArrayList list = new ArrayList();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir((File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File mergeFile(String fileName) throws FileNotFoundException {
        String dirPath = this.utils.getFileDir(fileName);
        File result = new File(dirPath + "/" + fileName);
        if (result.exists()) {
            result.delete();
        }
        File[] fs = new File(dirPath).listFiles();
        List<File> fileList = Arrays.asList(fs);
        Collections.sort(fileList, (o1, o2) -> Integer.parseInt(o1.getName()) - Integer.parseInt(o2.getName()));
        ArrayList<RandomAccessFile> rafList = new ArrayList<RandomAccessFile>();
        for (File ele : fileList) {
            RandomAccessFile tempFile = new RandomAccessFile(ele, "rw");
            rafList.add(tempFile);
        }
        try (FileChannel outputChannel = new RandomAccessFile(result, "rw").getChannel();){
            for (RandomAccessFile ele : rafList) {
                FileChannel inputChannel = ele.getChannel();
                outputChannel.transferFrom(inputChannel, outputChannel.size(), inputChannel.size());
                inputChannel.close();
            }
            File file = result;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String fileToPdf(BizAccessory accessory) {
        String suffix = accessory.getSuffix();
        if ("pdf".equalsIgnoreCase(suffix)) {
            return null;
        }
        String url = accessory.getUrl();
        String[] urlArr = url.split("/");
        try {
            String downFilePath = this.minIoDownFile(accessory, urlArr[4]);
            String fileName = accessory.getName();
            String inputPath = downFilePath + fileName;
            String outputPath = downFilePath + fileName + ".pdf";
            int i = fileName.lastIndexOf(".");
            if (i > -1 && i < fileName.length() - 1) {
                outputPath = downFilePath + fileName.substring(0, i) + ".pdf";
            }
            this.officeToPdf.office2pdf(inputPath, outputPath);
            return outputPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<BizAccessory> getAccessoryByGroup(String group) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("GROUP_", (Object)group, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        return ((BizAccessoryDao)this.baseMapper).selectPageBySourceId((IPage<BizAccessory>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BizAccessory>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
    }

    @Override
    public BizAccessory minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        BizAccessory accessory = new BizAccessory();
        String fileName = null;
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        accessory.setSuffix(suffix);
        List<String> suffixList = Arrays.asList("png,jpg,jpeg,xlsx,xls,pdf,docx,doc,zip,rar,excel,pptx,stp".split(","));
        if (!suffixList.contains(suffix.toLowerCase())) {
            throw new BaseException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e0a\u4f20");
        }
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = ContextUtil.getCurrentUserId();
        String userName = ContextUtil.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizAccessoryManagerImpl.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.getSize() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name);
        accessory.setBidSignStatus(1);
        return accessory;
    }

    @Override
    public BizAccessory minioUpload(MultipartFile file, String bizPath, String bucketName, HttpServletResponse response) throws Exception {
        BizAccessory accessory = new BizAccessory();
        String fileName = null;
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        accessory.setSuffix(fileName.substring(fileName.lastIndexOf(".") + 1));
        List<String> suffixList = Arrays.asList("png,jpg,jpeg,xlsx,xls,pdf,docx,doc,zip,rar,excel,pptx,stp".split(","));
        if (!suffixList.contains(accessory.getSuffix())) {
            throw new BaseException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e0a\u4f20");
        }
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = ContextUtil.getCurrentUserId();
        String userName = ContextUtil.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizAccessoryManagerImpl.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.getSize() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name, bucketName);
        accessory.setBidSignStatus(1);
        return accessory;
    }

    @Override
    public BizAccessory minioUpload(MultipartFile file, String bizPath) throws Exception {
        BizAccessory accessory = new BizAccessory();
        String fileName = file.getOriginalFilename();
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        accessory.setSuffix(suffix);
        List<String> suffixList = Arrays.asList("png,jpg,jpeg,xlsx,xls,pdf,docx,doc,zip,rar,excel,pptx".split(","));
        if (!suffixList.contains(suffix.toLowerCase())) {
            throw new BaseException("\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e0a\u4f20");
        }
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = ContextUtil.getCurrentUserId();
        String userName = ContextUtil.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizAccessoryManagerImpl.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.getSize() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name);
        return accessory;
    }

    @Override
    public BizAccessory getFileById(String id) {
        return ((BizAccessoryDao)this.baseMapper).selectById(id);
    }

    @Override
    public BizAccessory getFileByCreateBy(String id) {
        return ((BizAccessoryDao)this.baseMapper).selectByCreatorId(id);
    }

    public static Integer handleFileType(String suffix) {
        if ("bmp,jpg,jpeg,png,gif,webp".indexOf(suffix) != -1) {
            return 1;
        }
        if ("docx,doc,xls,xlsx,ppt,pptx,pdf,htl,html,txt".indexOf(suffix) != -1) {
            return 2;
        }
        if ("rar,zip,7z,gz,bz,ace,uha,uda,zpaq".indexOf(suffix) != -1) {
            return 3;
        }
        if ("avi,wmv,mpg,mpeg,mov,rm,ram,swf,flv,mp4".indexOf(suffix) != -1) {
            return 4;
        }
        return 5;
    }
}

