/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.vo.EvaluationOptVo;
import com.artfess.gyl.supplierEva.vo.EvaluationResultVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.gyl.supplierEva.vo.SupplierScore;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizSupplierPerformanceEvaluation/v1/"})
@Api(tags={"\u4f9b\u5e94\u5546\u7ee9\u6548\u8003\u6838-\u8003\u6838\u8bc4\u4ef7\u914d\u7f6e"})
@ApiGroup(group={"group_biz_gyl"})
public class BizSupplierPerformanceEvaluationController
extends BaseController<BizSupplierPerformanceEvaluationManager, BizSupplierPerformanceEvaluation> {
    @PostMapping(value={"/groupSaveModel"})
    @ApiOperation(value="\u4fdd\u5b58\u4f9b\u5e94\u5546\u7ee9\u6548\u8003\u6838\u914d\u7f6e")
    public CommonResult<String> groupSaveModel(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Valid @RequestBody EvaluationDTO dto) {
        Boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).batchCreateEvaluationFromTemplate(dto);
        if (!result.booleanValue()) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)((Object)dto), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/getModel/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<String> getModel(@PathVariable(value="id") String id) {
        EvaluationResultVo model = ((BizSupplierPerformanceEvaluationManager)this.baseService).getModelById(id);
        return CommonResult.success((Object)model, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/getUserModel/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<String> getModelByUser(@PathVariable(value="id") String id) {
        EvaluationOptVo model = ((BizSupplierPerformanceEvaluationManager)this.baseService).getModelByUser(id);
        return CommonResult.success((Object)((Object)model), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/getEvaluationUser/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u8bc4\u5206\u60c5\u51b5")
    public CommonResult<String> getUserRatings(@PathVariable(value="id") String id) {
        List<SupplierScore> userRatings = ((BizSupplierPerformanceEvaluationManager)this.baseService).getUserEvaluations(id);
        return CommonResult.success(userRatings, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @GetMapping(value={"/getRatingUser"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u7528\u6237\u8bc4\u5206\u60c5\u51b5")
    public CommonResult<String> getUserRatings(@RequestParam(value="evaluationId") String evaluationId, @RequestParam(value="detailsId") String detailsId) {
        List<SupplierScore> userRatings = ((BizSupplierPerformanceEvaluationManager)this.baseService).getUserRatings(evaluationId, detailsId);
        return CommonResult.success(userRatings, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/queryByEva"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a-\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<EvaluationVo> queryByEva(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryEvaluationList(queryFilter);
    }

    @PostMapping(value={"/queryByUser"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e13\u5bb6-\u6839\u636e\u7528\u6237\u67e5\u8be2\u5ba1\u8bc4")
    public PageList<EvaluationVo> queryByUser(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryEvaluationListByUser(queryFilter, user.getAccount());
    }

    @PostMapping(value={"/queryByPersonalSum"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e13\u5bb6-\u6839\u636e\u7528\u6237\u67e5\u8be2\u8be5\u9879\u8003\u6838\u4e2d\u5bf9\u4f9b\u5e94\u5546\u7684\u6574\u4f53\u8bc4\u5206\u60c5\u51b5")
    public PageList<EvaluationVo> queryByPersonalSum(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("r.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("rat.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("ru.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("ru.RATING_ACCOUNT_", (Object)user.getAccount(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryByPersonalSum(queryFilter);
    }

    @PostMapping(value={"/queryByHistory"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f01\u4e1a-\u5206\u9875\u67e5\u8be2\u5386\u53f2\u8003\u6838\u6570\u636e")
    public PageList<EvaluationVo> queryByHistory(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.ENTERPRISE_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("result.STATUS_", (Object)"1", QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryEvaluationList(queryFilter);
    }

    @PostMapping(value={"/queryBySupplier"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f9b\u5e94\u5546-\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<EvaluationVo> queryBySupplier(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("result.SUPPLIER_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return ((BizSupplierPerformanceEvaluationManager)this.baseService).queryEvaluationList(queryFilter);
    }

    @PostMapping(value={"/userRating"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u5206")
    public CommonResult<String> userRating(@RequestBody List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).saveUserRating(ratingList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success(ratingList, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/subUserRating"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u63d0\u4ea4\u7528\u6237\u8bc4\u5206")
    public CommonResult userRating(@RequestParam(value="evaluationId") String evaluationId) {
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).submitUserRating(evaluationId);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)true, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/userEva"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u8bc4\u4ef7")
    public CommonResult<String> userEva(@RequestBody ResultEvaDTO dto) {
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).submitUserEvaluation(dto);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)dto, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public CommonResult<String> remove(@RequestParam(required=true, value="id") String id) {
        List<String> resultIds = Arrays.asList(id.split(","));
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).remove(resultIds);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success(resultIds, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateByIds"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0")
    public CommonResult<String> remove(@RequestParam(required=true, value="ids") String ids, @RequestParam(required=true, value="status") Integer status) {
        List<String> idList = Arrays.asList(ids.split(","));
        boolean result = ((BizSupplierPerformanceEvaluationManager)this.baseService).updateByIds(idList, status);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)result, (String)"\u64cd\u4f5c\u6210\u529f");
    }
}

