/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceDefManager;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/sysDataSource/v1"})
@Api(tags={"\u6570\u636e\u6e90\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class SysDataSourceController
extends BaseController<SysDataSourceManager, SysDataSource> {
    @Resource
    SysDataSourceManager sysDataSourceManager;
    @Resource
    SysDataSourceDefManager sysDataSourceDefManager;
    @Resource
    DatabaseContext databaseContext;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u6e90\u5217\u8868", httpMethod="POST", notes="\u6570\u636e\u6e90\u5217\u8868")
    public PageList<SysDataSource> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysDataSource> queryFilter) throws Exception {
        return this.sysDataSourceManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u6e90\u4fe1\u606f", httpMethod="GET", notes="\u6570\u636e\u6e90\u4fe1\u606f")
    @ResponseBody
    public SysDataSource getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysDataSource();
        }
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceManager.get((Serializable)((Object)id));
        return sysDataSource;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysDataSource sysDataSource) throws Exception {
        boolean isConnection = this.sysDataSourceManager.checkConnection(sysDataSource);
        boolean isAliasExist = this.sysDataSourceManager.isAliasExist(sysDataSource.getAlias());
        if (isAliasExist && StringUtil.isEmpty((String)sysDataSource.getId())) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        if (!isConnection) {
            return new CommonResult(false, "\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        String resultMsg = null;
        if (StringUtil.isEmpty((String)sysDataSource.getId())) {
            sysDataSource.setId(UniqueIdUtil.getSuid());
            this.sysDataSourceManager.create((Model)sysDataSource);
            resultMsg = "\u6dfb\u52a0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        } else {
            this.sysDataSourceManager.update((Model)sysDataSource);
            resultMsg = "\u66f4\u65b0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        }
        return new CommonResult(resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysDataSourceManager.removeByIds(Arrays.asList(aryIds));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"checkConnection"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5", httpMethod="POST", notes="\u6d4b\u8bd5\u8fde\u63a5")
    public CommonResult<String> checkConnection(@ApiParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysDataSource sysDataSource) throws Exception {
        boolean b = this.sysDataSourceManager.checkConnection(sysDataSource);
        String resultMsg = "";
        resultMsg = b ? sysDataSource.getName() + ":\u8fde\u63a5\u6210\u529f" : sysDataSource.getName() + ":\u8fde\u63a5\u5931\u8d25";
        return new CommonResult(b, resultMsg);
    }

    @RequestMapping(value={"getDataSources"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6e90", httpMethod="GET", notes="\u83b7\u53d6\u6570\u636e\u6e90")
    public List<SysDataSource> getDataSources() throws Exception {
        PageBean pageBean = new PageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        QueryFilter queryFilter = QueryFilter.build().withPage(pageBean).withQuery(new QueryField("enabled_", (Object)1, QueryOP.EQUAL));
        PageList query = this.sysDataSourceManager.query(queryFilter);
        List result = query.getRows();
        result.add(this.sysDataSourceManager.getDefaultDataSource());
        return result;
    }

    @RequestMapping(value={"getBeanByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\uff0c\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\uff0c\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b")
    public JsonNode getBeanByAlias(@ApiParam(name="alias", value="\u6570\u636e\u6e90\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return JsonUtil.toJsonNode((Object)this.sysDataSourceManager.getByAlias(alias));
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u6e90", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u6e90")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "sysDataSource_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = ((SysDataSourceManager)this.baseService).export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"sysDataSource.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u6e90", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u6e90")
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            ((SysDataSourceManager)this.baseService).importFile(unZipFilePath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }
}

