/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.bpm.exception.BusinessException;
import com.artfess.gyl.base.dao.BizSupplierMaterialCategoryDetailsDao;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryDetailsManager;
import com.artfess.gyl.base.model.BizSupplierMaterialCategoryDetails;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierMaterialCategoryDetailsManagerImpl
extends BaseManagerImpl<BizSupplierMaterialCategoryDetailsDao, BizSupplierMaterialCategoryDetails>
implements BizSupplierMaterialCategoryDetailsManager {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean bathBind(List<BizSupplierMaterialCategoryDetails> details) {
        String orgId = ContextUtil.getCurrentOrgId();
        String currentOrgName = ContextUtil.getCurrentOrgName();
        String currentUserId = ContextUtil.getCurrentUserId();
        String currentUserName = ContextUtil.getCurrentUserName();
        if (CollectionUtils.isEmpty(details)) {
            this.log.warn("\u6279\u91cf\u7ed1\u5b9a\u6570\u636e\u4e3a\u7a7a");
            return false;
        }
        try {
            details.forEach(detail -> {
                detail.setCreateOrgName(currentOrgName);
                detail.setCreateOrgId(orgId);
                detail.setCreateBy(currentUserId);
                detail.setCreateName(currentUserName);
            });
            List<String> ids = details.stream().map(BizSupplierMaterialCategoryDetails::getCategoryId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                this.log.warn("\u6709\u6548\u7684\u5206\u7c7bID\u4e3a\u7a7a");
                return false;
            }
            this.bathCancel(ids);
            return super.saveBatch(details);
        }
        catch (Exception e) {
            throw new BusinessException("\u6279\u91cf\u7ed1\u5b9a\u5931\u8d25");
        }
    }

    @Override
    public boolean bathCancel(List<String> materialCategoryIds) {
        if (CollectionUtils.isEmpty(materialCategoryIds)) {
            this.log.warn("\u53d6\u6d88\u7ed1\u5b9a\u7684\u5206\u7c7bID\u4e3a\u7a7a");
            return true;
        }
        try {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.in(BizSupplierMaterialCategoryDetails::getCategoryId, materialCategoryIds)).eq(BizSupplierMaterialCategoryDetails::getEnterpriseId, (Object)ContextUtil.getCurrentOrgId());
            return super.remove((Wrapper)wrapper);
        }
        catch (Exception e) {
            throw new BusinessException("\u6279\u91cf\u53d6\u6d88\u7ed1\u5b9a\u5931\u8d25");
        }
    }
}

