/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.portal.model.ShorturlManage;
import com.artfess.portal.persistence.manager.ShorturlManageManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.google.common.hash.Hashing;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/shorturlManage/v1/"})
public class ShorturlManageController
extends BaseController<ShorturlManageManager, ShorturlManage> {
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    SaaSConfig saaSConfig;
    @Resource
    BaseContext baseContext;

    @GetMapping(value={"/getLongUrlByShortUrl"})
    @ApiOperation(value="\u6839\u636e\u77ed\u8fde\u63a5\u83b7\u53d6\u77ed\u8fde\u63a5\u914d\u7f6e\u76f8\u5173\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u77ed\u8fde\u63a5\u83b7\u53d6\u77ed\u8fde\u63a5\u914d\u7f6e\u76f8\u5173\u4fe1\u606f")
    public CommonResult<ShorturlManage> getLongUrlByShortUrl(@ApiParam(name="shortUrl", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String shortUrl) throws Exception {
        ShorturlManage shortUrlManage = null;
        if (this.saaSConfig.isEnable()) {
            try (MultiTenantIgnoreResult multiTenantIgnoreResult = MultiTenantHandler.setThreadLocalIgnore();){
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"SHORT_URL_", (Object)shortUrl);
                shortUrlManage = (ShorturlManage)((ShorturlManageManager)this.baseService).getOne((Wrapper)wrapper);
            }
        } else {
            shortUrlManage = ((ShorturlManageManager)this.baseService).getByShortUrl(shortUrl);
        }
        String errorMsg = "";
        if (BeanUtils.isEmpty((Object)shortUrlManage)) {
            errorMsg = "2";
        } else if ("2".equals(shortUrlManage.getEnabled())) {
            errorMsg = "3";
        } else if (BeanUtils.isNotEmpty((Object)shortUrlManage.getLoseTime()) && TimeUtil.getTimeMillis((LocalDateTime)shortUrlManage.getLoseTime()) < TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())) {
            errorMsg = "4";
        }
        if (StringUtil.isNotEmpty((String)errorMsg)) {
            return new CommonResult(false, errorMsg);
        }
        if (this.saaSConfig.isEnable()) {
            this.baseContext.setTempTenantId(shortUrlManage.getTenantId());
            IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
            IUser userByAccount = userService.getUserByAccount("guest");
            shortUrlManage.setGuestToken(this.jwtTokenHandler.generateToken((UserDetails)userByAccount));
        } else {
            shortUrlManage.setGuestToken(this.jwtTokenHandler.generateToken("guest"));
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)shortUrlManage);
    }

    @PostMapping(value={"/getShortUrlByLong"})
    @ApiOperation(value="\u6839\u636e\u957f\u8fde\u63a5\u83b7\u53d6\u77ed\u8fde\u63a5\uff0c\u957f\u94fe\u63a5\u5df2\u5b58\u5728\u8bb0\u5f55\uff0c\u5219\u76f4\u63a5\u8fd4\u56de\u5df2\u6709\u914d\u7f6e\u3002\u4e0d\u5b58\u5728\u5219\u751f\u6210\u65b0\u7684\u77ed\u94fe\u63a5\u5e76\u4fdd\u5b58", httpMethod="POST", notes="\u66f4\u65b0\u77ed\u94fe\u63a5\u5bf9\u8c61")
    public CommonResult<ShorturlManage> getShortUrlByLong(@ApiParam(name="getShortUrlByLong", value="\u77ed\u94fe\u63a5\u5bf9\u8c61", required=true) @RequestBody ShorturlManage vo) throws Exception {
        CommonResult rtn = null;
        try {
            String shourtUrl = "";
            shourtUrl = this.saaSConfig.isEnable() ? "surl/" + Hashing.murmur3_32().hashString((CharSequence)(vo.getUrl() + ContextUtil.getCurrentUser().getTenantId()), StandardCharsets.UTF_8).toString() : "surl/" + Hashing.murmur3_32().hashString((CharSequence)vo.getUrl(), StandardCharsets.UTF_8).toString();
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
            queryFilter.addFilter("short_url_", (Object)shourtUrl, QueryOP.RIGHT_LIKE);
            PageList query = ((ShorturlManageManager)this.baseService).query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
                for (ShorturlManage shorturlManage : query.getRows()) {
                    if (!vo.getUrl().equals(shorturlManage.getUrl())) continue;
                    return new CommonResult(true, "\u83b7\u53d6\u77ed\u94fe\u63a5\u6210\u529f", (Object)shorturlManage);
                }
                shourtUrl = shourtUrl + query.getRows().size();
            }
            vo.setShortUrl(shourtUrl);
            vo.setId(UniqueIdUtil.getSuid());
            ((ShorturlManageManager)this.baseService).save(vo);
            rtn = new CommonResult(true, "\u6839\u636e\u957f\u8fde\u63a5\u83b7\u53d6\uff01", (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, "\u6839\u636e\u957f\u8fde\u63a5\u83b7\u53d6!", null);
        }
        return rtn;
    }

    @PostMapping(value={"/updateShorturlManage"})
    @ApiOperation(value="\u66f4\u65b0\u94fe\u63a5\u914d\u7f6e\u5bf9\u8c61 ", httpMethod="POST", notes="\u66f4\u65b0\u94fe\u63a5\u914d\u7f6e\u5bf9\u8c61")
    public CommonResult<ShorturlManage> updateShorturlManage(@ApiParam(name="shorturlManage", value="\u77ed\u94fe\u63a5\u5bf9\u8c61", required=true) @RequestBody ShorturlManage vo) throws Exception {
        CommonResult rtn = null;
        try {
            ((ShorturlManageManager)this.baseService).update((Model)vo);
            rtn = new CommonResult(true, "\u66f4\u65b0\u6210\u529f\uff01", (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = new CommonResult(false, "\u66f4\u65b0\u5931\u8d25!", null);
        }
        return rtn;
    }
}

