/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.params.user;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UpdateCompare;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.OperateLogUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import javax.validation.constraints.Email;

@ApiModel
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserVo
implements UpdateCompare {
    @ApiModelProperty(name="id", notes="\u7528\u6237id")
    private String id;
    @ApiModelProperty(name="account", notes="\u767b\u5f55\u5e10\u53f7\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", required=true)
    private String account;
    @ApiModelProperty(name="fullname", notes="\u7528\u6237\u540d", required=true)
    private String fullname;
    @ApiModelProperty(name="userNumber", notes="\u5de5\u53f7", required=true)
    private String userNumber;
    @ApiModelProperty(name="password", notes="\u767b\u5f55\u5bc6\u7801\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", required=true)
    private String password;
    @ApiModelProperty(name="email", notes="\u90ae\u7bb1\u5730\u5740")
    @Email(message="{valid.com.artfess.Email} {valid.com.artfess.Email.message}")
    private @Email(message="{valid.com.artfess.Email} {valid.com.artfess.Email.message}") String email;
    @ApiModelProperty(name="mobile", notes="\u624b\u673a\u53f7\u7801")
    private String mobile;
    @ApiModelProperty(name="weixin", notes="\u5fae\u4fe1")
    private String weixin;
    @ApiModelProperty(name="address", notes="\u5730\u5740")
    private String address;
    @ApiModelProperty(name="sex", notes="\u6027\u522b", allowableValues="\u7537,\u5973,\u672a\u77e5")
    private String sex;
    @ApiModelProperty(name="photo", notes="\u5934\u50cf\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09", allowableValues="\u7528\u6237\u7684\u5934\u50cf")
    protected String photo;
    @ApiModelProperty(name="status", notes="\u72b6\u6001 1\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528\uff1b-1\uff1a\u5f85\u6fc0\u6d3b\uff1b-2\uff1a\u79bb\u804c\uff08\u9ed8\u8ba4\u4e3a\u6b63\u5e38\uff09")
    private Integer status;
    @ApiModelProperty(name="idCard", notes="\u8eab\u4efd\u8bc1\u53f7")
    private String idCard;
    @ApiModelProperty(name="phone", notes="\u529e\u516c\u7535\u8bdd")
    private String phone;
    @ApiModelProperty(name="birthday", notes="\u751f\u65e5")
    private String birthday;
    @ApiModelProperty(name="entryDate", notes="\u5165\u804c\u65e5\u671f")
    private String entryDate;
    @ApiModelProperty(name="leaveDate", notes="\u79bb\u804c\u65e5\u671f")
    private LocalDate leaveDate;
    @ApiModelProperty(name="education", notes="\u5b66\u5386")
    private String education;
    @ApiModelProperty(name="updateTime", notes="\u66f4\u65b0\u65f6\u95f4")
    private LocalDateTime updateTime;
    @ApiModelProperty(name="isDelete", notes="\u662f\u5426\u5df2\u5220\u9664 1\u5df2\u5220\u9664 0\u672a\u5220\u9664\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09")
    private String isDelete;
    @ApiModelProperty(name="version", notes="\u7248\u672c\u53f7\uff08\u66f4\u65b0\u65f6\u4e0d\u4f1a\u66f4\u65b0\uff09")
    private Integer version;
    @ApiModelProperty(name="from", notes="\u6765\u6e90")
    private String from;
    @ApiModelProperty(name="params", notes="\u7528\u6237\u53c2\u6570\uff08\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u65f6\u624d\u4f1a\u6709\u503c\uff09")
    private Map<String, Object> params;
    @ApiModelProperty(name="tenantId", notes="\u79df\u6237id")
    protected String tenantId;
    @ApiModelProperty(name="clientId", notes="\u63a8\u9001\u670d\u52a1\u4ee4\u724c\uff08\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\uff09")
    protected String clientId;
    @ApiModelProperty(name="clientToken", notes="\u8bbe\u5907\u4ee4\u724c\uff08iOS\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\uff09")
    protected String clientToken;
    @ApiModelProperty(name="lockedTime", notes="\u9501\u5b9a\u65f6\u95f4")
    protected LocalDateTime lockedTime;
    @ApiModelProperty(name="lockedStatus", notes="\u9501\u5b9a\u72b6\u6001\uff081\uff1a\u6b63\u5e38 2\uff1a\u5df2\u9501\u5b9a\uff09")
    protected Integer lockedStatus;
    @ApiModelProperty(name="userType", notes="\u4eba\u5458\u7c7b\u578b\uff080\uff1a\u8d85\u7ea7\u7ba1\u7406\u5458 1\uff1a\u7ba1\u7406\u8d26\u53f7 2\uff1a\u666e\u901a\u8d26\u53f7  \uff09")
    protected Integer userType;
    @ApiModelProperty(name="lastLoginTime", notes="\u6700\u540e\u767b\u5f55\u65f6\u95f4")
    protected LocalDateTime lastLoginTime;
    @ApiModelProperty(name="orgCode", notes="\u7ec4\u7ec7\u7f16\u53f7")
    private String orgCode;
    @ApiModelProperty(name="systemCode", notes="\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\uff08\u53ef\u8bbf\u95ee\u7684\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\uff09")
    private String systemCode;
    @ApiModelProperty(name="businessType", notes="\u4e1a\u52a1\u7c7b\u578b\uff080\uff1a\u4e70\u65b9\uff0c1\uff1a\u5356\u65b9\uff0c2\uff1a\u65e2\u662f\u4e70\u65b9\u53c8\u662f\u5356\u65b9\uff09")
    private String businessType;
    @ApiModelProperty(name="contrFlag", notes="\u5408\u540c\u4eba\u5458\u6807\u8bc6\uff080\uff1a\u5426\uff0c1\uff1a\u662f\uff09")
    private Integer contrFlag;

    public UserVo(User user) {
        this.id = user.getId();
        this.account = user.getAccount();
        this.fullname = user.getFullname();
        this.userNumber = user.getUserNumber();
        this.email = user.getEmail() == null ? "" : user.getEmail();
        this.mobile = user.getMobile() == null ? "" : user.getMobile();
        this.address = user.getAddress() == null ? "" : user.getAddress();
        this.sex = user.getSex() == null ? "" : user.getSex();
        this.photo = user.getPhoto() == null ? "" : user.getPhoto();
        this.status = user.getStatus();
        this.idCard = user.getIdCard() == null ? "" : user.getIdCard();
        this.phone = user.getPhone() == null ? "" : user.getPhone();
        this.birthday = BeanUtils.isNotEmpty((Object)user.getBirthday()) ? DateFormatUtil.format((LocalDateTime)user.getBirthday().atStartOfDay(), (String)"yyyy-MM-dd") : "";
        this.entryDate = BeanUtils.isNotEmpty((Object)user.getEntryDate()) ? DateFormatUtil.format((LocalDateTime)user.getEntryDate().atStartOfDay(), (String)"yyyy-MM-dd") : "";
        this.leaveDate = user.getLeaveDate();
        this.education = user.getEducation() == null ? "" : user.getEducation();
        this.updateTime = user.getUpdateTime();
        this.isDelete = user.getIsDelete();
        this.version = user.getVersion() == null ? 1 : user.getVersion();
        this.from = user.getFrom();
        this.tenantId = user.getTenantId();
        this.clientId = user.getClientId();
        this.clientToken = user.getClientToken();
        this.lastLoginTime = user.getLastLoginTime();
        this.lockedStatus = user.getLockedStatus() == null ? 1 : user.getLockedStatus();
        this.lockedTime = user.getLockedTime();
        this.userType = user.getUserType() == null ? 2 : user.getUserType();
    }

    public static User parser(UserVo userVo) throws ParseException {
        User user = new User();
        user.setAccount(userVo.getAccount());
        user.setFullname(userVo.getFullname());
        user.setUserNumber(userVo.getUserNumber());
        user.setEmail(userVo.getEmail());
        user.setMobile(userVo.getMobile());
        user.setAddress(userVo.getAddress());
        user.setSex(userVo.getSex());
        user.setPhoto(userVo.getPhoto());
        user.setStatus(userVo.getStatus());
        user.setIdCard(userVo.getIdCard());
        user.setPhone(userVo.getPhone());
        user.setBirthday(StringUtil.isNotEmpty((String)userVo.getBirthday()) ? DateFormatUtil.parse((String)userVo.getBirthday(), (String)"yyyy-MM-dd").toLocalDate() : null);
        user.setEntryDate(StringUtil.isNotEmpty((String)userVo.getEntryDate()) ? DateFormatUtil.parse((String)userVo.getEntryDate(), (String)"yyyy-MM-dd").toLocalDate() : null);
        user.setLeaveDate(userVo.getLeaveDate());
        user.setEducation(userVo.getEducation());
        user.setUserType(userVo.getUserType());
        user.setLockedStatus(userVo.getLockedStatus());
        user.setLockedTime(userVo.getLockedTime());
        user.setLastLoginTime(userVo.getLastLoginTime());
        return user;
    }

    public String toString() {
        return "{\"account\":\"" + this.account + "\"," + "\"" + "fullname" + "\"" + ":" + "\"" + this.fullname + "\"," + "\"" + "userNumber" + "\"" + ":" + "\"" + this.userNumber + "\"," + "\"" + "password" + "\"" + ":" + "\"" + this.password + "\"," + "\"" + "email" + "\"" + ":" + "\"" + this.email + "\"," + "\"" + "mobile" + "\"" + ":" + "\"" + this.mobile + "\"," + "\"" + "address" + "\"" + ":" + "\"" + this.address + "\"," + "\"" + "sex" + "\"" + ":" + "\"" + this.sex + "\"," + "\"" + "status" + "\"" + ":" + "\"" + this.status + "\"," + "\"" + "idCard" + "\"" + ":" + "\"" + this.idCard + "\"," + "\"" + "phone" + "\"" + ":" + "\"" + this.phone + "\"," + "\"" + "birthday" + "\"" + ":" + "\"" + this.birthday + "\"," + "\"" + "entryDate" + "\"" + ":" + "\"" + this.entryDate + "\"," + "\"" + "leaveDate" + "\"" + ":" + "\"" + this.leaveDate + "\"," + "\"" + "education" + "\"" + ":" + "\"" + this.education + "\"" + "\"" + "updateTime" + "\"" + ":" + "\"" + this.updateTime + "\"" + "\"" + "isDelete" + "\"" + ":" + "\"" + this.isDelete + "\"" + "\"" + "version" + "\"" + ":" + "\"" + this.version + "\"" + "\"" + "from" + "\"" + ":" + "\"" + this.from + "\"," + "\"" + "userType" + "\"" + ":" + "\"" + this.userType + "\"," + "\"," + "\"" + "lockedStatus" + "\"" + ":" + "\"" + this.lockedStatus + "\"," + "\"," + "\"" + "lockedTime" + "\"" + ":" + "\"" + this.lockedTime + "\"," + "\"," + "\"" + "lastLoginTime" + "\"" + ":" + "\"" + this.lastLoginTime + "\"," + "\"" + "}";
    }

    public UserVo() {
    }

    public String compare() throws Exception {
        UserManager service = (UserManager)AppUtil.getBean(UserManager.class);
        User oldVo = service.getByAccount(this.account);
        UserVo newVo = this;
        newVo.setVersion(null);
        newVo.setParams(null);
        return OperateLogUtil.compare(newVo, UserVo.changeVo(oldVo));
    }

    public static UserVo changeVo(User oldVo) {
        UserVo newVo = new UserVo();
        if (BeanUtils.isEmpty((Object)oldVo)) {
            return newVo;
        }
        newVo.setAccount(oldVo.getAccount());
        newVo.setAddress(oldVo.getAddress());
        newVo.setBirthday(DateFormatUtil.format((LocalDateTime)oldVo.getBirthday().atStartOfDay(), (String)"yyyy-MM-dd"));
        newVo.setEducation(oldVo.getEducation());
        newVo.setEmail(oldVo.getEmail());
        newVo.setEntryDate(DateFormatUtil.format((LocalDateTime)oldVo.getEntryDate().atStartOfDay(), (String)"yyyy-MM-dd"));
        newVo.setLeaveDate(oldVo.getLeaveDate());
        newVo.setFrom(oldVo.getFrom());
        newVo.setFullname(oldVo.getFullname());
        newVo.setIdCard(oldVo.getIdCard());
        newVo.setIsDelete(oldVo.getIsDelete());
        newVo.setMobile(oldVo.getMobile());
        newVo.setPhone(oldVo.getPhone());
        newVo.setPhoto(oldVo.getPhoto());
        newVo.setSex(oldVo.getSex());
        newVo.setStatus(oldVo.getStatus());
        newVo.setUpdateTime(oldVo.getUpdateTime());
        newVo.setUserNumber(oldVo.getUserNumber());
        newVo.setTenantId(oldVo.getTenantId());
        newVo.setUserType(oldVo.getUserType());
        newVo.setLockedStatus(oldVo.getLockedStatus());
        newVo.setLockedTime(oldVo.getLockedTime());
        newVo.setLastLoginTime(oldVo.getLastLoginTime());
        return newVo;
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSex() {
        return this.sex;
    }

    public String getPhoto() {
        return this.photo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public String getEntryDate() {
        return this.entryDate;
    }

    public LocalDate getLeaveDate() {
        return this.leaveDate;
    }

    public String getEducation() {
        return this.education;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public String getIsDelete() {
        return this.isDelete;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getFrom() {
        return this.from;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public LocalDateTime getLockedTime() {
        return this.lockedTime;
    }

    public Integer getLockedStatus() {
        return this.lockedStatus;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public LocalDateTime getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public Integer getContrFlag() {
        return this.contrFlag;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public void setLeaveDate(LocalDate leaveDate) {
        this.leaveDate = leaveDate;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public void setIsDelete(String isDelete) {
        this.isDelete = isDelete;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public void setLockedTime(LocalDateTime lockedTime) {
        this.lockedTime = lockedTime;
    }

    public void setLockedStatus(Integer lockedStatus) {
        this.lockedStatus = lockedStatus;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public void setLastLoginTime(LocalDateTime lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setContrFlag(Integer contrFlag) {
        this.contrFlag = contrFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserVo)) {
            return false;
        }
        UserVo other = (UserVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$fullname = this.getFullname();
        String other$fullname = other.getFullname();
        if (this$fullname == null ? other$fullname != null : !this$fullname.equals(other$fullname)) {
            return false;
        }
        String this$userNumber = this.getUserNumber();
        String other$userNumber = other.getUserNumber();
        if (this$userNumber == null ? other$userNumber != null : !this$userNumber.equals(other$userNumber)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$weixin = this.getWeixin();
        String other$weixin = other.getWeixin();
        if (this$weixin == null ? other$weixin != null : !this$weixin.equals(other$weixin)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$sex = this.getSex();
        String other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        String this$photo = this.getPhoto();
        String other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !this$photo.equals(other$photo)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$idCard = this.getIdCard();
        String other$idCard = other.getIdCard();
        if (this$idCard == null ? other$idCard != null : !this$idCard.equals(other$idCard)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$birthday = this.getBirthday();
        String other$birthday = other.getBirthday();
        if (this$birthday == null ? other$birthday != null : !this$birthday.equals(other$birthday)) {
            return false;
        }
        String this$entryDate = this.getEntryDate();
        String other$entryDate = other.getEntryDate();
        if (this$entryDate == null ? other$entryDate != null : !this$entryDate.equals(other$entryDate)) {
            return false;
        }
        LocalDate this$leaveDate = this.getLeaveDate();
        LocalDate other$leaveDate = other.getLeaveDate();
        if (this$leaveDate == null ? other$leaveDate != null : !((Object)this$leaveDate).equals(other$leaveDate)) {
            return false;
        }
        String this$education = this.getEducation();
        String other$education = other.getEducation();
        if (this$education == null ? other$education != null : !this$education.equals(other$education)) {
            return false;
        }
        LocalDateTime this$updateTime = this.getUpdateTime();
        LocalDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$isDelete = this.getIsDelete();
        String other$isDelete = other.getIsDelete();
        if (this$isDelete == null ? other$isDelete != null : !this$isDelete.equals(other$isDelete)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientToken = this.getClientToken();
        String other$clientToken = other.getClientToken();
        if (this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken)) {
            return false;
        }
        LocalDateTime this$lockedTime = this.getLockedTime();
        LocalDateTime other$lockedTime = other.getLockedTime();
        if (this$lockedTime == null ? other$lockedTime != null : !((Object)this$lockedTime).equals(other$lockedTime)) {
            return false;
        }
        Integer this$lockedStatus = this.getLockedStatus();
        Integer other$lockedStatus = other.getLockedStatus();
        if (this$lockedStatus == null ? other$lockedStatus != null : !((Object)this$lockedStatus).equals(other$lockedStatus)) {
            return false;
        }
        Integer this$userType = this.getUserType();
        Integer other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        LocalDateTime this$lastLoginTime = this.getLastLoginTime();
        LocalDateTime other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !((Object)this$lastLoginTime).equals(other$lastLoginTime)) {
            return false;
        }
        String this$orgCode = this.getOrgCode();
        String other$orgCode = other.getOrgCode();
        if (this$orgCode == null ? other$orgCode != null : !this$orgCode.equals(other$orgCode)) {
            return false;
        }
        String this$systemCode = this.getSystemCode();
        String other$systemCode = other.getSystemCode();
        if (this$systemCode == null ? other$systemCode != null : !this$systemCode.equals(other$systemCode)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        Integer this$contrFlag = this.getContrFlag();
        Integer other$contrFlag = other.getContrFlag();
        return !(this$contrFlag == null ? other$contrFlag != null : !((Object)this$contrFlag).equals(other$contrFlag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $fullname = this.getFullname();
        result = result * 59 + ($fullname == null ? 43 : $fullname.hashCode());
        String $userNumber = this.getUserNumber();
        result = result * 59 + ($userNumber == null ? 43 : $userNumber.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $weixin = this.getWeixin();
        result = result * 59 + ($weixin == null ? 43 : $weixin.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        String $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : $photo.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $idCard = this.getIdCard();
        result = result * 59 + ($idCard == null ? 43 : $idCard.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $birthday = this.getBirthday();
        result = result * 59 + ($birthday == null ? 43 : $birthday.hashCode());
        String $entryDate = this.getEntryDate();
        result = result * 59 + ($entryDate == null ? 43 : $entryDate.hashCode());
        LocalDate $leaveDate = this.getLeaveDate();
        result = result * 59 + ($leaveDate == null ? 43 : ((Object)$leaveDate).hashCode());
        String $education = this.getEducation();
        result = result * 59 + ($education == null ? 43 : $education.hashCode());
        LocalDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $isDelete = this.getIsDelete();
        result = result * 59 + ($isDelete == null ? 43 : $isDelete.hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientToken = this.getClientToken();
        result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
        LocalDateTime $lockedTime = this.getLockedTime();
        result = result * 59 + ($lockedTime == null ? 43 : ((Object)$lockedTime).hashCode());
        Integer $lockedStatus = this.getLockedStatus();
        result = result * 59 + ($lockedStatus == null ? 43 : ((Object)$lockedStatus).hashCode());
        Integer $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        LocalDateTime $lastLoginTime = this.getLastLoginTime();
        result = result * 59 + ($lastLoginTime == null ? 43 : ((Object)$lastLoginTime).hashCode());
        String $orgCode = this.getOrgCode();
        result = result * 59 + ($orgCode == null ? 43 : $orgCode.hashCode());
        String $systemCode = this.getSystemCode();
        result = result * 59 + ($systemCode == null ? 43 : $systemCode.hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        Integer $contrFlag = this.getContrFlag();
        result = result * 59 + ($contrFlag == null ? 43 : ((Object)$contrFlag).hashCode());
        return result;
    }
}

