/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.sqlbuilder.service.impl;

import com.artfess.base.sqlbuilder.ISqlBuilder;
import com.artfess.base.sqlbuilder.MySqlSqlBuilder;
import com.artfess.base.sqlbuilder.OracleSqlBuilder;
import com.artfess.base.sqlbuilder.PgSqlSqlBuilder;
import com.artfess.base.sqlbuilder.SqlBuilderModel;
import com.artfess.base.sqlbuilder.SqlServerSqlBuilder;
import com.artfess.base.sqlbuilder.service.ISqlBuilderService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="sqlBuilderService")
public class SqlBuilderService
implements ISqlBuilderService {
    protected Map<String, ISqlBuilder> builderMap = new HashMap<String, ISqlBuilder>();
    @Autowired
    ApplicationContext context;

    public void setBuilderMap(Map<String, ISqlBuilder> builderMap) {
        this.builderMap = builderMap;
    }

    @Override
    public String getSql(SqlBuilderModel model) {
        ISqlBuilder builder = this.getSqlBuilder(model);
        if (builder != null) {
            return builder.getSql();
        }
        return "";
    }

    @Override
    public ISqlBuilder getSqlBuilder(SqlBuilderModel model) {
        String dbType = model.getDbType();
        ISqlBuilder builder = this.builderMap.get(dbType);
        if (builder == null) {
            builder = "mysql".equals(dbType) ? new MySqlSqlBuilder() : ("oracle".equals(dbType) ? new OracleSqlBuilder() : ("postgresql".equals(dbType) ? new PgSqlSqlBuilder() : new SqlServerSqlBuilder()));
        }
        builder.setModel(model);
        return builder;
    }
}

