/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.utils;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.file.util.MinioUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MinioUtils {
    @Async
    public void startMinIOUpload(File file, String bizPath, String name) throws Exception {
        String result = MinioUtil.upload((MultipartFile)((MultipartFile)file), (String)bizPath, (String)name, (String)"gyl");
        if (!StringUtils.isEmpty((CharSequence)result)) {
            FileUtil.deleteDir((File)file.getParentFile());
        }
    }

    @Async
    public void startMinIOUpload(File file, String bizPath, String name, String bucketName) throws Exception {
        String result = MinioUtil.upload((MultipartFile)((MultipartFile)file), (String)bizPath, (String)name, (String)bucketName);
        if (!StringUtils.isEmpty((CharSequence)result)) {
            FileUtil.deleteDir((File)file.getParentFile());
        }
    }

    public void startMinIOUpload(MultipartFile file, String bizPath, String name) throws Exception {
        String result = MinioUtil.upload((MultipartFile)file, (String)bizPath, (String)name, (String)"cgpt");
        if (!StringUtils.isEmpty((CharSequence)result)) {
            String fileName = file.getOriginalFilename();
            String prefix = fileName.substring(fileName.lastIndexOf("."));
            try {
                File data = File.createTempFile(fileName, prefix);
                file.transferTo(data);
                FileUtil.deleteDir((File)data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startMinIOUpload(MultipartFile file, String bizPath, String name, String bucketName) throws Exception {
        String result = MinioUtil.upload((MultipartFile)file, (String)bizPath, (String)name, (String)(BeanUtils.isNotEmpty((Object)bucketName) ? bucketName : "cgpt"));
        if (!StringUtils.isEmpty((CharSequence)result)) {
            String fileName = file.getOriginalFilename();
            String prefix = fileName.substring(fileName.lastIndexOf("."));
            try {
                File data = File.createTempFile(fileName, prefix);
                file.transferTo(data);
                FileUtil.deleteDir((File)data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getFileDir(String subDir) {
        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath().substring(1) + "static/uploadingFileTemp/" + subDir.split("[.]")[0];
        System.out.println("*********************" + path);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    public String getofficeToPdfTempDir(String subDir) {
        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath().substring(1) + "static/officeToPdfTemp/" + subDir.split("[.]")[0];
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }
}

