/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.ecologyOa.controller;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.gyl.ecologyOa.manager.EcologyOaManager;
import com.artfess.gyl.ecologyOa.vo.CreateWorkVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6cdb\u5faeOA\u7cfb\u7edf\u63a5\u53e3"})
@ApiGroup(group={"group_uc"})
@RequestMapping(value={"ecologyOa"})
public class EcologyOaController {
    @Value(value="${ecologyOa.getToDoWorkListUrl}")
    private String getToDoWorkListUrl;
    @Value(value="${ecologyOa.getHandledWorkListUrl}")
    private String getHandledWorkListUrl;
    @Value(value="${ecologyOa.getRequestWorkListUrl}")
    private String getRequestWorkListUrl;
    @Autowired
    private EcologyOaManager ecologyOaManager;

    @PostMapping(value={"/getToken"})
    @ApiOperation(value="M-\u83b7\u53d6\u6cdb\u5faetoken")
    public CommonResult getToken() {
        String token = this.ecologyOaManager.getToken();
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)token);
    }

    @PostMapping(value={"/getOaUserId"})
    @ApiOperation(value="M-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6cdb\u5fae\u7528\u6237id")
    public CommonResult getOaUserId() {
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String userId = this.ecologyOaManager.getOaUserId(mobile);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)userId);
    }

    @PostMapping(value={"/getTaskCount"})
    @ApiOperation(value="M-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5f85\u529e\u6570\u91cf")
    public CommonResult getTaskCount() {
        Integer count = this.ecologyOaManager.getTaskCount();
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)count);
    }

    @PostMapping(value={"/getToDoWorkList"})
    @ApiOperation(value="M-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5f85\u529e\u5217\u8868")
    public CommonResult getToDoWorkList() {
        JSONArray result = this.ecologyOaManager.getWorkList(this.getToDoWorkListUrl);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/getHandledWorkList"})
    @ApiOperation(value="M-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5df2\u529e\u5217\u8868")
    public CommonResult getHandledWorkList() {
        JSONArray result = this.ecologyOaManager.getWorkList(this.getHandledWorkListUrl);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/getRequestWorkList"})
    @ApiOperation(value="M-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8bf7\u6c42\u5217\u8868")
    public CommonResult getRequestWorkList() {
        JSONArray result = this.ecologyOaManager.getWorkList(this.getRequestWorkListUrl);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/createWork"})
    @ApiOperation(value="M-\u521b\u5efa\u6d41\u7a0b")
    public JSONObject createWork(@RequestBody CreateWorkVo createWorkVo) {
        JSONObject result = this.ecologyOaManager.createWork(createWorkVo, null);
        return result;
    }

    @PostMapping(value={"/getSsoToken"})
    @ApiOperation(value="M-\u83b7\u53d6ssoToken")
    public CommonResult getSsoToken() {
        String result = this.ecologyOaManager.getSsoToken();
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }
}

