/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.UpdateMethod;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.User;
import com.artfess.uc.params.job.JobVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OrgUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/job/v1/"})
@Api(tags={"\u804c\u52a1\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class JobController
extends BaseController<OrgJobManager, OrgJob> {
    @Resource
    OrgJobManager orgJobService;

    @RequestMapping(value={"jobs/getJobPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u804c\u52a1\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u804c\u52a1\u5217\u8868")
    public PageList<OrgJob> getJobPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        PageList query = this.orgJobService.query(filter);
        return query;
    }

    @RequestMapping(value={"jobs/getJobList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u804c\u52a1\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u804c\u52a1\u5217\u8868")
    public List<OrgJob> getJobList(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        User currentUser = ContextUtil.getCurrentUser();
        if (!currentUser.isAdmin()) {
            filter.addFilter("create_org_id_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        return this.orgJobService.query(filter).getRows();
    }

    @RequestMapping(value={"job/addJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u804c\u52a1", httpMethod="POST", notes="\u6dfb\u52a0\u804c\u52a1")
    public CommonResult<String> addJob(@ApiParam(name="job", value="\u804c\u52a1\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody JobVo job) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgJobService.addJob(job);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"");
        }
        return rtn;
    }

    @RequestMapping(value={"job/addJobFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u6dfb\u52a0\u804c\u52a1\u5230\u7cfb\u7edf", httpMethod="POST", notes="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u6dfb\u52a0\u804c\u52a1\u5230\u7cfb\u7edf")
    public CommonResult<String> addJobFromExterUni(@ApiParam(name="job", value="\u804c\u52a1\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody OrgJob job) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.orgJobService.addJobFromExterUni(job);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"");
        }
        return rtn;
    }

    @RequestMapping(value={"job/deleteJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u5220\u9664\u804c\u52a1", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u804c\u52a1")
    public CommonResult<String> deleteJob(@ApiParam(name="codes", value="\u804c\u52a1\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.orgJobService.deleteJob(codes);
    }

    @RequestMapping(value={"job/deleteJobByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1id\u5220\u9664\u804c\u52a1", httpMethod="DELETE", notes="\u6839\u636e\u804c\u52a1id\u5220\u9664\u804c\u52a1")
    public CommonResult<String> deleteJobByIds(@ApiParam(name="ids", value="\u804c\u52a1id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        return this.orgJobService.deleteJobByIds(ids);
    }

    @RequestMapping(value={"job/updateJob"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u804c\u52a1", httpMethod="PUT", notes="\u66f4\u65b0\u804c\u52a1")
    @UpdateMethod(type=JobVo.class)
    public CommonResult<String> updateJob(@ApiParam(name="job", value="\u804c\u52a1\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody JobVo job) throws Exception {
        return this.orgJobService.updateJob(job);
    }

    @RequestMapping(value={"job/getJob"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u6216id\u83b7\u53d6\u804c\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u804c\u52a1\u4fe1\u606f")
    public OrgJob getJob(@ApiParam(name="code", value="\u804c\u52a1\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        OrgJob job = this.orgJobService.getByCode(code);
        if (BeanUtils.isEmpty((Object)job)) {
            job = (OrgJob)this.orgJobService.get((Serializable)((Object)code));
        }
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u3010" + code + "\u3011\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        return job;
    }

    @RequestMapping(value={"job/getOrgJob"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u6216id\u83b7\u53d6\u804c\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u804c\u52a1\u4fe1\u606f")
    public CommonResult<OrgJob> getOrgJob(@ApiParam(name="code", value="\u804c\u52a1\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        OrgJob job = this.orgJobService.getByCode(code);
        if (BeanUtils.isEmpty((Object)job)) {
            job = (OrgJob)this.orgJobService.get((Serializable)((Object)code));
        }
        return new CommonResult(true, "\u83b7\u53d6\u804c\u52a1\u6210\u529f", (Object)job);
    }

    @RequestMapping(value={"jobUser/getUsersByJob"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u804c\u52a1\uff08\u591a\u4e2a\uff09\u4e0b\u7684\u6240\u6709\u4eba\u5458", httpMethod="GET", notes="\u83b7\u53d6\u804c\u52a1\u4e0b\u7684\u6240\u6709\u4eba\u5458")
    public List<UserVo> getUsersByJob(@ApiParam(name="codes", value="\u804c\u52a1\u7f16\u7801\uff08\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String codes) throws Exception {
        return this.orgJobService.getUsersByJob(codes);
    }

    @RequestMapping(value={"job/deleteJobPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u804c\u52a1\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u804c\u52a1\u6570\u636e")
    public CommonResult<Integer> deleteJobPhysical() throws Exception {
        Integer num = this.orgJobService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"jobs/getJobByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u804c\u52a1\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u804c\u52a1\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgJob> getJobByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        return this.orgJobService.getJobByTime(btime, etime);
    }

    @RequestMapping(value={"job/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u804c\u52a1\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u804c\u52a1\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u804c\u52a1\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.orgJobService.isCodeExist(code);
    }
}

