/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.usercalc.hrScript.context;

import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.usercalc.hrScript.def.HrScriptPluginDef;
import com.artfess.bpm.plugin.usercalc.hrScript.runtime.HrScriptPlugin;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.w3c.dom.Element;

public class HrScriptPluginContext
extends AbstractUserCalcPluginContext {
    private static final long serialVersionUID = -2353875054502587417L;

    @Override
    public String getDescription() {
        HrScriptPluginDef def = (HrScriptPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        return def.getDescription();
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return HrScriptPlugin.class;
    }

    @Override
    public String getTitle() {
        return "\u4eba\u5458\u811a\u672c";
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        HrScriptPluginDef hrScriptPluginDef = new HrScriptPluginDef();
        Element el = XmlUtil.getChildNodeByName((Element)element, (String)"content");
        Element descEL = XmlUtil.getChildNodeByName((Element)element, (String)"description");
        Element idEl = XmlUtil.getChildNodeByName((Element)element, (String)"scriptId");
        Element paramsEl = XmlUtil.getChildNodeByName((Element)element, (String)"params");
        hrScriptPluginDef.setScript(el.getTextContent());
        hrScriptPluginDef.setDescription(descEL == null ? "\u4eba\u5458\u811a\u672c" : descEL.getTextContent());
        hrScriptPluginDef.setScriptId(idEl == null ? "" : idEl.getTextContent());
        hrScriptPluginDef.setParams(paramsEl == null ? "" : paramsEl.getTextContent());
        return hrScriptPluginDef;
    }

    @Override
    public String getPluginXml() {
        HrScriptPluginDef def = (HrScriptPluginDef)this.getBpmPluginDef();
        if (def == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<hrScript xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/hrScript\" ");
        sb.append("  logicCal=\"" + def.getLogicCal().getKey() + "\" extract=\"" + def.getExtract().getKey() + "\">");
        sb.append("<content>");
        sb.append("<![CDATA[");
        sb.append(def.getScript());
        sb.append("]]>");
        sb.append("</content>");
        sb.append("<description>");
        sb.append("<![CDATA[");
        sb.append(def.getDescription());
        sb.append("]]>");
        sb.append("</description>");
        sb.append("<scriptId>");
        sb.append("<![CDATA[");
        sb.append(def.getScriptId());
        sb.append("]]>");
        sb.append("</scriptId>");
        sb.append("<params>");
        sb.append("<![CDATA[");
        sb.append(def.getParams());
        sb.append("]]>");
        sb.append("</params>");
        sb.append("</hrScript>");
        return sb.toString();
    }

    @Override
    protected BpmPluginDef parseJson(ObjectNode pluginJson) {
        HrScriptPluginDef def = new HrScriptPluginDef();
        String script = pluginJson.get("script").asText();
        String description = JsonUtil.getString((JsonNode)pluginJson, (String)"description", (String)"\u4eba\u5458\u811a\u672c");
        def.setScript(script);
        def.setDescription(description);
        if (JsonUtil.isContainsKey((JsonNode)pluginJson, (String)"scriptId")) {
            String scriptId = pluginJson.get("scriptId").asText();
            def.setScriptId(scriptId);
        }
        if (JsonUtil.isContainsKey((JsonNode)pluginJson, (String)"params")) {
            String params = null;
            try {
                params = JsonUtil.toJson((Object)pluginJson.get("params"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            def.setParams(params);
        }
        return def;
    }
}

