/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.enterprise.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.exception.BusinessException;
import com.artfess.uc.enterprise.dao.EnterpriseDao;
import com.artfess.uc.enterprise.manager.EnterpriseManager;
import com.artfess.uc.enterprise.model.Enterprise;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.UcBaseModel;
import com.artfess.uc.model.User;
import com.artfess.uc.openApi.vo.Response;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class EnterpriseManagerImpl
extends BaseManagerImpl<EnterpriseDao, Enterprise>
implements EnterpriseManager {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseManagerImpl.class);
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private RoleManager roleManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateEnterprise(Enterprise entity) {
        this.validateEnterprise(entity);
        boolean isExist = this.checkEnterpriseExist(entity.getCompanyCode());
        this.syncOrganization(entity, isExist);
        this.saveOrUpdateEnterpriseInfo(entity, isExist);
    }

    private void validateEnterprise(Enterprise entity) {
        if (entity == null) {
            throw new BusinessException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)entity.getCompanyCode())) {
            throw new BusinessException("\u4f01\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)entity.getCompanyName())) {
            throw new BusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateEnterprises(List<Enterprise> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (int i = 0; i < entities.size(); ++i) {
            try {
                this.validateEnterprise(entities.get(i));
                continue;
            }
            catch (BusinessException e) {
                throw new BusinessException("\u7b2c" + (i + 1) + "\u6761\u6570\u636e\u6821\u9a8c\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private boolean checkEnterpriseExist(String companyCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(Enterprise::getCompanyCode, (Object)companyCode)).select(new SFunction[]{Enterprise::getId}).oneOpt().isPresent();
    }

    private void syncOrganization(Enterprise entity, boolean isCreate) {
        try {
            if (isCreate) {
                this.createOrganization(entity);
            } else {
                this.updateOrganization(entity);
            }
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, \u4f01\u4e1a\u7f16\u7801: {}, \u662f\u5426\u521b\u5efa: {}", new Object[]{entity.getCompanyCode(), isCreate, e});
            throw new BusinessException("\u7ec4\u7ec7\u4fe1\u606f\u540c\u6b65\u5931\u8d25: " + e.getMessage());
        }
    }

    private void createOrganization(Enterprise entity) throws Exception {
        OrgVo orgVo = this.buildOrgVoForCreate(entity);
        this.orgManager.addOrg(orgVo);
        log.info("\u521b\u5efa\u7ec4\u7ec7\u6210\u529f, \u4f01\u4e1a\u7f16\u7801: {}", (Object)entity.getCompanyCode());
    }

    private OrgVo buildOrgVoForCreate(Enterprise entity) {
        OrgVo orgVo = new OrgVo();
        orgVo.setCode(entity.getCompanyCode());
        orgVo.setDemId("1258608622670319616");
        orgVo.setExceedLimitNum(0);
        orgVo.setGrade(entity.getOrgType());
        orgVo.setLimitNum(0);
        orgVo.setName(entity.getCompanyName());
        orgVo.setNowNum(0);
        orgVo.setOrgKind("ogn");
        orgVo.setParentId("0");
        return orgVo;
    }

    private void updateOrganization(Enterprise entity) throws Exception {
        Org org = this.orgManager.getOrg(entity.getCompanyCode());
        if (org == null) {
            log.warn("\u7ec4\u7ec7\u4e0d\u5b58\u5728, \u4f01\u4e1a\u7f16\u7801: {}, \u5c1d\u8bd5\u521b\u5efa", (Object)entity.getCompanyCode());
            this.createOrganization(entity);
            return;
        }
        if (!StringUtils.equals((String)org.getName(), (String)entity.getCompanyName())) {
            org.setName(entity.getCompanyName());
            this.orgManager.updateById(org);
            log.info("\u66f4\u65b0\u7ec4\u7ec7\u6210\u529f, \u4f01\u4e1a\u7f16\u7801: {}, \u65b0\u540d\u79f0: {}", (Object)entity.getCompanyCode(), (Object)entity.getCompanyName());
        } else {
            log.debug("\u7ec4\u7ec7\u540d\u79f0\u672a\u53d8\u5316, \u65e0\u9700\u66f4\u65b0, \u4f01\u4e1a\u7f16\u7801: {}", (Object)entity.getCompanyCode());
        }
    }

    private void createOrganizationSafely(Enterprise entity) {
        try {
            this.createOrganization(entity);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25, \u4f01\u4e1a\u7f16\u7801: {}", (Object)entity.getCompanyCode(), (Object)e);
            throw new BusinessException("\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25: " + e.getMessage());
        }
    }

    private void updateOrganizationSafely(Enterprise entity) {
        try {
            this.updateOrganization(entity);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25, \u4f01\u4e1a\u7f16\u7801: {}", (Object)entity.getCompanyCode(), (Object)e);
            throw new BusinessException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25: " + e.getMessage());
        }
    }

    private void saveOrUpdateEnterpriseInfo(Enterprise entity, boolean isCreate) {
        boolean result;
        if (!isCreate) {
            this.setEnterpriseIdForUpdate(entity);
        }
        if (!(result = super.saveOrUpdate((Object)entity))) {
            throw new BusinessException("\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25");
        }
        log.info("\u4f01\u4e1a\u4fe1\u606f{}\u6210\u529f, \u4f01\u4e1a\u7f16\u7801: {}, \u4f01\u4e1a\u540d\u79f0: {}", new Object[]{isCreate ? "\u521b\u5efa" : "\u66f4\u65b0", entity.getCompanyCode(), entity.getCompanyName()});
    }

    private void setEnterpriseIdForUpdate(Enterprise entity) {
        Enterprise existing = this.getEnterpriseByCode(entity.getCompanyCode());
        entity.setId(existing.getId());
    }

    private Enterprise getEnterpriseByCode(String companyCode) {
        return (Enterprise)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Enterprise::getCompanyCode, (Object)companyCode)).oneOpt().orElseThrow(() -> new BusinessException("\u4f01\u4e1a\u4e0d\u5b58\u5728: " + companyCode)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveOrUpdate(List<Enterprise> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        try {
            this.validateEnterprises(entities);
            Map<String, Enterprise> existMap = this.getExistingEnterprisesMap(entities);
            ArrayList<Enterprise> toCreate = new ArrayList<Enterprise>();
            ArrayList<Enterprise> toUpdate = new ArrayList<Enterprise>();
            for (Enterprise entity : entities) {
                if (existMap.containsKey(entity.getCompanyCode())) {
                    Enterprise existing = existMap.get(entity.getCompanyCode());
                    entity.setId(existing.getId());
                    toUpdate.add(entity);
                    continue;
                }
                entity.setId(null);
                toCreate.add(entity);
            }
            this.batchCreateEnterprises(toCreate);
            this.batchUpdateEnterprises(toUpdate);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            if (e instanceof BusinessException) {
                throw e;
            }
            throw new BusinessException("\u6279\u91cf\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Response saveOrUpdateUserByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = "";
        try {
            List data = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), UserVo.class);
            for (UserVo temp : data) {
                this.saveOrUpdateUserByApi(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }

    private void batchCreateEnterprises(List<Enterprise> enterprises) {
        if (CollectionUtils.isEmpty(enterprises)) {
            return;
        }
        boolean saveResult = super.saveBatch(enterprises);
        if (!saveResult) {
            throw new BusinessException("\u6279\u91cf\u521b\u5efa\u4f01\u4e1a\u5931\u8d25");
        }
        for (Enterprise enterprise : enterprises) {
            try {
                this.createOrganization(enterprise);
            }
            catch (Exception e) {
                throw new BusinessException("\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void batchUpdateEnterprises(List<Enterprise> enterprises) {
        if (CollectionUtils.isEmpty(enterprises)) {
            return;
        }
        boolean updateResult = super.updateBatchById(enterprises);
        if (!updateResult) {
            throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u4f01\u4e1a\u5931\u8d25");
        }
        for (Enterprise enterprise : enterprises) {
            try {
                this.updateOrganization(enterprise);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25, \u4f01\u4e1a\u7f16\u7801: {}", (Object)enterprise.getCompanyCode(), (Object)e);
            }
        }
        log.info("\u6279\u91cf\u66f4\u65b0{}\u4e2a\u4f01\u4e1a\u6210\u529f", (Object)enterprises.size());
    }

    private Map<String, Enterprise> getExistingEnterprisesMap(List<Enterprise> entities) {
        List companyCodes = entities.stream().map(Enterprise::getCompanyCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(companyCodes)) {
            return Collections.emptyMap();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Enterprise::getCompanyCode, companyCodes)).list().stream().collect(Collectors.toMap(Enterprise::getCompanyCode, e -> e));
    }

    public void saveOrUpdateUserByApi(UserVo userVo) throws Exception {
        userVo.setStatus(1);
        userVo.setId(null);
        userVo.setTenantId(null);
        String userId = "";
        LambdaQueryWrapper userQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userQW.and(s -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.eq(User::getAccount, (Object)userVo.getAccount())).or()).eq(User::getMobile, (Object)userVo.getMobile());
        })).eq(UcBaseModel::getIsDelete, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
        User userHis = (User)this.userManager.getBaseMapper().selectOne((Wrapper)userQW);
        if (BeanUtils.isNotEmpty((Object)userHis)) {
            userId = userHis.getId();
            userVo.setId(userHis.getId());
            this.userManager.updateUserById(userVo);
        } else {
            userVo.setPassword("Spwz@" + userVo.getMobile());
            userId = this.userManager.addUser(userVo).getId();
        }
        if (BeanUtils.isNotEmpty((Object)userVo.getOrgCode())) {
            Org org = this.orgManager.getByCode(userVo.getOrgCode());
            if (BeanUtils.isEmpty((Object)org)) {
                throw new BaseException("\u7ec4\u7ec7\u7f16\u53f7\u672a\u627e\u5230");
            }
            OrgUser orgUser = this.orgUserManager.getOrgUser(org.getId(), userId, null);
            if (BeanUtils.isEmpty((Object)orgUser)) {
                OrgUserVo orgUserVo = new OrgUserVo();
                orgUserVo.setAccount(userVo.getAccount());
                orgUserVo.setOrgCode(userVo.getOrgCode());
                orgUserVo.setIsMaster(1);
                this.orgManager.addOrgUser(orgUserVo);
            } else {
                orgUser.setIsMaster(1);
                this.orgUserManager.updateById(orgUser);
            }
        }
        ArrayList<String> roleList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)userVo.getContrFlag()) && userVo.getContrFlag() == 1) {
            roleList.add("htqsr");
        }
        if (BeanUtils.isNotEmpty((Object)userVo.getBusinessType())) {
            if (userVo.getBusinessType().equals("0")) {
                roleList.add("qyd");
            } else if (userVo.getBusinessType().equals("1")) {
                roleList.add("gysd");
            } else {
                roleList.add("qyd");
                roleList.add("gysd");
            }
        }
        if (roleList.size() > 0) {
            this.roleManager.saveUserRoles(String.join((CharSequence)",", roleList), userVo.getAccount());
        }
    }
}

