/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.cache.impl;

import com.artfess.base.cache.impl.AbstractValueAdaptingCache;
import com.artfess.base.cache.setting.FirstCacheSetting;
import com.artfess.base.cache.support.ExpireMode;
import com.artfess.base.cache.support.NullValue;
import com.artfess.base.util.BeanUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineCache
extends AbstractValueAdaptingCache {
    protected static final Logger logger = LoggerFactory.getLogger(CaffeineCache.class);
    private final Cache<Object, Object> cache;

    public CaffeineCache(String name, FirstCacheSetting firstCacheSetting) {
        super(name);
        this.cache = CaffeineCache.getCache(firstCacheSetting);
    }

    public Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    @Override
    public Object get(Object key) {
        logger.debug("caffeine\u7f13\u5b58 key={} \u83b7\u53d6\u7f13\u5b58", (Object)this.toJsonString(key));
        if (this.cache instanceof LoadingCache) {
            return ((LoadingCache)this.cache).get(key);
        }
        return this.cache.getIfPresent(key);
    }

    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        boolean isEvict;
        logger.debug("caffeine\u7f13\u5b58 key={} \u83b7\u53d6\u7f13\u5b58\uff0c \u5982\u679c\u6ca1\u6709\u547d\u4e2d\u5c31\u8d70\u5e93\u52a0\u8f7d\u7f13\u5b58", (Object)this.toJsonString(key));
        Object result = this.cache.get(key, k -> this.loaderValue(key, valueLoader));
        boolean bl = isEvict = !this.isAllowNullValues() && (result == null || result instanceof NullValue);
        if (isEvict) {
            this.evict(key);
        }
        return (T)this.fromStoreValue(result);
    }

    @Override
    public void put(Object key, Object value) {
        if (this.isAllowNullValues()) {
            logger.debug("caffeine\u7f13\u5b58 key={} put\u7f13\u5b58", (Object)this.toJsonString(key));
            this.cache.put(key, this.toStoreValue(value));
            return;
        }
        if (value != null && !(value instanceof NullValue)) {
            logger.debug("caffeine\u7f13\u5b58 key={} put\u7f13\u5b58", (Object)this.toJsonString(key));
            this.cache.put(key, this.toStoreValue(value));
        }
        logger.debug("\u7f13\u5b58\u503c\u4e3aNULL\u5e76\u4e14\u4e0d\u5141\u8bb8\u5b58NULL\u503c\uff0c\u4e0d\u7f13\u5b58\u6570\u636e");
    }

    @Override
    public void put(Object key, Object value, Long expiration) {
        if (this.isAllowNullValues()) {
            logger.debug("caffeine\u7f13\u5b58 key={} put\u7f13\u5b58", (Object)this.toJsonString(key));
            this.cache.put(key, this.toStoreValue(value));
            return;
        }
        if (value != null && !(value instanceof NullValue)) {
            logger.debug("caffeine\u7f13\u5b58 key={} put\u7f13\u5b58", (Object)this.toJsonString(key));
            this.cache.put(key, this.toStoreValue(value));
        }
        logger.debug("\u7f13\u5b58\u503c\u4e3aNULL\u5e76\u4e14\u4e0d\u5141\u8bb8\u5b58NULL\u503c\uff0c\u4e0d\u7f13\u5b58\u6570\u636e");
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        boolean flag;
        logger.debug("caffeine\u7f13\u5b58 key={} putIfAbsent \u7f13\u5b58", (Object)this.toJsonString(key));
        boolean bl = flag = !this.isAllowNullValues() && (value == null || value instanceof NullValue);
        if (flag) {
            return null;
        }
        Object result = this.cache.get(key, k -> this.toStoreValue(value));
        return this.fromStoreValue(result);
    }

    @Override
    public void evict(Object key) {
        logger.debug("caffeine\u7f13\u5b58 key={} \u6e05\u9664\u7f13\u5b58", (Object)this.toJsonString(key));
        this.cache.invalidate(key);
    }

    @Override
    public void clear() {
        logger.debug("caffeine\u7f13\u5b58 key={} \u6e05\u7a7a\u7f13\u5b58");
        this.cache.invalidateAll();
    }

    @Override
    public List<Object> getRightKeys(String key) {
        return null;
    }

    @Override
    public Map<String, Object> getKeysValues(String path) {
        return null;
    }

    private <T> Object loaderValue(Object key, Callable<T> valueLoader) {
        try {
            T t = valueLoader.call();
            logger.debug("caffeine\u7f13\u5b58 key={} \u4ece\u5e93\u52a0\u8f7d\u7f13\u5b58", (Object)this.toJsonString(key));
            return this.toStoreValue(t);
        }
        catch (Exception e) {
            throw new AbstractValueAdaptingCache.LoaderCacheValueException(key, e);
        }
    }

    private static Cache<Object, Object> getCache(FirstCacheSetting firstCacheSetting) {
        Caffeine builder = Caffeine.newBuilder();
        builder.initialCapacity(firstCacheSetting.getInitialCapacity());
        builder.maximumSize((long)firstCacheSetting.getMaximumSize());
        if (ExpireMode.WRITE.equals((Object)firstCacheSetting.getExpireMode())) {
            builder.expireAfterWrite((long)firstCacheSetting.getExpireTime(), firstCacheSetting.getTimeUnit());
        } else if (ExpireMode.ACCESS.equals((Object)firstCacheSetting.getExpireMode())) {
            builder.expireAfterAccess((long)firstCacheSetting.getExpireTime(), firstCacheSetting.getTimeUnit());
        }
        return builder.build();
    }

    @Override
    public boolean isAllowNullValues() {
        return false;
    }

    @Override
    public void evictAll(Iterable<? extends Object> keys) {
        if (BeanUtils.isEmpty(keys)) {
            return;
        }
        this.cache.invalidateAll(keys);
    }

    @Override
    public Map<String, String> getAll(Iterable<String> keys, String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (BeanUtils.isEmpty(keys)) {
            return map;
        }
        HashMap newMap = new HashMap();
        for (Map.Entry entry : newMap.entrySet()) {
            String key = (String)entry.getKey();
            map.put(key, key);
        }
        return map;
    }

    @Override
    public void putAll(Map<String, Map<String, String>> map) {
        logger.error("\u5728CaffeineCache\u4e2d\u4e0d\u80fd\u5bf9\u56fd\u9645\u5316\u8d44\u6e90\u8fdb\u884c\u7f13\u5b58\u7684\u8bfb\u5199\u5904\u7406\u3002");
    }

    @Override
    public void hdel(String key, String field) {
        logger.error("\u5728CaffeineCache\u4e2d\u4e0d\u80fd\u5bf9\u56fd\u9645\u5316\u8d44\u6e90\u8fdb\u884c\u7f13\u5b58\u7684\u8bfb\u5199\u5904\u7406\u3002");
    }

    @Override
    public void delLike(String prex) {
    }

    @Override
    public void delByKey(String key) {
    }
}

