/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.dao.BpmBusLinkDao;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.model.BpmBusLink;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmBusLinkManager")
public class BpmBusLinkManagerImpl
extends BaseManagerImpl<BpmBusLinkDao, BpmBusLink>
implements BpmBusLinkManager {
    @Resource
    BpmBusLinkDao bpmBusLinkDao;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    public BpmBusLink getByBusinesKey(String businessKey, String formIdentity, boolean isNumber) {
        return this.bpmBusLinkDao.getByBusinesKey(this.getParams(businessKey, formIdentity, isNumber));
    }

    @Override
    @Transactional
    public void removeDataByInstId(String instId) throws Exception {
        List<BpmBusLink> links = ((BpmBusLinkDao)this.baseMapper).getAllByInstId(instId);
        if (BeanUtils.isNotEmpty(links)) {
            FormFeignService boDefService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            boDefService.removeDataByBusLink(JsonUtil.toJsonNode(links));
        }
        for (BpmBusLink link : links) {
            this.remove((Serializable)((Object)link.getId()));
        }
    }

    @Override
    @Transactional
    public void delByBusinesKey(String businessKey, String formIdentity, boolean isNumber) {
        this.bpmBusLinkDao.delByBusinesKey(this.getParams(businessKey, formIdentity, isNumber));
    }

    @Override
    public List<BpmBusLink> getByInstId(String instId) {
        return this.bpmBusLinkDao.getByInstId(instId);
    }

    @Override
    public BpmBusLink getByBusinesKey(String businessKey, boolean isNumber) {
        return this.bpmBusLinkDao.getByBusinesKey(this.getParams(businessKey, null, isNumber));
    }

    @Transactional
    public void create(BpmBusLink entity) {
        super.create((Model)entity);
    }

    @Override
    @Transactional
    public void removeDataByDefId(String defId) throws Exception {
        List<BpmBusLink> links = this.getByDefId(defId);
        if (BeanUtils.isNotEmpty(links)) {
            FormFeignService boDefService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            boDefService.removeDataByBusLink(JsonUtil.toJsonNode(links));
        }
        for (BpmBusLink link : links) {
            this.remove((Serializable)((Object)link.getId()));
        }
    }

    @Override
    public List<BpmBusLink> getByDefId(String defId) {
        return this.bpmBusLinkDao.getByDefId(defId);
    }

    @Override
    public Map<String, BpmBusLink> getMapByInstId(String instId) {
        HashMap<String, BpmBusLink> map = new HashMap<String, BpmBusLink>();
        List<BpmBusLink> list = this.getByInstId(instId);
        for (BpmBusLink busLink : list) {
            map.put(busLink.getBoDefCode(), busLink);
        }
        return map;
    }

    private Map<String, Object> getParams(String businessKey, String formIdentity, boolean isNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (isNumber) {
            params.put("businessKey", Long.parseLong(businessKey));
        } else {
            params.put("businessKey", businessKey);
        }
        if (StringUtil.isNotEmpty((String)formIdentity)) {
            params.put("formIdentity", formIdentity);
        }
        params.put("isNumber", isNumber);
        return params;
    }

    @Override
    public boolean deleteBatch(List<String> list) {
        return this.bpmBusLinkDao.deleteBatch(list);
    }

    @Override
    public boolean delBatchByBusinesKey(List<Map<String, Object>> list) {
        return this.bpmBusLinkDao.delBatchByBusinesKey(list);
    }
}

