/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.dao.BizSupplierGradingConfigurationDao;
import com.artfess.gyl.base.manager.BizSupplierGradingConfigurationManager;
import com.artfess.gyl.base.manager.BizSupplierGradingSupplyScopeManager;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.model.BizSupplierGradingSupplyScope;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierGradingConfigurationManagerImpl
extends BaseManagerImpl<BizSupplierGradingConfigurationDao, BizSupplierGradingConfiguration>
implements BizSupplierGradingConfigurationManager {
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BizSupplierGradingSupplyScopeManager scopeManager;

    @Transactional(rollbackFor={Exception.class})
    public boolean save(BizSupplierGradingConfiguration entity) {
        boolean save;
        Asserts.notNull(entity.getScopes(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        String no = this.sysIdentityManager.nextId("gysfjbm");
        entity.setCode(no);
        if (StringUtil.isEmpty((String)entity.getStatus())) {
            entity.setStatus("1");
        }
        if (!(save = super.save((Object)entity))) {
            return false;
        }
        List<BizSupplierGradingSupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        scopes.forEach(s -> {
            s.setId(null);
            s.setSupplierGradingConfigurationId(id);
        });
        if (!this.scopeManager.saveBatch(scopes)) {
            throw new ApplicationException("\u5206\u7c7b\u5173\u8054\u5931\u8d25");
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(BizSupplierGradingConfiguration entity) {
        Asserts.notNull(entity.getScopes(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        boolean update = super.updateById((Object)entity);
        if (!update) {
            return false;
        }
        List<BizSupplierGradingSupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, (Object)id);
        this.scopeManager.remove((Wrapper)wrapper);
        scopes.forEach(s -> {
            s.setId(null);
            s.setSupplierGradingConfigurationId(id);
        });
        if (!this.scopeManager.saveBatch(scopes)) {
            throw new ApplicationException("\u5206\u7c7b\u5173\u8054\u5931\u8d25");
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, idList);
        this.scopeManager.remove((Wrapper)wrapper);
        return super.removeByIds(idList);
    }

    @Transactional(readOnly=true)
    public BizSupplierGradingConfiguration getById(Serializable id) {
        BizSupplierGradingConfiguration entity = (BizSupplierGradingConfiguration)((Object)super.getById(id));
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, (Object)entity.getId());
        List scopes = this.scopeManager.list((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            entity.setScopes(scopes);
        }
        return entity;
    }

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BizSupplierGradingConfiguration::getId, (Object)id);
        wrapper.set(BizSupplierGradingConfiguration::getStatus, (Object)status);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageList<BizSupplierGradingConfiguration> queryByPage(QueryFilter<BizSupplierGradingConfiguration> queryFilter) {
        IPage<BizSupplierGradingConfiguration> iPage = ((BizSupplierGradingConfigurationDao)this.baseMapper).queryByPage((IPage<BizSupplierGradingConfiguration>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierGradingConfiguration>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public BizSupplierGradingConfiguration getByCategoryConfiguration(String categoryConfigurationId) {
        return ((BizSupplierGradingConfigurationDao)this.baseMapper).getByCategoryConfiguration(categoryConfigurationId);
    }
}

