/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationDao;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationIntervalManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingUserManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationResultManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfigurationUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRating;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationResult;
import com.artfess.gyl.supplierEva.vo.EvaluationOptVo;
import com.artfess.gyl.supplierEva.vo.EvaluationResultVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.gyl.supplierEva.vo.SupplierScore;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationDao, BizSupplierPerformanceEvaluation>
implements BizSupplierPerformanceEvaluationManager {
    @Resource
    private BizSupplierPerformanceEvaluationRatingManager ratingManager;
    @Resource
    private BizSupplierPerformanceEvaluationResultManager resultManager;
    @Resource
    private BizSupplierPerformanceEvaluationRatingUserManager ratingUserManager;
    @Resource
    private BizSupplierPerformanceEvaluationIntervalManager intervalManager;
    @Resource
    private BizSupplierPerformanceEvaluationNotificationManager notificationManager;
    @Resource
    private BizSupplierPerformanceEvaluationApprovalRecordManager recordManager;
    @Resource
    private BizSupplierPerformanceEvaluationConfigurationUserManager supplierManager;
    @Resource
    private FileManager fileManager;
    private static final List<String> COMPLETED_LEVELS = Arrays.asList("1", "2", "3");
    private static final String STATUS_INIT = "0";
    private static final String STATUS_COMPLETED = "1";
    private static final String STATUS_SUBMITTED = "2";
    private static final String STATUS_PARTIAL_COMPLETED = "3";
    private static final String STATUS_ALL_COMPLETED = "4";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchCreateEvaluationFromTemplate(EvaluationDTO dto) {
        IUser user = this.getCurrentUser();
        this.validateEvaluationData(dto);
        List<BizSupplierPerformanceEvaluationConfigurationUser> supplierEnterprise = this.getSupplierEnterprise(dto);
        if (CollectionUtils.isEmpty(supplierEnterprise)) {
            throw new ApplicationException("\u65e0\u5408\u683c\u4f9b\u5e94\u5546\u8fdb\u884c\u5206\u53d1");
        }
        this.initEvaluationData(dto, user);
        boolean saveResult = super.save((Object)dto);
        if (!saveResult) {
            return false;
        }
        this.saveEvaluationResults(dto, supplierEnterprise);
        return true;
    }

    private List<BizSupplierPerformanceEvaluationConfigurationUser> getSupplierEnterprise(EvaluationDTO dto) {
        LambdaQueryWrapper configurationWrapper = new LambdaQueryWrapper();
        configurationWrapper.eq(BizSupplierPerformanceEvaluationConfigurationUser::getValuationConfigurationId, (Object)dto.getValuationConfigurationId());
        return this.supplierManager.list((Wrapper)configurationWrapper);
    }

    private void saveEvaluationResults(EvaluationDTO dto, List<BizSupplierPerformanceEvaluationConfigurationUser> supplierEnterprise) {
        int totalScore = this.calculateTotalScore(dto.getDetails());
        IUser user = ContextUtil.getCurrentUser();
        List<BizSupplierPerformanceEvaluationResult> results = this.createEvaluationResults(dto, supplierEnterprise, totalScore);
        this.resultManager.saveBatch(results);
        results.forEach(result -> this.saveRatingDetailsAndUsers(dto.getId(), result.getId(), dto.getDetails()));
    }

    private int calculateTotalScore(List<BizSupplierPerformanceEvaluationRating> details) {
        return details.stream().mapToInt(BizSupplierPerformanceEvaluationRating::getScore).sum();
    }

    private List<BizSupplierPerformanceEvaluationResult> createEvaluationResults(EvaluationDTO dto, List<BizSupplierPerformanceEvaluationConfigurationUser> supplierEnterprise, int totalScore) {
        return supplierEnterprise.stream().map(item -> this.createEvaluationResult(dto, (BizSupplierPerformanceEvaluationConfigurationUser)((Object)item), totalScore)).collect(Collectors.toList());
    }

    private BizSupplierPerformanceEvaluationResult createEvaluationResult(EvaluationDTO dto, BizSupplierPerformanceEvaluationConfigurationUser item, int totalScore) {
        BizSupplierPerformanceEvaluationResult result = new BizSupplierPerformanceEvaluationResult();
        result.setValuationConfigurationId(dto.getValuationConfigurationId());
        result.setEvaluationId(dto.getId());
        result.setSupplierId(item.getSupplierId());
        result.setSupplierName(item.getSupplierName());
        result.setSupplierCode(item.getSupplierCode());
        result.setTotalScore(totalScore);
        result.setStatus(STATUS_SUBMITTED);
        return result;
    }

    private IUser getCurrentUser() {
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        return user;
    }

    private void validateEvaluationData(EvaluationDTO dto) {
        Asserts.notNull((Object)((Object)dto), (String)"\u8003\u6838\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.notNull(dto.getDetails(), (String)"\u8003\u6838\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initEvaluationData(EvaluationDTO dto, IUser user) {
        dto.setInitiatorId(user.getUserId());
        dto.setInitiatorAccount(user.getAccount());
        dto.setInitiatorName(user.getFullname());
        dto.setStatus(STATUS_SUBMITTED);
        dto.setAssessmentStartDate(LocalDate.now());
    }

    private void saveRatingDetailsAndUsers(String evaluationId, String resultId, List<BizSupplierPerformanceEvaluationRating> details) {
        List<BizSupplierPerformanceEvaluationRating> savedDetails = this.saveRatingDetails(evaluationId, resultId, details);
        this.saveRatingUsers(evaluationId, savedDetails);
    }

    private List<BizSupplierPerformanceEvaluationRating> saveRatingDetails(String evaluationId, String resultId, List<BizSupplierPerformanceEvaluationRating> details) {
        details.forEach(item -> {
            item.setId(null);
            item.setPerformanceEvaluationId(evaluationId);
            item.setPerformanceEvaluationResultId(resultId);
            item.setStatus(STATUS_INIT);
        });
        if (!this.ratingManager.saveBatch(details)) {
            throw new ApplicationException("\u8bc4\u5206\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25");
        }
        return details;
    }

    private void saveRatingUsers(String evaluationId, List<BizSupplierPerformanceEvaluationRating> savedDetails) {
        List userList = savedDetails.stream().filter(item -> CollectionUtils.isNotEmpty(item.getUsers())).flatMap(item -> this.createRatingUsers(evaluationId, (BizSupplierPerformanceEvaluationRating)((Object)item))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userList) && !this.ratingUserManager.saveBatch(userList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private Stream<BizSupplierPerformanceEvaluationRatingUser> createRatingUsers(String evaluationId, BizSupplierPerformanceEvaluationRating item) {
        return item.getUsers().stream().map(sourceUser -> this.createRatingUser(evaluationId, item, (BizSupplierPerformanceEvaluationRatingUser)((Object)sourceUser)));
    }

    private BizSupplierPerformanceEvaluationRatingUser createRatingUser(String evaluationId, BizSupplierPerformanceEvaluationRating item, BizSupplierPerformanceEvaluationRatingUser sourceUser) {
        BizSupplierPerformanceEvaluationRatingUser user = new BizSupplierPerformanceEvaluationRatingUser();
        user.setEvaluationRatingId(item.getId());
        user.setPerformanceEvaluationId(evaluationId);
        user.setRatingId(sourceUser.getRatingId());
        user.setRatingAccount(sourceUser.getRatingAccount());
        user.setRatingName(sourceUser.getRatingName());
        user.setScore(item.getScore());
        user.setStatus(STATUS_INIT);
        return user;
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationResultVo getModelById(String id) {
        EvaluationResultVo vo = this.resultManager.getModel(id);
        if (vo == null) {
            return null;
        }
        this.loadRelatedData(id, vo);
        return vo;
    }

    private void loadRelatedData(String resultId, EvaluationResultVo vo) {
        CompletableFuture<List> ratingsFuture = CompletableFuture.supplyAsync(() -> this.loadRatingDetails(resultId));
        CompletableFuture<List> notificationsFuture = CompletableFuture.supplyAsync(() -> this.loadNotifications(resultId));
        CompletableFuture<List> recordsFuture = CompletableFuture.supplyAsync(() -> this.getRecords(resultId));
        try {
            this.setRatingDetails(vo, ratingsFuture.get());
            this.setNotificationInfo(vo, notificationsFuture.get());
            this.setApprovalRecords(vo, recordsFuture.get());
        }
        catch (Exception e) {
            throw new ApplicationException("\u52a0\u8f7d\u8bc4\u4f30\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void setRatingDetails(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationRating> ratings) {
        if (CollectionUtils.isNotEmpty(ratings)) {
            this.loadRatingUsers(ratings);
            vo.setDetails(ratings);
        }
    }

    private void setNotificationInfo(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationNotification> notifications) {
        if (CollectionUtils.isNotEmpty(notifications)) {
            vo.setNotification(notifications.get(0));
            this.loadCorrectionReportIfNeeded(vo, notifications.get(0));
        }
    }

    private void setApprovalRecords(EvaluationResultVo vo, List<BizSupplierPerformanceEvaluationApprovalRecord> records) {
        if (CollectionUtils.isNotEmpty(records)) {
            vo.setRecords(records);
        }
    }

    private List<BizSupplierPerformanceEvaluationRating> loadRatingDetails(String resultId) {
        return this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)resultId));
    }

    private void loadRatingUsers(List<BizSupplierPerformanceEvaluationRating> ratings) {
        List ratingIds = ratings.stream().map(BizSupplierPerformanceEvaluationRating::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ratingIds)) {
            return;
        }
        List ratingUsers = this.ratingUserManager.list((Wrapper)new LambdaQueryWrapper().in(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, ratingIds));
        if (CollectionUtils.isNotEmpty((Collection)ratingUsers)) {
            Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> userMap = ratingUsers.stream().collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId));
            ratings.forEach(rating -> rating.setUsers((List)userMap.get(rating.getId())));
        }
    }

    private List<BizSupplierPerformanceEvaluationNotification> loadNotifications(String performanceEvaluationId) {
        return this.notificationManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationNotification::getPerformanceEvaluationId, (Object)performanceEvaluationId));
    }

    private void loadCorrectionReportIfNeeded(EvaluationResultVo vo, BizSupplierPerformanceEvaluationNotification notification) {
        BizSupplierPerformanceEvaluationCorrectionReport report;
        if (vo.getProcessType() != null && STATUS_SUBMITTED.equals(vo.getProcessType()) && (report = this.notificationManager.getReport(notification.getId())) != null) {
            vo.setReport(report);
            this.loadReportFiles(report);
        }
    }

    private void loadReportFiles(BizSupplierPerformanceEvaluationCorrectionReport report) {
        List files = this.fileManager.queryFileByBizId(report.getId());
        report.setFiles(files);
    }

    @Override
    @Transactional(readOnly=true)
    public EvaluationOptVo getModelByUser(String id) {
        BizSupplierPerformanceEvaluation evaluation = (BizSupplierPerformanceEvaluation)this.get((Serializable)((Object)id));
        if (evaluation == null) {
            return null;
        }
        EvaluationOptVo vo = new EvaluationOptVo(evaluation);
        IUser user = this.getCurrentUser();
        List<BizSupplierPerformanceEvaluationRating> ratings = this.ratingManager.getByUser(user.getAccount(), id);
        vo.setDetails(ratings);
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SupplierScore> getUserRatings(String evaluationId, String detailsId) {
        IUser user = ContextUtil.getCurrentUser();
        return ((BizSupplierPerformanceEvaluationDao)this.baseMapper).getSupplierScores(user.getAccount(), evaluationId, detailsId);
    }

    @Override
    public List<SupplierScore> getUserEvaluations(String ratingId) {
        return ((BizSupplierPerformanceEvaluationDao)this.baseMapper).getUserEvaluations(ratingId);
    }

    @Override
    public PageList<EvaluationVo> queryEvaluationList(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByEva((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public PageList<EvaluationVo> queryEvaluationListByUser(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter, String account) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByUser((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()), account);
        return new PageList(iPage);
    }

    @Override
    public PageList<EvaluationVo> queryEarlyEvaluationList(QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IPage<EvaluationVo> iPage = ((BizSupplierPerformanceEvaluationDao)this.baseMapper).queryByEarly((IPage<BizSupplierPerformanceEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierPerformanceEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean submitUserRating(List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        if (CollectionUtils.isEmpty(ratingList)) {
            return false;
        }
        LocalDateTime now = LocalDateTime.now();
        IUser user = this.getCurrentUser();
        this.updateRatingUsers(ratingList, now);
        this.processCompletedRatings(ratingList, now, user);
        return true;
    }

    private void updateRatingUsers(List<BizSupplierPerformanceEvaluationRatingUser> ratingList, LocalDateTime now) {
        ratingList.forEach(item -> {
            item.setStatus(STATUS_COMPLETED);
            item.setRatingTime(now);
        });
        if (!this.ratingUserManager.updateBatchById(ratingList)) {
            throw new ApplicationException("\u8bc4\u5206\u7528\u6237\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void processCompletedRatings(List<BizSupplierPerformanceEvaluationRatingUser> ratingList, LocalDateTime now, IUser user) {
        List<String> evaluationRatingIds = ratingList.stream().map(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId).distinct().collect(Collectors.toList());
        Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> allRatingsMap = this.getRatingUsersMap(evaluationRatingIds);
        Map<String, BizSupplierPerformanceEvaluationRating> ratingItemMap = this.getRatingItemsMap(evaluationRatingIds);
        List<BizSupplierPerformanceEvaluationRating> ratingsToUpdate = this.processCompletedRatingGroups(evaluationRatingIds, allRatingsMap, ratingItemMap, now);
        this.batchSaveUpdates(ratingsToUpdate);
    }

    private List<BizSupplierPerformanceEvaluationRating> processCompletedRatingGroups(List<String> evaluationRatingIds, Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> allRatingsMap, Map<String, BizSupplierPerformanceEvaluationRating> ratingItemMap, LocalDateTime now) {
        return evaluationRatingIds.stream().map(evaluationRatingId -> this.processRatingGroup((String)evaluationRatingId, allRatingsMap, ratingItemMap, now)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BizSupplierPerformanceEvaluationRating processRatingGroup(String evaluationRatingId, Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> allRatingsMap, Map<String, BizSupplierPerformanceEvaluationRating> ratingItemMap, LocalDateTime now) {
        List<BizSupplierPerformanceEvaluationRatingUser> ratings = allRatingsMap.get(evaluationRatingId);
        BizSupplierPerformanceEvaluationRating ratingItem = ratingItemMap.get(evaluationRatingId);
        if (ratings == null || ratingItem == null || !this.isRatingGroupCompleted(ratings)) {
            return null;
        }
        this.updateRatingItem(ratingItem, ratings, now);
        return ratingItem;
    }

    private Map<String, List<BizSupplierPerformanceEvaluationRatingUser>> getRatingUsersMap(List<String> evaluationRatingIds) {
        return this.ratingUserManager.list((Wrapper)new LambdaQueryWrapper().in(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId, evaluationRatingIds)).stream().collect(Collectors.groupingBy(BizSupplierPerformanceEvaluationRatingUser::getEvaluationRatingId));
    }

    private Map<String, BizSupplierPerformanceEvaluationRating> getRatingItemsMap(List<String> evaluationRatingIds) {
        return this.ratingManager.listByIds(evaluationRatingIds).stream().collect(Collectors.toMap(BizSupplierPerformanceEvaluationRating::getId, Function.identity()));
    }

    private boolean isRatingGroupCompleted(List<BizSupplierPerformanceEvaluationRatingUser> ratings) {
        return ratings.stream().allMatch(rating -> STATUS_COMPLETED.equals(rating.getStatus()));
    }

    private void updateRatingItem(BizSupplierPerformanceEvaluationRating ratingItem, List<BizSupplierPerformanceEvaluationRatingUser> ratings, LocalDateTime now) {
        BigDecimal averageScore = this.calculateAverageScore(ratings);
        ratingItem.setStatus(STATUS_COMPLETED);
        ratingItem.setRatingTime(now);
        ratingItem.setOperationScore(averageScore);
    }

    private void batchSaveUpdates(List<BizSupplierPerformanceEvaluationRating> ratingsToUpdate) {
        if (CollectionUtils.isNotEmpty(ratingsToUpdate)) {
            this.ratingManager.updateBatchById(ratingsToUpdate);
            this.updatePerformanceEvaluationsForItems(ratingsToUpdate);
        }
    }

    private void updatePerformanceEvaluationsForItems(List<BizSupplierPerformanceEvaluationRating> ratingsToUpdate) {
        ratingsToUpdate.forEach(item -> this.updatePerformanceEvaluations(item.getPerformanceEvaluationResultId()));
    }

    private void updatePerformanceEvaluations(String resultId) {
        BizSupplierPerformanceEvaluationResult result = (BizSupplierPerformanceEvaluationResult)((Object)this.resultManager.getById((Serializable)((Object)resultId)));
        if (!Objects.equals(result.getStatus(), STATUS_SUBMITTED) && !Objects.equals(result.getStatus(), STATUS_PARTIAL_COMPLETED)) {
            throw new ApplicationException("\u5df2\u5b8c\u6210\u8bc4\u5206\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u8fdb\u884c\u67e5\u770b");
        }
        String finalStatus = this.determineFinalStatus(resultId);
        result.setStatus(STATUS_PARTIAL_COMPLETED);
        if (STATUS_ALL_COMPLETED.equals(finalStatus)) {
            this.updateCompletedEvaluation(result);
        }
        this.resultManager.updateById((Object)result);
    }

    private String determineFinalStatus(String resultId) {
        List<BizSupplierPerformanceEvaluationRating> unfinishedRatings = this.getUnfinishedRatings(resultId);
        return unfinishedRatings.isEmpty() ? STATUS_ALL_COMPLETED : STATUS_PARTIAL_COMPLETED;
    }

    private void updateCompletedEvaluation(BizSupplierPerformanceEvaluationResult evaluation) {
        List allRatings = this.ratingManager.list((Wrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)evaluation.getId()));
        BigDecimal totalScore = this.calculateTotalOperationScore(allRatings);
        String level = this.calculateLevel(evaluation.getValuationConfigurationId(), totalScore);
        evaluation.setStatus(COMPLETED_LEVELS.contains(level) ? STATUS_COMPLETED : STATUS_ALL_COMPLETED);
        evaluation.setOperationScore(totalScore);
        evaluation.setLevel(level);
    }

    private BigDecimal calculateTotalOperationScore(List<BizSupplierPerformanceEvaluationRating> allRatings) {
        return allRatings.stream().map(BizSupplierPerformanceEvaluationRating::getOperationScore).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private List<BizSupplierPerformanceEvaluationRating> getUnfinishedRatings(String resultId) {
        return this.ratingManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationRating::getPerformanceEvaluationResultId, (Object)resultId)).ne(BizSupplierPerformanceEvaluationRating::getStatus, (Object)STATUS_COMPLETED));
    }

    private BigDecimal calculateAverageScore(List<BizSupplierPerformanceEvaluationRatingUser> ratings) {
        if (CollectionUtils.isEmpty(ratings)) {
            return BigDecimal.ZERO;
        }
        List validScores = ratings.stream().map(BizSupplierPerformanceEvaluationRatingUser::getOperationScore).filter(Objects::nonNull).collect(Collectors.toList());
        if (validScores.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = validScores.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.divide(BigDecimal.valueOf(validScores.size()), 2, RoundingMode.HALF_UP);
    }

    private String calculateLevel(String configurationId, BigDecimal totalScore) {
        if (StringUtils.isBlank((String)configurationId) || totalScore == null) {
            return STATUS_COMPLETED;
        }
        List intervals = this.intervalManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierPerformanceEvaluationInterval::getPerformanceEvaluationConfigurationId, (Object)configurationId)).le(BizSupplierPerformanceEvaluationInterval::getMinScore, (Object)totalScore.doubleValue())).ge(BizSupplierPerformanceEvaluationInterval::getMaxScore, (Object)totalScore.doubleValue()));
        return intervals.stream().findFirst().map(BizSupplierPerformanceEvaluationInterval::getLevel).orElse(STATUS_COMPLETED);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean submitUserEvaluation(ResultEvaDTO dto) {
        this.notificationManager.saveEva(dto);
        IUser user = this.getCurrentUser();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluationResult::getId, (Object)dto.getPerformanceEvaluationId())).set(BizSupplierPerformanceEvaluationResult::getAssessmentResult, (Object)dto.getAssessmentResult())).set(BizSupplierPerformanceEvaluationResult::getStatus, (Object)STATUS_COMPLETED)).set(BizSupplierPerformanceEvaluationResult::getProcessType, (Object)dto.getProcessType());
        return this.resultManager.update((Wrapper)wrapper);
    }

    private List<BizSupplierPerformanceEvaluationApprovalRecord> getRecords(String performanceEvaluationId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizSupplierPerformanceEvaluationApprovalRecord::getPerformanceEvaluationId, (Object)performanceEvaluationId)).groupBy((Object[])new SFunction[]{BizSupplierPerformanceEvaluationApprovalRecord::getApprovalAccount, BizSupplierPerformanceEvaluationApprovalRecord::getStatus})).orderByAsc(AutoFillModel::getCreateTime);
        return this.recordManager.list((Wrapper)wrapper);
    }

    @Override
    public boolean remove(List<String> idList) {
        List results = this.resultManager.listByIds(idList);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return false;
        }
        boolean anyMatch = results.stream().anyMatch(result -> !result.getStatus().equals(STATUS_PARTIAL_COMPLETED));
        if (anyMatch) {
            throw new ApplicationException("\u5b58\u5728\u5df2\u8bc4\u5206\u7684\u6570\u636e,\u65e0\u6cd5\u5220\u9664\u3002");
        }
        return this.resultManager.removeByIds(idList);
    }
}

