/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.thirdParty.manager.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.FluentUtil;
import com.artfess.gyl.thirdParty.dao.BizScMemberCalculateDao;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.manager.BizScMemberCalculateManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.gyl.thirdParty.model.BizScMemberCalculate;
import com.artfess.gyl.utils.HttpUtils;
import com.artfess.redis.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BizScMemberCalculateManagerImpl
extends BaseManagerImpl<BizScMemberCalculateDao, BizScMemberCalculate>
implements BizScMemberCalculateManager {
    @Value(value="${zfpt.synScMemberCalculateUrl}")
    private String synScMemberCalculateUrl;
    @Value(value="${zfpt.getTokenUrl}")
    private String zfptGetTokenUrl;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private BizEnterpriseManager bizEnterpriseManager;

    @Override
    public com.alibaba.fastjson.JSONObject queryByOrg(QueryFilter<BizScMemberCalculate> queryFilter, String orgId) {
        com.alibaba.fastjson.JSONObject object = new com.alibaba.fastjson.JSONObject();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"ORG_ID_", (Object)orgId);
        wrapper.select(new String[]{"SUM(ANNUAL_TRANS_AMOUNT_) as totalAnnualTransAmount"});
        Map resultMap = super.getMap((Wrapper)wrapper);
        BigDecimal totalPrice = BigDecimal.ZERO;
        if (resultMap != null && resultMap.get("totalAnnualTransAmount") != null) {
            Object total = resultMap.get("totalAnnualTransAmount");
            if (total instanceof BigDecimal) {
                totalPrice = (BigDecimal)total;
            } else if (total instanceof Double) {
                totalPrice = BigDecimal.valueOf((Double)total);
            } else if (total instanceof Long) {
                totalPrice = BigDecimal.valueOf((Long)total);
            }
        }
        object.put("totalPrice", (Object)totalPrice);
        queryFilter.addFilter("ORG_ID_", (Object)orgId, QueryOP.EQUAL);
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizScMemberCalculate> result = ((BizScMemberCalculateDao)this.baseMapper).queryOrderByPage((IPage<BizScMemberCalculate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizScMemberCalculate>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        object.put("data", (Object)new PageList(result));
        return object;
    }

    @Override
    public boolean synScMemberCalculate(com.alibaba.fastjson.JSONObject json) {
        try {
            String userInfo;
            com.alibaba.fastjson.JSONObject jsonObject;
            String code;
            String token = this.getToken();
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            tokenMap.put("Authorization", token);
            if (json.getString("startTime") == null || json.getString("startTime").isEmpty()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -3);
                String defaultStartTime = sdf.format(calendar.getTime());
                json.put("startTime", (Object)defaultStartTime);
            }
            if ("0".equals(code = (jsonObject = JSON.parseObject((String)(userInfo = HttpUtils.post(this.synScMemberCalculateUrl, (Map<String, Object>)json, tokenMap, "application/json", 3000, 3000, "UTF-8")))).getString("code"))) {
                List categories = JSON.parseArray((String)jsonObject.getJSONObject("data").getJSONArray("records").toJSONString(), BizScMemberCalculate.class);
                List enterprises = this.bizEnterpriseManager.list();
                if (enterprises != null && enterprises.size() > 0) {
                    Map<String, String> orgMap = enterprises.stream().collect(Collectors.groupingBy(BizEnterprise::getCompanyCode, Collectors.collectingAndThen(Collectors.mapping(BizEnterprise::getOrgId, Collectors.toList()), list -> (String)list.get(0))));
                    categories.forEach(category -> {
                        String orgId = (String)orgMap.get(category.getOrgCode());
                        if (StringUtils.isNotBlank((CharSequence)orgId)) {
                            category.setOrgId(orgId);
                        }
                    });
                    super.saveOrUpdateBatch((Collection)categories);
                }
                return true;
            }
            String errorMsg = jsonObject.getString("msg");
            throw new Exception(errorMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getToken() {
        String token = "";
        String redisKey = "zfptToken";
        Object redisToken = this.redisUtil.get(redisKey);
        if (BeanUtils.isEmpty((Object)redisToken)) {
            JSONObject jsonObject;
            HashMap<String, String> getTokenMap = new HashMap<String, String>();
            String key = null;
            String tokenString = null;
            try {
                key = EncryptUtil.md5Hex((String)"cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                getTokenMap.put("key", key);
                getTokenMap.put("sysCode", "cgpt");
                tokenString = FluentUtil.post((String)this.zfptGetTokenUrl, null, getTokenMap);
            }
            catch (Exception e) {
                throw new BaseException("\u83b7\u53d6TOKEN\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (BeanUtils.isNotEmpty((Object)tokenString) && BeanUtils.isNotEmpty((Object)(jsonObject = JSONUtil.parseObj((String)tokenString)).get((Object)"value"))) {
                String tokenValue = "Bearer " + jsonObject.get((Object)"value").toString();
                this.redisUtil.set(redisKey, (Object)tokenValue, 3600L);
                token = tokenValue;
            }
        } else {
            token = redisToken.toString();
        }
        return token;
    }
}

