/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoBpmShipGroup;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoDefXml;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoEntRel;
import com.artfess.bo.persistence.dao.BoDefDao;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.bo.persistence.manager.BoEntRelManager;
import com.artfess.table.operator.ITableOperator;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service(value="boDefManager")
public class BoDefManagerImpl
extends BaseManagerImpl<BoDefDao, BoDef>
implements BoDefManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoEntRelManager bOEntRelManager;
    @Resource
    ITableOperator tableOperator;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    @Override
    @Transactional
    public void removeByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        ((BoDefDao)this.baseMapper).deleteBatchIds(idList);
        for (String defId : ids) {
            this.boAttributeManager.deleteByDefId(defId);
            this.boEntManager.remove(defId);
            this.boEntManager.deleteByDefId(defId);
            this.bOEntRelManager.removeByDefId(defId);
        }
    }

    @Override
    @Transactional
    public void update(BoDef entity) {
        this.delBodefCache(entity.getAlias());
        BoEnt mainEnt = entity.getBoEnt();
        ArrayList<BoEnt> boEnts = new ArrayList<BoEnt>();
        if (BeanUtils.isNotEmpty((Object)((Object)mainEnt)) && !mainEnt.isCreatedTable() && entity.isSupportDb()) {
            if (!mainEnt.isExternal()) {
                boEnts.add(mainEnt);
            }
            List<BoEnt> childEntList = mainEnt.getChildEntList();
            for (BoEnt boEnt2 : childEntList) {
                if (boEnt2.isExternal() || boEnt2.isCreatedTable()) continue;
                boEnts.add(boEnt2);
                List<BoEnt> sunEntList = boEnt2.getChildEntList();
                if (!BeanUtils.isNotEmpty(sunEntList)) continue;
                for (BoEnt sunEnt : sunEntList) {
                    if (sunEnt.isExternal() || sunEnt.isCreatedTable()) continue;
                    boEnts.add(sunEnt);
                }
            }
        } else if (BeanUtils.isNotEmpty((Object)((Object)mainEnt)) && entity.isSupportDb()) {
            List<BoEnt> childEntList = mainEnt.getChildEntList();
            for (BoEnt boEnt3 : childEntList) {
                List<BoEnt> sunEntList;
                if (!boEnt3.isExternal() && !boEnt3.isCreatedTable()) {
                    boEnts.add(boEnt3);
                }
                if (!BeanUtils.isNotEmpty(sunEntList = boEnt3.getChildEntList())) continue;
                for (BoEnt sunEnt : sunEntList) {
                    if (sunEnt.isExternal() || sunEnt.isCreatedTable()) continue;
                    boEnts.add(sunEnt);
                }
            }
        }
        boEnts.stream().forEach(boEnt -> boEnt.setIsCreatedTable(true));
        this.boEntManager.updateBatchById(boEnts);
        this.createTables(boEnts);
        super.updateById((Object)entity);
    }

    private void createTables(List<BoEnt> boEnts) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
        HashSet<String> createTables = new HashSet<String>();
        String createTable = "";
        try {
            if (BeanUtils.isNotEmpty(boEnts)) {
                for (int i = 0; i < boEnts.size(); ++i) {
                    BoEnt boEnt = boEnts.get(i);
                    createTable = boEnt.getTableName();
                    this.boEntManager.createTable(boEnt);
                    createTables.add(createTable);
                }
            }
            transactionManager.commit(status);
        }
        catch (Exception e) {
            PlatformTransactionManager transactionManagerCatch = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
            DefaultTransactionDefinition defCatch = new DefaultTransactionDefinition();
            defCatch.setPropagationBehavior(3);
            TransactionStatus statusCatch = transactionManagerCatch.getTransaction((TransactionDefinition)def);
            for (String tableName : createTables) {
                try {
                    this.tableOperator.dropTable(tableName);
                }
                catch (SQLException e1) {
                    throw new BaseException("\u521b\u5efa\u8868\u5931\u8d25,\u8868" + createTable + "\u5df2\u5b58\u5728", (Throwable)e1);
                }
            }
            transactionManagerCatch.commit(statusCatch);
            transactionManager.rollback(status);
            throw new BaseException("\u521b\u5efa\u8868\u5931\u8d25,\u8868" + createTable + "\u5df2\u5b58\u5728", (Throwable)e);
        }
    }

    @Override
    public BoDef getByDefId(String defId) {
        BoDef boDef = (BoDef)((Object)((BoDefDao)this.baseMapper).selectById((Serializable)((Object)defId)));
        if (BeanUtils.isNotEmpty((Object)((Object)boDef))) {
            boDef = this.getbuildBoFormCache(boDef);
        }
        return boDef;
    }

    @Override
    public BoDef getByAlias(String alias) {
        BoDef boDef = ((BoDefDao)this.baseMapper).getByAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)boDef))) {
            boDef = this.getbuildBoFormCache(boDef);
        }
        return boDef;
    }

    @Override
    public BoDef getPureByAlias(String alias) {
        BoDef boDef = ((BoDefDao)this.baseMapper).getByAlias(alias);
        return boDef;
    }

    private BoDef getbuildBoFormCache(BoDef boDef) {
        if (BeanUtils.isEmpty((Object)((Object)boDef))) {
            return null;
        }
        BoDefManager manager = (BoDefManager)AppUtil.getBean(BoDefManager.class);
        return manager.getBodefFormCache(boDef);
    }

    @Override
    @Cacheable(value={"bpm:form:boDefAlias"}, key="#boDef.alias")
    public BoDef getBodefFormCache(BoDef boDef) {
        if (BeanUtils.isEmpty((Object)((Object)boDef))) {
            return null;
        }
        HashMap<String, List<BoEnt>> refMap = new HashMap<String, List<BoEnt>>();
        HashMap<String, BoEntRel> entMap = new HashMap<String, BoEntRel>();
        List<BoEntRel> list = this.bOEntRelManager.getByDefId(boDef.getId());
        for (BoEntRel ref : list) {
            entMap.put(ref.getId(), ref);
        }
        String mainEntRefId = this.getMainEntRefId(list);
        for (BoEntRel ref : list) {
            List<BoEnt> tempList;
            BoEnt ent = ref.getRefEnt();
            if (BeanUtils.isEmpty((Object)((Object)ent))) {
                String refEntId = ref.getRefEntId();
                if (StringUtil.isEmpty((String)refEntId)) continue;
                ent = this.boEntManager.getById(refEntId);
                if (BeanUtils.isEmpty((Object)((Object)ent))) {
                    throw new BaseException(String.format("id\u4e3a\uff1a%s\u7684bo\u5b9e\u4f53\u4e0d\u5b58\u5728.", refEntId));
                }
            }
            ent.setType(ref.getType());
            if (BeanUtils.isEmpty(ent.getBoAttrList())) {
                List<BoAttribute> attrList = this.boAttributeManager.getByBoEnt(ent);
                ent.setBoAttrList(attrList);
            }
            ent.setRelation(ent.getType());
            if ("main".equals(ref.getType())) {
                ent.setShow("\u4e3b\u5b9e\u4f53");
                boDef.setBoEnt(ent);
                continue;
            }
            BoEntRel boEntRel = (BoEntRel)((Object)entMap.get(ref.getParentId()));
            if (mainEntRefId.equals(ref.getParentId())) {
                ent.setShow("\u5b50\u5b9e\u4f53");
            } else {
                ent.setShow("\u5b59\u5b9e\u4f53");
            }
            String parentId = boEntRel.getRefEntId();
            if (refMap.containsKey(parentId)) {
                tempList = (List)refMap.get(parentId);
                tempList.add(ent);
                continue;
            }
            tempList = new ArrayList();
            tempList.add(ent);
            refMap.put(parentId, tempList);
        }
        this.buildRefEnt(boDef.getBoEnt(), refMap);
        return boDef;
    }

    private String getMainEntRefId(List<BoEntRel> list) {
        for (BoEntRel boEntRel : list) {
            if (!"main".equals(boEntRel.getType())) continue;
            return boEntRel.getId();
        }
        return "";
    }

    private void buildRefEnt(BoEnt boEnt, Map<String, List<BoEnt>> refMap) {
        List<BoEnt> tempList = refMap.get(boEnt.getId());
        if (BeanUtils.isEmpty(tempList)) {
            return;
        }
        boEnt.setChildEntList(tempList);
        for (BoEnt childObj : tempList) {
            this.buildRefEnt(childObj, refMap);
        }
    }

    @Override
    public List<BoDef> parseXml(String xml) {
        try {
            BoDefXml def = (BoDefXml)JAXBUtil.unmarshall((String)xml, BoDefXml.class);
            List<BoDef> list = def.getDefList();
            return list;
        }
        catch (Exception e) {
            throw new BaseException("\u89e3\u6790xml\u6210\u4e1a\u52a1\u5bf9\u8c61\u5b9a\u4e49\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public String serialToXml(List<BoDef> boDef) {
        String xml = "";
        try {
            BoDefXml defXml = new BoDefXml();
            defXml.setDefList(boDef);
            xml = JAXBUtil.marshall((Object)defXml, BoDefXml.class);
        }
        catch (JAXBException e) {
            throw new BaseException("\u5e8f\u5217\u6362\u6210XML\u65f6\u51fa\u9519:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return xml;
    }

    @Override
    @Transactional
    public List<BoDef> importBoDef(List<BoDef> boDefs) {
        ArrayList<BoDef> rtnList = new ArrayList<BoDef>();
        for (BoDef boDef : boDefs) {
            BoDef boBoDef = this.importDef(boDef);
            rtnList.add(boBoDef);
        }
        return rtnList;
    }

    private BoDef importDef(BoDef boDef) {
        String defId = boDef.getId();
        String alias = boDef.getAlias();
        BoDef dbDef = this.getPureByAlias(alias);
        if (dbDef == null) {
            defId = UniqueIdUtil.getSuid();
            boDef.setId(defId);
            boDef.setDeployed(false);
            ObjectNode sysType = this.systemConfigFeignService.getSysTypeByType("DEF_TYPE", "default");
            if (BeanUtils.isNotEmpty((Object)sysType)) {
                boDef.setCategoryId(sysType.get("id").asText());
                boDef.setCategoryName(sysType.get("name").asText());
            }
            this.create((Model)boDef);
            ThreadMsgUtil.addMapMsg2((String)"entDefsAdded", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", boDef.getDescription() + "", boDef.getAlias() + ""));
        } else {
            defId = dbDef.getId();
            boDef.setId(defId);
            ThreadMsgUtil.addMapMsg2((String)"entDefsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", boDef.getDescription() + "", boDef.getAlias() + ""));
        }
        BoEnt boEnt = boDef.getBoEnt();
        this.importEnt(defId, boEnt, "0");
        if (BeanUtils.isEmpty((Object)((Object)dbDef))) {
            if (!boEnt.isExternal()) {
                boEnt.setIsCreatedTable(false);
                List<BoEnt> subEnts = boEnt.getChildEntList();
                if (BeanUtils.isNotEmpty(subEnts)) {
                    for (BoEnt subEnt : subEnts) {
                        List<BoEnt> sunEnts;
                        if (!subEnt.isExternal()) {
                            subEnt.setIsCreatedTable(false);
                        }
                        if (!BeanUtils.isNotEmpty(sunEnts = subEnt.getChildEntList())) continue;
                        for (BoEnt sunEnt : sunEnts) {
                            if (sunEnt.isExternal()) continue;
                            sunEnt.setIsCreatedTable(false);
                        }
                    }
                }
            }
            boDef.setDeployed(true);
            this.update(boDef);
        }
        return boDef;
    }

    private void importEnt(String defId, BoEnt ent, String parentId) {
        BoEnt dbEnt;
        String entId = ent.getId();
        if (ent.isExternal()) {
            ent.setIsCreatedTable(true);
        }
        if ((dbEnt = this.boEntManager.getByName(ent.getName())) == null) {
            entId = UniqueIdUtil.getSuid();
            ent.setId(entId);
            ent.setIsCreatedTable(false);
            ent.setStatus("enabled");
            this.boEntManager.create((Model)ent);
            List<BoAttribute> attrList = ent.getBoAttrList();
            this.saveAttr(entId, attrList, ent);
            ThreadMsgUtil.addMapMsg2((String)"entsAdded", (String)String.format("%s[%s]", ent.getComment() + "", ent.getName() + ""));
        } else {
            entId = dbEnt.getId();
            ThreadMsgUtil.addMapMsg2((String)"entsSkipped", (String)String.format("%s[%s]", ent.getComment() + "", ent.getName() + ""));
        }
        String relId = UniqueIdUtil.getSuid();
        BoEntRel dbRel = this.bOEntRelManager.getByDefIdAndEntId(defId, entId);
        if (dbRel == null) {
            this.saveBoRel(relId, defId, parentId, entId, ent.getType());
        } else {
            relId = dbRel.getId();
        }
        List<BoEnt> childEnts = ent.getChildEntList();
        if (BeanUtils.isEmpty(childEnts)) {
            return;
        }
        for (BoEnt childBaseEnt : childEnts) {
            this.importEnt(defId, childBaseEnt, relId);
        }
    }

    private void saveAttr(String entId, List<BoAttribute> attrList, BoEnt dbEnt) {
        for (BoAttribute attribute : attrList) {
            attribute.setBoEnt(dbEnt);
            attribute.setId(UniqueIdUtil.getSuid());
            attribute.setEntId(entId);
            this.boAttributeManager.create((Model)attribute);
        }
    }

    private void saveBoRel(String id, String defId, String parentId, String entId, String type) {
        BoEntRel rel = new BoEntRel();
        rel.setId(id);
        rel.setBoDefid(defId);
        rel.setParentId(parentId);
        rel.setRefEntId(entId);
        rel.setType(type);
        this.bOEntRelManager.create((Model)rel);
    }

    @Override
    @Transactional
    public void save(String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoDef boDef = (BoDef)((Object)JsonUtil.toBean((String)json, BoDef.class));
        this.delBodefCache(boDef.getAlias());
        if (StringUtil.isEmpty((String)boDef.getId())) {
            BoDef isAlias = this.getByAlias(boDef.getAlias());
            if (isAlias != null) {
                throw new BaseException("\u522b\u540d\u5df2\u5b58\u5728");
            }
            boDef.setId(UniqueIdUtil.getSuid());
            this.create((Model)boDef);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", boDef.getId());
            map.put("rev", jsonNode.get("rev").asText());
            BoDef boDef1 = ((BoDefDao)this.baseMapper).getBoDefByRev(map);
            if (BeanUtils.isNotEmpty((Object)((Object)boDef1))) {
                this.update(boDef);
                this.bOEntRelManager.removeByDefId(boDef.getId());
            } else {
                throw new BaseException("\u6b64\u5efa\u6a21\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
        }
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        if (BeanUtils.isEmpty((Object)ents)) {
            throw new BaseException("bo\u5b9a\u4e49\u4e2d\u7684\u5b9e\u4f53\u5143\u7d20(ents)\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String mainId = UniqueIdUtil.getSuid();
        this.dealEnts(boDef, ents, mainId);
    }

    @Override
    public ObjectNode getBOJson(String id) throws IOException {
        BoDef boDef = this.getByDefId(id);
        BoEnt mainBo = boDef.getBoEnt();
        Assert.notNull((Object)((Object)mainBo), (String)String.format("ID\u4e3a%s\u7684BoDef\u6240\u5bf9\u5e94\u7684BoEnt\u4e3a\u7a7a", id));
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)mainBo));
        jsonNode.put("boDefId", boDef.getId());
        jsonNode.put("boDefAlias", boDef.getAlias());
        jsonNode.put("path", boDef.getAlias());
        if (BeanUtils.isNotEmpty(mainBo.getChildEntList())) {
            List<BoEnt> childEntList = mainBo.getChildEntList();
            ArrayNode arrayEnts = JsonUtil.getMapper().createArrayNode();
            for (BoEnt boEnt : childEntList) {
                ObjectNode objNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boEnt));
                if (BeanUtils.isNotEmpty(boEnt.getChildEntList())) {
                    objNode.set("childEnts", JsonUtil.toJsonNode(boEnt.getChildEntList()));
                }
                arrayEnts.add((JsonNode)objNode);
            }
            jsonNode.set("childEnts", (JsonNode)arrayEnts);
        }
        this.handelBOJSON(jsonNode);
        jsonNode.put("nodeType", "main");
        jsonNode.put("icon", "fa fa-th-large dark");
        return jsonNode;
    }

    @Override
    public ObjectNode getBOJsonByBoDefCode(String code) throws IOException {
        BoDef boDef = this.getByAlias(code);
        BoEnt mainBo = boDef.getBoEnt();
        Assert.notNull((Object)((Object)mainBo), (String)String.format("code\u4e3a%s\u7684BoDef\u6240\u5bf9\u5e94\u7684BoEnt\u4e3a\u7a7a", code));
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)mainBo));
        jsonNode.put("boDefId", boDef.getId());
        jsonNode.put("boDefAlias", boDef.getAlias());
        jsonNode.put("path", boDef.getAlias());
        if (BeanUtils.isNotEmpty(mainBo.getChildEntList())) {
            jsonNode.set("childEnts", JsonUtil.toJsonNode(mainBo.getChildEntList()));
        }
        this.handelBOJSON(jsonNode);
        jsonNode.put("nodeType", "main");
        jsonNode.put("icon", "fa fa-th-large dark");
        return jsonNode;
    }

    @Override
    @Transactional
    public void updateCategory(BoDef boDef) {
        super.update((Model)boDef);
    }

    @Override
    @Transactional
    public String saveFormData(String json) throws Exception {
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        BoDef boDef = (BoDef)((Object)JsonUtil.toBean((String)json, BoDef.class));
        this.delBodefCache(boDef.getAlias());
        Boolean isDeployed = jsonNode.get("deployed").asBoolean();
        String defId = null;
        if (StringUtil.isEmpty((String)boDef.getId())) {
            BoDef isAlias = this.getByAlias(boDef.getAlias());
            if (isAlias != null) {
                throw new BaseException("\u5efa\u6a21\u522b\u540d\u5df2\u5b58\u5728");
            }
            boDef.setId(UniqueIdUtil.getSuid());
            defId = boDef.getId();
            this.create((Model)boDef);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", boDef.getId());
            map.put("rev", jsonNode.get("rev").asInt());
            BoDef boDef1 = ((BoDefDao)this.baseMapper).getBoDefByRev(map);
            if (BeanUtils.isNotEmpty((Object)((Object)boDef1))) {
                super.update((Model)boDef);
                this.bOEntRelManager.removeByDefId(boDef.getId());
            } else {
                throw new BaseException("\u6b64\u5efa\u6a21\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
        }
        ArrayNode ents = (ArrayNode)jsonNode.get("ents");
        if (BeanUtils.isEmpty((Object)ents)) {
            throw new BaseException("bo\u5b9a\u4e49\u4e2d\u7684\u5b9e\u4f53\u5143\u7d20(ents)\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String mainId = UniqueIdUtil.getSuid();
        this.dealEnts(boDef, ents, mainId);
        if (isDeployed.booleanValue()) {
            BoDef byDefId = this.getByDefId(defId);
            if (BeanUtils.isEmpty((Object)((Object)byDefId))) {
                String id = jsonNode.get("id").asText();
                BoDef updateBo = this.getByDefId(id);
                updateBo.setDeployed(true);
                this.update(updateBo);
            } else {
                byDefId.setDeployed(true);
                this.update(byDefId);
            }
        }
        return defId;
    }

    private void dealEnts(BoDef boDef, ArrayNode ents, String mainId) throws Exception {
        for (int i = 0; i < ents.size(); ++i) {
            JsonNode subJsonNode = ents.get(i);
            BoEnt ent = (BoEnt)((Object)JsonUtil.toBean((JsonNode)subJsonNode, BoEnt.class));
            if (BeanUtils.isNotEmpty((Object)subJsonNode.get("createdTable")) && subJsonNode.get("createdTable").asBoolean()) {
                ent.setIsCreatedTable(true);
            }
            this.boEntManager.saveEnt(ent);
            String entId = ent.getId();
            BoEntRel boEntRel = new BoEntRel();
            boEntRel.setBoDefid(boDef.getId());
            JsonNode relationNode = subJsonNode.get("relation");
            String relation = relationNode.asText();
            String sunMainId = UniqueIdUtil.getSuid();
            if ("main".equals(relation)) {
                boEntRel.setParentId("0");
                boEntRel.setId(mainId);
            } else {
                boEntRel.setId(sunMainId);
                boEntRel.setParentId(mainId);
            }
            boEntRel.setRefEntId(entId);
            boEntRel.setType(relation);
            this.bOEntRelManager.create((Model)boEntRel);
            if (!BeanUtils.isNotEmpty((Object)subJsonNode.get("children"))) continue;
            ArrayNode sunents = (ArrayNode)subJsonNode.get("children");
            this.dealEnts(boDef, sunents, sunMainId);
        }
    }

    @Override
    public Map<String, Object> getBindData(String id, String alias) throws IOException {
        List<Map<String, String>> formDifinitionData = ((BoDefDao)this.baseMapper).getFormDifinitionData(id);
        List<Map<String, String>> entData = ((BoDefDao)this.baseMapper).getEntData(id);
        List bpmDefinitionData = this.workflowFeignService.bpmDefinitionData(alias);
        Map<String, BoBpmShipGroup> shipMap = this.buildBoBpmShipGroup(bpmDefinitionData);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formData", formDifinitionData);
        map.put("bpmData", shipMap);
        map.put("bpmData", null);
        map.put("entData", entData);
        return map;
    }

    private Map<String, BoBpmShipGroup> buildBoBpmShipGroup(List<Map<String, String>> definitionData) {
        HashMap<String, BoBpmShipGroup> shipMap = new HashMap<String, BoBpmShipGroup>();
        definitionData.forEach(map -> {
            String defId = (String)map.get("def_id_");
            String name = (String)map.get("name_");
            String defKey = (String)map.get("def_key_");
            String version = (String)map.get("version_");
            String main = (String)map.get("is_main_");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)defKey), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230defKey");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)name), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u540d\u79f0");
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)version), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u7248\u672c\u53f7");
            BoBpmShipGroup shipGroup = null;
            if (!shipMap.containsKey(defKey)) {
                shipGroup = BoBpmShipGroup.build(defKey, name);
                shipMap.put(defKey, shipGroup);
            }
            shipGroup = (BoBpmShipGroup)shipMap.get(defKey);
            shipGroup.addShip(defId, version, "Y".equals(main));
        });
        return shipMap;
    }

    @Override
    public List<Map<String, String>> getBpmDefinitionData(String formKey) throws Exception {
        return this.workflowFeignService.bpmDefinitionData(formKey);
    }

    @Override
    public List getHideAttr(String tableName) throws Exception {
        List<BoEnt> boEnts = this.boEntManager.getByTableName(tableName);
        if (boEnts.size() == 0) {
            return null;
        }
        List<BoAttribute> attrList = this.boAttributeManager.getByBoEnt(boEnts.get(0));
        ArrayList<BoAttribute> list = new ArrayList<BoAttribute>();
        for (int i = 0; i < attrList.size(); ++i) {
            if (!"hide".equals(attrList.get(i).getStatus())) continue;
            list.add(attrList.get(i));
        }
        return list.size() > 0 ? list : null;
    }

    @Override
    public ObjectNode getBoDefDetails(String id) throws Exception {
        BoDef boDef = this.getByDefId(id);
        BoEnt ent = boDef.getBoEnt();
        ObjectNode boDefNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boDef));
        ObjectNode entNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)ent));
        ArrayNode node = JsonUtil.getMapper().createArrayNode();
        node.add((JsonNode)entNode);
        if (ent.getChildEntList() != null && ent.getChildEntList().size() > 0) {
            for (BoEnt boent : ent.getChildEntList()) {
                ObjectNode no = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boent));
                if (BeanUtils.isNotEmpty(boent.getChildEntList())) {
                    no.set("children", (JsonNode)((ArrayNode)JsonUtil.toJsonNode(boent.getChildEntList())));
                }
                node.add((JsonNode)no);
            }
        }
        boDefNode.set("ents", (JsonNode)node);
        return boDefNode;
    }

    @Override
    public ObjectNode getBoTreeData(String ids) throws Exception {
        if (StringUtil.isNotEmpty((String)ids)) {
            ids = ids.replace("=", "");
        }
        String[] idsArr = ids.split(",");
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        for (String id : idsArr) {
            ObjectNode boJson = this.getBOJson(id);
            if (boJson.hasNonNull("children")) {
                ArrayNode main = (ArrayNode)boJson.get("children");
                Iterator iterator = main.iterator();
                while (iterator.hasNext()) {
                    JsonNode jsonNode = (JsonNode)iterator.next();
                    if (jsonNode.hasNonNull("children")) {
                        ArrayNode subTab = (ArrayNode)jsonNode.get("children");
                        Iterator subIterator = subTab.iterator();
                        while (subIterator.hasNext()) {
                            JsonNode subNode = (JsonNode)subIterator.next();
                            if (!subNode.hasNonNull("name") || !"form_data_rev_".equals(subNode.get("name").asText())) continue;
                            subIterator.remove();
                        }
                        continue;
                    }
                    if ((!jsonNode.hasNonNull("name") || !"form_data_rev_".equals(jsonNode.get("name").asText())) && (!jsonNode.hasNonNull("status") || !"hide".equals(jsonNode.get("status").asText()))) continue;
                    iterator.remove();
                }
            }
            arrayNode.add((JsonNode)boJson);
        }
        ObjectNode bos = (ObjectNode)JsonUtil.toJsonNode((String)"{\"id\":\"0\",\"parentId\":\"-1\",\"desc\":\"BO\u5bf9\u8c61\u5c5e\u6027\"}");
        bos.set("children", (JsonNode)arrayNode);
        return bos;
    }

    private void handelBOJSON(ObjectNode boJson) {
        ArrayNode children = JsonUtil.getMapper().createArrayNode();
        ArrayNode attrList = (ArrayNode)boJson.get("attributeList");
        for (int i = 0; i < attrList.size(); ++i) {
            ObjectNode attr = (ObjectNode)attrList.get(i);
            attr.put("nodeType", "field");
            attr.set("entId", boJson.get("id"));
            attr.set("boDefId", boJson.get("boDefId"));
            attr.set("path", boJson.get("path"));
            String dataType = attr.get("dataType").asText();
            if ("number".equals(dataType)) {
                attr.put("icon", "ico_int green");
                continue;
            }
            if ("datetime".equals(dataType)) {
                attr.put("icon", "ico_date green");
                continue;
            }
            attr.put("icon", "ico_string dark");
        }
        children.addAll(attrList);
        boJson.remove("attributeList");
        ArrayNode childEntList = (ArrayNode)boJson.get("childEnts");
        if (BeanUtils.isNotEmpty((Object)childEntList)) {
            for (int i = 0; i < childEntList.size(); ++i) {
                ObjectNode subTable = (ObjectNode)childEntList.get(i);
                subTable.put("nodeType", "sub");
                subTable.put("icon", "ico_complex blue");
                subTable.put("path", boJson.get("path").asText() + ".sub_" + subTable.get("name").asText());
                this.handelBOJSON(subTable);
            }
            attrList.addAll(childEntList);
        }
        boJson.remove("childEnts");
        boJson.set("children", (JsonNode)attrList);
    }

    @Transactional
    public boolean removeById(Serializable id) {
        Assert.notNull((Object)id, (String)"\u5220\u9664\u6570\u636e\u65f6\u4f20\u5165\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        this.boEntManager.deleteByDefId(id.toString());
        this.bOEntRelManager.removeByDefId(id.toString());
        return super.removeById(id);
    }

    @Override
    @Transactional
    public int removeByAlias(String alias) {
        return ((BoDefDao)this.baseMapper).removeByAlias(alias);
    }

    @Override
    public List<BoDef> getByFormKey(String formKey) {
        return ((BoDefDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public List<BoDef> getByFormId(String formId) {
        ArrayList<BoDef> buildList = new ArrayList<BoDef>();
        List<BoDef> list = ((BoDefDao)this.baseMapper).getByFormId(formId);
        if (BeanUtils.isNotEmpty(list)) {
            for (BoDef boDef : list) {
                buildList.add(this.getbuildBoFormCache(boDef));
            }
        }
        return buildList;
    }

    @Override
    public List<String> getFormIdByBoDefIds(List<String> boDefIds) {
        return ((BoDefDao)this.baseMapper).getFormIdByBoDefIds(boDefIds);
    }

    @Override
    public void deleteExternalEnt(String entString) throws Exception {
        ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((String)entString);
        String defId = jsonNode.get("id").asText();
        this.boEntManager.removeById((Serializable)((Object)defId));
        this.boAttributeManager.removeByEntId(defId);
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("REF_ENT_ID_", defId);
        this.bOEntRelManager.removeByMap(query);
        JsonNode childEntList = jsonNode.get("children");
        for (JsonNode boEntn : childEntList) {
            ObjectNode boEnt = (ObjectNode)boEntn;
            String id = boEnt.get("id").asText();
            this.boEntManager.removeById((Serializable)((Object)id));
            this.boAttributeManager.removeByEntId(id);
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("REF_ENT_ID_", id);
            this.bOEntRelManager.removeByMap(querys);
        }
    }

    @Override
    @CacheEvict(value={"bpm:form:boDefAlias"}, key="#alias")
    public void delBodefFromCache(String alias) {
    }

    public void delBodefCache(String alias) {
        BoDefManager manager = (BoDefManager)AppUtil.getBean(BoDefManager.class);
        manager.delBodefFromCache(alias);
    }
}

