/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.conf.TeijianConfig;
import com.artfess.base.exception.SystemException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.model.Group;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.dao.PropertiesDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.dao.UserParamsDao;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.exception.HotentHttpStatus;
import com.artfess.uc.exception.NotFoundException;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.BizUserExtendManager;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OperateLogManager;
import com.artfess.uc.manager.OrgAuthManager;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgParamsManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.PropertiesService;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.TenantAuthManager;
import com.artfess.uc.manager.UserGroupManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserParamsManager;
import com.artfess.uc.manager.UserRelManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.manager.UserUniteManager;
import com.artfess.uc.model.BizUserExtend;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgParams;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.Params;
import com.artfess.uc.model.Properties;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.UcBaseModel;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserGroup;
import com.artfess.uc.model.UserParams;
import com.artfess.uc.model.UserRel;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.params.common.DataSyncObject;
import com.artfess.uc.params.common.DataSyncVo;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.common.UserExportObject;
import com.artfess.uc.params.echarts.ChartLink;
import com.artfess.uc.params.echarts.ChartNode;
import com.artfess.uc.params.echarts.ChartOption;
import com.artfess.uc.params.group.GroupIdentity;
import com.artfess.uc.params.params.ParamObject;
import com.artfess.uc.params.user.TriggerVo;
import com.artfess.uc.params.user.UserMarkObject;
import com.artfess.uc.params.user.UserPolymer;
import com.artfess.uc.params.user.UserPolymerOrgPos;
import com.artfess.uc.params.user.UserPolymerRole;
import com.artfess.uc.params.user.UserPwdObject;
import com.artfess.uc.params.user.UserRelObject;
import com.artfess.uc.params.user.UserStatusVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.OrgUtil;
import com.artfess.uc.util.UserPhotoFileFindVisitor;
import com.artfess.uc.vo.OrgUserVO;
import com.artfess.uc.vo.YhOrgVo;
import com.artfess.uc.vo.YhUserVo;
import com.artfess.uc.vo.zsUserVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserManagerImpl
extends BaseManagerImpl<UserDao, User>
implements UserManager {
    protected static Logger logger = LoggerFactory.getLogger(UserManagerImpl.class);
    protected static String IMPORT_NEW_SUFFIX = "_imp";
    @Autowired
    ResourceLoader resourceLoader;
    @Value(value="${system.attachment.path:''}")
    private String attachPath;
    @Autowired
    UserRoleManager userRoleManager;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    UserParamsDao userParamsDao;
    @Autowired
    OrgManager orgService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    OrgPostManager orgPostManager;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    PropertiesService propertiesService;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    UserParamsManager userParamsService;
    @Autowired
    UserGroupManager userGroupService;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    ParamsManager paramsService;
    @Autowired
    UserRelManager userRelService;
    @Autowired
    OrgManager orgManager;
    @Autowired
    DemensionManager demensionManager;
    @Autowired
    OrgJobManager orgJobManager;
    @Autowired
    RoleManager roleManager;
    @Autowired
    OperateLogManager operateLogService;
    @Autowired
    PropertiesDao propertiesDao;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    SystemConfigFeignService portalFeignService;
    @Autowired
    JwtTokenHandler jwtTokenHandler;
    @Autowired
    UserDetailsService userDetailsService;
    @Autowired
    PwdStrategyManager pwdStrategyManager;
    @Autowired
    OrgParamsManager orgParamsService;
    @Autowired
    UserUniteManager userUniteManager;
    @Autowired
    private TeijianConfig teijianConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BizUserExtendManager userExtendManager;

    @Override
    @Transactional
    public User addUser(UserVo user) throws Exception {
        if (StringUtil.isEmpty((String)user.getAccount())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getFullname())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u540d\u79f0\u3010fullname\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getPassword())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u767b\u5f55\u5bc6\u7801\u3010password\u3011\u5fc5\u586b\uff01");
        }
        if (((UserDao)this.baseMapper).getCountByAccount(user.getAccount()) > 0) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5e10\u53f7\u3010" + user.getAccount() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        User u = this.getByNumber(user.getUserNumber());
        if (BeanUtils.isNotEmpty((Object)u)) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5de5\u53f7\u3010" + user.getUserNumber() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (StringUtil.isNotEmpty((String)user.getMobile()) && BeanUtils.isNotEmpty((Object)(u = this.getByMobile(user.getMobile())))) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u624b\u673a\u53f7\u3010" + user.getMobile() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (!this.checkEmail(user.getEmail()) && !StringUtil.isEmpty((String)user.getEmail())) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        User newUser = UserVo.parser(user);
        newUser.setStatus(1);
        if (BeanUtils.isEmpty((Object)user.getId())) {
            newUser.setId(UniqueIdUtil.getSuid());
        } else {
            if (this.getUserById(user.getId()).getState().booleanValue()) {
                throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\u3010" + user.getId() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            newUser.setId(user.getId());
        }
        newUser.setCreateTime(LocalDateTime.now());
        newUser.setFrom("restful");
        String password = user.getPassword();
        if (StringUtil.isEmpty((String)user.getPassword())) {
            password = this.pwdStrategyManager.getDefault().getInitPwd();
        }
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)password));
        newUser.setPwdCreateTime(LocalDateTime.now());
        Integer status = BeanUtils.isNotEmpty((Object)user.getStatus()) ? user.getStatus() : 1;
        if (status != 1 && status != -1 && status != -2 && status != 0 && status != 3 && status != 4) {
            status = 1;
        }
        newUser.setStatus(status);
        newUser.setLockedStatus(1);
        try {
            this.create((Model)newUser);
            Role role = this.roleManager.getByAlias("ybry");
            String roleId = "1";
            if (BeanUtils.isNotEmpty((Object)role)) {
                roleId = role.getId();
            }
            UserRole userRole = new UserRole();
            userRole.setId(UniqueIdUtil.getSuid());
            userRole.setRoleId(roleId);
            userRole.setUserId(newUser.getId());
            this.userRoleManager.save(userRole);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return newUser;
    }

    @Override
    @Transactional
    public void updateUser(UserVo user) throws Exception {
        if (StringUtil.isEmpty((String)user.getAccount())) {
            throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        User u = this.getByAccount(user.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u6839\u636e\u3010" + user.getAccount() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        if (StringUtil.isNotEmpty((String)user.getUserNumber())) {
            if (!user.getUserNumber().equals(u.getUserNumber()) && BeanUtils.isEmpty((Object)this.getByNumber(user.getUserNumber()))) {
                u.setUserNumber(user.getUserNumber());
            } else if (!user.getUserNumber().equals(u.getUserNumber()) && BeanUtils.isNotEmpty((Object)this.getByNumber(user.getUserNumber()))) {
                throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u5de5\u53f7\u3010" + user.getUserNumber() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
        }
        if (StringUtil.isNotEmpty((String)user.getBirthday())) {
            u.setBirthday(DateFormatUtil.dateParse((String)user.getBirthday(), (String)"yyyy-MM-dd"));
        } else {
            u.setBirthday(null);
        }
        if (StringUtil.isNotEmpty((String)user.getEntryDate())) {
            u.setEntryDate(DateFormatUtil.dateParse((String)user.getEntryDate(), (String)"yyyy-MM-dd"));
        } else {
            u.setEntryDate(null);
        }
        u.setAddress(user.getAddress());
        if (StringUtil.isNotEmpty((String)user.getEmail())) {
            u.setEmail(user.getEmail().toLowerCase());
        } else {
            u.setEmail(user.getEmail());
        }
        u.setPhoto(user.getPhoto());
        u.setFullname(user.getFullname());
        u.setSex(user.getSex());
        u.setMobile(user.getMobile());
        u.setStatus(user.getStatus());
        u.setIdCard(user.getIdCard());
        u.setPhone(user.getPhone());
        u.setPhoto(user.getPhoto());
        u.setEducation(user.getEducation());
        u.setLeaveDate(user.getLeaveDate());
        u.setUserType(user.getUserType());
        this.update((Model)u);
        if (ObjectUtils.isNotEmpty((Object)((Object)user.getUserExtend()))) {
            BizUserExtend userExtend = user.getUserExtend();
            if (StringUtil.isEmpty((String)userExtend.getId())) {
                userExtend.setUserId(u.getId());
                this.userExtendManager.save((Object)userExtend);
            } else {
                this.userExtendManager.updateById((Object)userExtend);
            }
        }
    }

    @Override
    public void updateUserIP() throws Exception {
        String account = AuthenticationUtil.getCurrentUsername();
        User u = this.getByAccount(account);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = IPUtils.getIpAddr((HttpServletRequest)request);
        u.setIP(ip);
        this.update((Model)u);
    }

    @Override
    public void updateUserSkin(String skin) throws Exception {
        String account = AuthenticationUtil.getCurrentUsername();
        User u = this.getByAccount(account);
        u.setSkin(skin);
        this.update((Model)u);
    }

    @Override
    @Transactional
    public CommonResult<String> deleteUser(UserMarkObject userMark) {
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        if (StringUtil.isNotEmpty((String)userMark.getAccount())) {
            String[] accounts;
            for (String account : accounts = userMark.getAccount().split(",")) {
                User user = ((UserDao)this.baseMapper).getByAccount(account);
                if (BeanUtils.isNotEmpty((Object)user)) {
                    if (OrgUtil.checkUserGruopIsUserRel("user", user.getId())) {
                        msg.append("\u5e10\u53f7\u3010" + account + "\u3011\u7684\u7528\u6237\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                        continue;
                    }
                    this.remove((Serializable)((Object)user.getId()));
                    isTrue = true;
                    continue;
                }
                msg.append("\u5e10\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff0c");
            }
        } else if (StringUtil.isNotEmpty((String)userMark.getUserNumber())) {
            String[] numbers;
            for (String number : numbers = userMark.getUserNumber().split(",")) {
                User user = ((UserDao)this.baseMapper).getByNumber(number);
                if (BeanUtils.isNotEmpty((Object)user)) {
                    if (OrgUtil.checkUserGruopIsUserRel("user", user.getId())) {
                        msg.append("\u5de5\u53f7\u3010" + number + "\u3011\u7684\u7528\u6237\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                        continue;
                    }
                    this.remove((Serializable)((Object)user.getId()));
                    isTrue = true;
                    continue;
                }
                msg.append("\u5de5\u53f7\u3010" + number + "\u3011\u4e0d\u5b58\u5728\uff0c");
            }
        }
        if (StringUtil.isEmpty((String)userMark.getAccount()) && StringUtil.isEmpty((String)userMark.getUserNumber())) {
            isTrue = false;
            msg.append("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        return new CommonResult(isTrue, BeanUtils.isEmpty((Object)msg) ? "\u5220\u9664\u7528\u6237\u6210\u529f\uff01" : msg.toString(), (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteUserByIds(String ids) {
        String[] idArray = ids.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            User user = (User)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)user)) {
                if (user.isAdmin()) {
                    throw new RuntimeException("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u80fd\u5220\u9664!");
                }
                this.orgUserService.delByUserId(id);
                this.remove((Serializable)((Object)user.getId()));
                TenantAuthManager tenantAuthManager = (TenantAuthManager)AppUtil.getBean(TenantAuthManager.class);
                tenantAuthManager.delByUserId(user.getUserId());
                continue;
            }
            isTrue = false;
            msg.append("\u5e10\u53f7\u3010" + id + "\u3011\u4e0d\u5b58\u5728\uff0c");
        }
        return new CommonResult(isTrue, BeanUtils.isEmpty((Object)msg) ? "\u5220\u9664\u7528\u6237\u6210\u529f\uff01" : msg.toString(), (Object)"");
    }

    @Override
    public UserVo getUser(String json) throws Exception {
        User user = this.getUserByJson(json);
        if (BeanUtils.isEmpty((Object)user)) {
            return null;
        }
        UserVo userVo = OrgUtil.convertToUserVo(user);
        List<UserParams> params = this.getUserParams(user.getAccount());
        if (BeanUtils.isNotEmpty(params)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (UserParams param : params) {
                map.put(param.getAlias(), param.getValue());
            }
            userVo.setParams(map);
        }
        return userVo;
    }

    @Override
    public User getByAccount(String account) {
        return ((UserDao)this.baseMapper).getByAccount(account);
    }

    public User getByMobile(String mobile) {
        return ((UserDao)this.baseMapper).getByMobile(mobile);
    }

    @Override
    public List<User> queryOrgUser(QueryFilter queryFilter) {
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty(params.get("orgId"))) {
            queryFilter.addFilter("org.ID_", params.get("orgId"), QueryOP.EQUAL);
        }
        return ((UserDao)this.baseMapper).queryOrgUser((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<User> getUserListByOrgId(String orgId) {
        return ((UserDao)this.baseMapper).getUserListByOrgId(orgId);
    }

    @Override
    public List queryOrgUserRel(QueryFilter queryFilter) {
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        return ((UserDao)this.baseMapper).queryOrgUserRel((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<User> getListByPostCode(String postCode) {
        return ((UserDao)this.baseMapper).getListByPostCode(postCode);
    }

    @Override
    public List<User> getListByPostId(String postId) {
        return ((UserDao)this.baseMapper).getListByPostId(postId);
    }

    @Override
    public List<User> getUserListByRoleId(String roleId) {
        return ((UserDao)this.baseMapper).getUserListByRoleId(roleId);
    }

    @Override
    public List<User> getUserListByRoleCode(String roleCode) {
        return ((UserDao)this.baseMapper).getUserListByRoleCode(roleCode);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        User user = ((UserDao)this.baseMapper).getByAccount("admin");
        for (String id : ids) {
            if (!id.equals(user.getUserId())) continue;
            ThreadMsgUtil.addMsg((String)(ids.length >= 2 ? "admin\u5e10\u53f7\u4e0d\u80fd\u5220\u9664,\u5176\u5b83\u7528\u6237\u5220\u9664\u6210\u529f\u3002" : "admin\u5e10\u53f7\u4e0d\u80fd\u5220\u9664"));
            break;
        }
        if (StringUtil.isEmpty((String)ThreadMsgUtil.getMessage((boolean)false))) {
            ThreadMsgUtil.addMsg((String)"\u7528\u6237\u5220\u9664\u6210\u529f\u3002");
        }
        super.removeByIds(ids);
        UserManagerImpl bean = (UserManagerImpl)AppUtil.getBean(this.getClass());
        for (String id : ids) {
            this.orgUserManager.removeByUserId(id, LocalDateTime.now());
            this.userRoleManager.removeByUserId(id, LocalDateTime.now());
            this.userParamsDao.removeByUserId(id, LocalDateTime.now());
            bean.delUserMenuCache(id);
        }
    }

    @CacheEvict(value={"bpm:sys:userMenu:new"}, key="#userId")
    protected void delUserMenuCache(String userId) {
    }

    @Override
    public List<User> getByUserEmail(String email) {
        return ((UserDao)this.baseMapper).getByUserEmail(email);
    }

    public Org dealOrg(Org org, List<Org> orgList, String preCode, Map<String, String> orgMap) {
        Org rtn = null;
        if (BeanUtils.isEmpty(orgList)) {
            if (BeanUtils.isNotEmpty((Object)orgMap.get(org.getCode()))) {
                org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
            }
            orgList.add(org);
            orgMap.put(org.getCode(), org.getId());
            rtn = org;
        } else {
            Boolean flag = true;
            for (int i = 0; i < orgList.size(); ++i) {
                Org systemOrg;
                if (orgList.get(i).getPathName().equals(org.getPathName())) {
                    flag = false;
                    rtn = orgList.get(i);
                }
                if (orgList.get(i).getName().equals(org.getName()) && orgList.get(i) != org) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + (i + 1));
                }
                if (BeanUtils.isNotEmpty((Object)(systemOrg = this.orgService.getByCode(org.getCode())))) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + (i + 1) + (i + 1));
                }
                if (i != orgList.size() - 1 || !flag.booleanValue()) continue;
                if (BeanUtils.isNotEmpty((Object)orgMap.get(org.getCode()))) {
                    org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
                }
                orgList.add(org);
                orgMap.put(org.getCode(), org.getId());
                rtn = org;
            }
        }
        return rtn;
    }

    public Org dealOrgUnder(String supperPathName, String underPathName, List<Org> orgList, String demId, String preCode, Map<String, String> orgMap) {
        String underName = underPathName.substring(underPathName.lastIndexOf("/") + 1);
        List<Org> chirList = this.orgService.getByPathName(underPathName);
        if (BeanUtils.isNotEmpty(chirList)) {
            for (Org org : chirList) {
                if (!demId.equals(org.getDemId())) continue;
                return org;
            }
        }
        List<Org> pList = this.orgService.getByPathName(supperPathName);
        ArrayList<Org> parentList = new ArrayList<Org>();
        for (Org org : pList) {
            if (!demId.equals(org.getDemId())) continue;
            parentList.add(org);
        }
        Org chird = new Org();
        if (BeanUtils.isEmpty(parentList)) {
            for (int i = 0; i < orgList.size(); ++i) {
                if (!orgList.get(i).getPathName().equals(supperPathName)) continue;
                chird.setId(UniqueIdUtil.getSuid());
                chird.setParentId(orgList.get(i).getId());
                chird.setDemId(demId);
                chird.setName(underName);
                chird.setPathName(underPathName);
                chird.setPath(orgList.get(i).getPath() + chird.getId() + ".");
                chird.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName));
            }
        } else {
            chird.setId(UniqueIdUtil.getSuid());
            chird.setParentId(((Org)parentList.get(0)).getId());
            chird.setDemId(demId);
            chird.setName(underName);
            chird.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName));
            chird.setPathName(underPathName);
            chird.setPath(((Org)parentList.get(0)).getPath() + chird.getId() + ".");
        }
        return this.dealOrg(chird, orgList, preCode, orgMap);
    }

    public List<OrgJob> dealOrgJob(String reldefNameStr, List<OrgJob> orgJobList, String preCode) {
        if (StringUtil.isEmpty((String)reldefNameStr)) {
            return null;
        }
        String[] reldefNames = reldefNameStr.split(";");
        ArrayList<OrgJob> rtn = new ArrayList<OrgJob>();
        for (String reldefName : reldefNames) {
            OrgJob reldef = null;
            List<OrgJob> selectList = this.orgJobService.getByName(reldefName);
            if (BeanUtils.isNotEmpty(selectList)) {
                reldef = selectList.get(0);
            } else {
                Boolean flag = true;
                reldef = new OrgJob();
                reldef.setId(UniqueIdUtil.getSuid());
                reldef.setCode(PinyinUtil.getPinYinHeadChar((String)reldefName));
                reldef.setName(reldefName);
                OrgJob sysOrgJob = this.orgJobService.getByCode(reldef.getCode());
                if (BeanUtils.isNotEmpty((Object)sysOrgJob)) {
                    reldef.setCode(reldef.getCode() + reldef.getId());
                }
                if (BeanUtils.isEmpty(orgJobList)) {
                    orgJobList.add(reldef);
                } else {
                    for (int i = 0; i < orgJobList.size(); ++i) {
                        if (orgJobList.get(i).getName().equals(reldefName)) {
                            flag = false;
                            reldef = orgJobList.get(i);
                        }
                        if (i != orgJobList.size() - 1 || !flag.booleanValue()) continue;
                        orgJobList.add(reldef);
                    }
                }
            }
            if (!BeanUtils.isNotEmpty((Object)reldef)) continue;
            rtn.add(reldef);
        }
        return rtn;
    }

    public User dealUser(User user, List<User> userList) throws Exception {
        User rtn = new User();
        if (StringUtil.isNotEmpty((String)user.getId())) {
            rtn = user;
        } else {
            Boolean flag = true;
            if (BeanUtils.isEmpty(userList)) {
                user.setId(UniqueIdUtil.getSuid());
                rtn = user;
                userList.add(user);
            } else {
                for (int i = 0; i < userList.size(); ++i) {
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) != user) {
                        logger.error("Excel\u8868\u683c\u4e2d\u7528\u6237\u5e10\u53f7\u91cd\u590d\uff1a" + userList.get(i).getAccount());
                    }
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) == user) {
                        flag = false;
                        rtn = userList.get(i);
                    }
                    if (i != userList.size() - 1 || !flag.booleanValue()) continue;
                    user.setId(UniqueIdUtil.getSuid());
                    rtn = user;
                    userList.add(user);
                }
            }
        }
        return rtn;
    }

    public void dealUserOrgPost(User user, Org org, List<OrgPost> orgPosts, List<OrgUser> orgUserList, List<OrgPost> orgPostList, Map<String, String> orgPostAddMap, String isMaster, String isCharge, Map<String, String> isMasterMap, String demId) {
        if (BeanUtils.isEmpty((Object)org)) {
            return;
        }
        if (BeanUtils.isNotEmpty(orgPosts)) {
            for (OrgPost orgPost : orgPosts) {
                OrgUser orgUser = new OrgUser();
                if (StringUtil.isNotEmpty((String)orgPostAddMap.get(orgPost.getId()))) {
                    Boolean flag = true;
                    if (BeanUtils.isEmpty(orgPostList)) {
                        orgPost.setCode(org.getCode() + "_" + orgPost.getCode());
                        orgPostList.add(orgPost);
                    } else {
                        for (int i = 0; i < orgPostList.size(); ++i) {
                            if (orgPostList.get(i).getOrgId().equals(orgPost.getOrgId()) && orgPostList.get(i).getName().equals(orgPost.getName())) {
                                orgPost = orgPostList.get(i);
                                flag = false;
                            }
                            if (!flag.booleanValue() || i != orgPostList.size() - 1) continue;
                            orgPost.setCode(org.getCode() + "_" + orgPost.getCode());
                            orgPostList.add(orgPost);
                        }
                    }
                }
                QueryFilter filter = QueryFilter.build();
                filter.addFilter("orgId", (Object)orgPost.getOrgId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("relId", (Object)orgPost.getId(), QueryOP.EQUAL, FieldRelation.AND);
                PageList pageList = this.orgUserService.query(filter);
                if (!BeanUtils.isEmpty((Object)pageList.getRows())) continue;
                orgUser.setId(UniqueIdUtil.getSuid());
                orgUser.setOrgId(orgPost.getOrgId());
                orgUser.setRelId(orgPost.getId());
                orgUser.setUserId(user.getId());
                this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
                orgUserList.add(orgUser);
            }
        } else {
            OrgUser orgUser = new OrgUser();
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
            PageList pageList = this.orgUserService.query(filter);
            if (BeanUtils.isEmpty((Object)pageList.getRows())) {
                orgUser.setId(UniqueIdUtil.getSuid());
                orgUser.setOrgId(org.getId());
                orgUser.setUserId(user.getId());
                this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
                orgUserList.add(orgUser);
            }
        }
    }

    private void dealMasterAndCharge(String isMaster, String isCharge, OrgUser orgUser, Map<String, String> isMasterMap, String demId) {
        if (StringUtil.isNotEmpty((String)isMaster) && (isMaster.equals("1") || isMaster.equals("\u662f")) && this.hasMaster(orgUser.getUserId(), orgUser.getOrgId(), demId) && StringUtil.isEmpty((String)isMasterMap.get(orgUser.getUserId() + "_" + demId))) {
            orgUser.setIsMaster(1);
            isMasterMap.put(orgUser.getUserId() + "_" + demId, "1");
        } else {
            orgUser.setIsMaster(0);
        }
        if (StringUtil.isNotEmpty((String)isCharge)) {
            if (isCharge.equals("1")) {
                orgUser.setIsCharge(1);
            } else if (isCharge.equals("2") && BeanUtils.isEmpty((Object)this.orgUserManager.getChargesByOrgId(orgUser.getOrgId(), 2))) {
                orgUser.setIsCharge(2);
            }
        } else {
            orgUser.setIsCharge(0);
        }
    }

    private boolean hasMaster(String userId, String orgId, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgUser> orgUsers = this.orgUserManager.getByParms(map);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            for (OrgUser orgUser : orgUsers) {
                Org org;
                if (orgUser.getOrgId().equals(orgId) || orgUser.getIsMaster() != 1 || !BeanUtils.isNotEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId())))) || !org.getDemId().equals(demId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<User> getUpUsersByUserId(String underUserId) {
        return ((UserDao)this.baseMapper).getUpUsersByUserId(underUserId);
    }

    @Override
    public User getUpUserByUserIdAndOrgId(String account, String orgCode) {
        User u = this.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        Org o = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        return ((UserDao)this.baseMapper).getUpUserByUserIdAndOrgId(u.getId(), o.getId());
    }

    @Override
    public List<User> getUnderUsersByUserId(String upUserId) {
        return ((UserDao)this.baseMapper).getUnderUsersByUserId(upUserId);
    }

    @Override
    public List<User> getUnderUserByUserIdAndOrgId(String account, String orgCode) {
        User u = this.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        Org o = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("upUserId", u.getId());
        map.put("orgId", o.getId());
        return ((UserDao)this.baseMapper).getUnderUserByUserIdAndOrgId(u.getId(), o.getId());
    }

    @Override
    public List<User> getListByJobId(String jobId) {
        ArrayList<User> list = new ArrayList<User>();
        List<OrgPost> orgPost = this.orgPostManager.getByReldefId(jobId);
        if (BeanUtils.isEmpty(orgPost)) {
            return list;
        }
        for (OrgPost rel : orgPost) {
            List<User> positionUser = this.getListByPostId(rel.getId());
            if (!BeanUtils.isNotEmpty(positionUser)) continue;
            list.addAll(positionUser);
        }
        BeanUtils.removeDuplicate(list);
        return list;
    }

    @Override
    public User getByNumber(String userNumber) {
        return ((UserDao)this.baseMapper).getByNumber(userNumber);
    }

    @Override
    @Transactional
    @CacheEvict(value={"bpm:uc:userAccount"}, allEntries=true)
    public CommonResult<String> changUserPsd(UserPwdObject userPwdObject) throws Exception {
        if (StringUtil.isEmpty((String)userPwdObject.getAccount()) && StringUtil.isEmpty((String)userPwdObject.getUserNumber())) {
            throw new RuntimeException("\u5e10\u53f7\u548c\u5de5\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        User user = this.getUserByObject(userPwdObject);
        String oldPwd = userPwdObject.getOldPwd();
        String newPwd = userPwdObject.getNewPwd();
        if (user.getStatus() != 1) {
            String stateStr = user.getStatus() == 0 || user.getStatus() == -1 ? (user.getStatus() == 0 ? "\u5df2\u88ab\u7981\u7528" : "\u672a\u6fc0\u6d3b") : "\u5df2\u88ab\u79bb\u804c";
            return new CommonResult(false, "\u7528\u6237" + stateStr + "\uff0c\u4e0d\u80fd\u4fee\u6539\u5bc6\u7801\uff01", (Object)"");
        }
        if (StringUtil.isEmpty((String)oldPwd)) {
            return new CommonResult(false, "\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (StringUtil.isEmpty((String)newPwd)) {
            return new CommonResult(false, "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (newPwd.equals(oldPwd)) {
            return new CommonResult(false, "\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u4e00\u6837\uff01", (Object)"");
        }
        PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
        if (BeanUtils.isNotEmpty((Object)((Object)pwdStrategy))) {
            short pwdRule = pwdStrategy.getPwdRule();
            short pwdLength = pwdStrategy.getPwdLength();
            short enable = pwdStrategy.getEnable();
            if (enable == 1) {
                String regex;
                boolean result;
                if (newPwd.length() < pwdLength) {
                    return new CommonResult(false, "\u65b0\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + pwdLength, (Object)"");
                }
                if (pwdRule == 2) {
                    String regex2 = "^(?![a-zA-z]+$)(?!\\d+$)(?![!@#$%^&*]+$)[a-zA-Z\\d!@#$%^&*]+$";
                    boolean result2 = newPwd.matches(regex2);
                    if (!result2) {
                        return new CommonResult(false, "\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\uff01", (Object)"");
                    }
                } else if (pwdRule == 3) {
                    String regex3 = "^(?=.*?[A-Za-z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$";
                    boolean result3 = newPwd.matches(regex3);
                    if (!result3) {
                        return new CommonResult(false, "\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\uff01", (Object)"");
                    }
                } else if (pwdRule == 4 && !(result = newPwd.matches(regex = "^(?=.*?[a-z])(?=.*?[A-Z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$"))) {
                    return new CommonResult(false, "\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5927\u5c0f\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\uff01", (Object)"");
                }
            }
        }
        String oldPswdEncrypt = this.passwordEncoder.encode((CharSequence)oldPwd);
        if (user.getPassword().equals(oldPswdEncrypt)) {
            user.setPassword(this.passwordEncoder.encode((CharSequence)newPwd));
            user.setPwdCreateTime(LocalDateTime.now());
            this.update((Model)user);
            return new CommonResult(true, "\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u66f4\u65b0\u5bc6\u7801\u5931\u8d25\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateUserPsw(UserPwdObject userPwdObject) throws Exception {
        List<User> users;
        if (StringUtil.isEmpty((String)userPwdObject.getAccount()) && StringUtil.isEmpty((String)userPwdObject.getUserNumber())) {
            return new CommonResult(false, "\u5e10\u53f7\u548c\u5de5\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (BeanUtils.isEmpty((Object)userPwdObject) || StringUtil.isEmpty((String)userPwdObject.getNewPwd())) {
            return new CommonResult(false, "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (userPwdObject.getNewPwd().trim().length() < 6) {
            return new CommonResult(false, "\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e6\u4f4d\uff01", (Object)"");
        }
        String userMarks = userPwdObject.getAccount();
        int type = 1;
        if (StringUtil.isEmpty((String)userMarks) && StringUtil.isNotEmpty((String)userPwdObject.getUserNumber())) {
            userMarks = userPwdObject.getUserNumber();
            type = 2;
        }
        if (BeanUtils.isNotEmpty(users = this.getUserByType(userMarks, type))) {
            for (User user : users) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)userPwdObject.getNewPwd()));
                user.setPwdCreateTime(LocalDateTime.now());
                this.update((Model)user);
            }
            return new CommonResult(true, "\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u672a\u66f4\u65b0\u4efb\u4f55\u7528\u6237\u7684\u5bc6\u7801\uff08\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237\uff09\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateOneselfPsw(UserPwdObject userPwdObject) throws Exception {
        return new CommonResult(true, "\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01", (Object)"");
    }

    private User getUserByJson(String json) throws IOException {
        ObjectNode markJson = (ObjectNode)JsonUtil.toJsonNode((String)json);
        if (BeanUtils.isEmpty((Object)markJson)) {
            throw new RequiredException("\u7528\u6237ID\u3001\u7528\u6237\u5e10\u53f7\u3001\u7528\u6237\u5de5\u53f7\u5fc5\u586b\u5176\u4e2d\u4e00\u4e2a\uff01");
        }
        UserMarkObject userMark = (UserMarkObject)JsonUtil.toBean((JsonNode)markJson, UserMarkObject.class);
        return this.getUserByObject(userMark);
    }

    private PageList<UserVo> convertRestPageList(PageList<User> pageList) {
        PageList voPageList = new PageList();
        voPageList.setPage(pageList.getPage());
        voPageList.setPageSize(pageList.getPageSize());
        voPageList.setTotal(pageList.getTotal());
        voPageList.setRows(OrgUtil.convertToUserVoList(pageList.getRows()));
        return voPageList;
    }

    private User getUserByObject(Object obj) throws IOException {
        User user = null;
        if (BeanUtils.isNotEmpty((Object)obj)) {
            String key = "";
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode((Object)obj);
            if (json.findValue("account") != null && StringUtil.isNotEmpty((String)json.get("account").asText())) {
                user = this.getByAccount(json.get("account").asText());
                key = json.get("account").asText();
            } else if (json.findValue("userNumber") != null && StringUtil.isNotEmpty((String)json.get("userNumber").asText())) {
                user = this.getByNumber(json.get("userNumber").asText());
                key = json.get("userNumber").asText();
            } else if (json.findValue("userId") != null && StringUtil.isNotEmpty((String)json.get("userId").asText())) {
                user = (User)this.get((Serializable)((Object)json.get("userId").asText()));
                key = json.get("userId").asText();
            }
            if (BeanUtils.isEmpty(user)) {
                return null;
            }
        }
        return user;
    }

    private List<User> getUserByType(String userMarks, int type) {
        ArrayList<User> list;
        block3: {
            String[] strArray;
            block5: {
                block4: {
                    list = new ArrayList<User>();
                    if (!StringUtil.isNotEmpty((String)userMarks)) break block3;
                    strArray = userMarks.split(",");
                    if (type != 1) break block4;
                    for (String str : strArray) {
                        User user = this.getByAccount(str);
                        if (!BeanUtils.isNotEmpty((Object)user)) continue;
                        list.add(user);
                    }
                    break block3;
                }
                if (type != 2) break block5;
                for (String str : strArray) {
                    User user = this.getByNumber(str);
                    if (!BeanUtils.isNotEmpty((Object)user)) continue;
                    list.add(user);
                }
                break block3;
            }
            if (type != 3) break block3;
            for (String str : strArray) {
                User user = (User)this.get((Serializable)((Object)str));
                if (!BeanUtils.isNotEmpty((Object)user)) continue;
                list.add(user);
            }
        }
        return list;
    }

    private String getUserId(String value, int type) {
        String userId = "";
        User user = null;
        if (type == 1) {
            user = this.getByAccount(value);
        } else if (type == 2) {
            user = this.getByNumber(value);
        }
        if (BeanUtils.isNotEmpty((Object)user)) {
            userId = user.getId();
        }
        return userId;
    }

    private String getDemId(UserRelObject userRelObject) {
        String demId = "";
        if (StringUtil.isNotEmpty((String)userRelObject.getDemCode())) {
            Demension demension = this.demensionService.getByCode(userRelObject.getDemCode());
            if (BeanUtils.isNotEmpty((Object)demension)) {
                demId = demension.getId();
            } else {
                throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + userRelObject.getDemCode() + "\u3011\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff01");
            }
        }
        return demId;
    }

    private List<User> getChargesByOrgId(String orgId, Boolean isMain) {
        ArrayList<User> list = new ArrayList<User>();
        List<OrgPost> orgPost = this.orgPostService.getRelCharge(orgId, true);
        if (BeanUtils.isNotEmpty(orgPost)) {
            List<User> users = ((UserDao)this.baseMapper).getListByPostId(orgPost.get(0).getId());
            list.addAll(users);
        } else {
            List<OrgUser> orgUsers = this.orgUserService.getChargesByOrgId(orgId, isMain);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                for (OrgUser orgUser : orgUsers) {
                    User user = (User)this.get((Serializable)((Object)orgUser.getUserId()));
                    list.add(user);
                }
            }
        }
        return list;
    }

    private List<Org> getUserOrgs(UserRelObject userRelObject) throws IOException {
        if (StringUtil.isEmpty((String)userRelObject.getAccount()) && StringUtil.isEmpty((String)userRelObject.getUserNumber())) {
            throw new RuntimeException("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        ArrayList<Org> orgs = new ArrayList();
        User user = this.getUserByObject(userRelObject);
        String demId = this.getDemId(userRelObject);
        if (StringUtil.isNotEmpty((String)demId)) {
            Org org = this.orgService.getMainGroup(user.getId(), demId);
            if (BeanUtils.isNotEmpty((Object)org)) {
                orgs.add(org);
            }
        } else {
            orgs = this.orgService.getMainOrgListByUser(user.getId(), null);
        }
        return orgs;
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserParams(String account, List<ParamObject> params) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException("\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            StringBuilder pcodes = new StringBuilder();
            User user = this.getByAccount(account);
            boolean isTrue = false;
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
            }
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            if (BeanUtils.isNotEmpty(params)) {
                for (ParamObject paramObject : params) {
                    Params param = this.paramsService.getByAlias(paramObject.getAlias());
                    if (BeanUtils.isNotEmpty((Object)param) && "1".equals(param.getType())) {
                        list.add((ObjectNode)JsonUtil.toJsonNode((String)paramObject.toString()));
                        isTrue = true;
                        continue;
                    }
                    pcodes.append(paramObject.getAlias() + "\uff0c");
                }
            }
            if (BeanUtils.isNotEmpty(list)) {
                this.userParamsService.saveParams(user.getId(), list);
                return new CommonResult(true, isTrue && StringUtil.isEmpty((String)pcodes.toString()) ? "\u4fdd\u5b58\u6210\u529f" : "\u90e8\u5206\u4fdd\u5b58\u6210\u529f\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01", (Object)"");
            }
            throw new RuntimeException("\u672a\u4fdd\u5b58\u4efb\u4f55\u53c2\u6570\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.indexOf("ORA-12899") > -1) {
                msg = "\u53c2\u6570\u503c\u8fc7\u957f";
            }
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c" + msg);
        }
    }

    @Override
    public List<UserParams> getUserParams(String account) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException("\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userId = this.getUserId(account, 1);
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return this.userParamsService.getByUserId(userId);
    }

    @Override
    public UserParams getParamByCode(String account, String code) throws Exception {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)code)) {
            throw new RuntimeException("\u5e10\u53f7\u548c\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userId = this.getUserId(account, 1);
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return this.userParamsService.getByUserIdAndAlias(userId, code);
    }

    @Override
    public CommonResult<Org> getMainOrgByDemCode(UserRelObject userRelObject) throws Exception {
        User user = this.getUserByObject(userRelObject);
        String demCode = userRelObject.getDemCode();
        if (StringUtil.isEmpty((String)demCode)) {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u7ef4\u5ea6\u7f16\u7801\uff01", null);
        }
        Demension demension = this.demensionService.getByCode(demCode);
        if (BeanUtils.isEmpty((Object)demension)) {
            return new CommonResult(false, "\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u3010" + demCode + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\uff01", null);
        }
        Org org = this.orgService.getMainGroup(user.getUserId(), demension.getId());
        boolean isTrue = BeanUtils.isNotEmpty((Object)org);
        String msg = isTrue ? "\u6210\u529f\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff01" : "\u7528\u6237\u5728\u3010" + demension.getDemName() + "\u3011\u7ef4\u5ea6\u4e0b\u672a\u8bbe\u7f6e\u4e3b\u7ec4\u7ec7\uff01";
        return new CommonResult(isTrue, msg, (Object)org);
    }

    @Override
    public List<OrgPost> getUserPosts(UserRelObject userRelObject) throws Exception {
        List<OrgPost> list;
        User user = this.getUserByObject(userRelObject);
        String demId = "";
        if (StringUtil.isNotEmpty((String)userRelObject.getDemCode())) {
            Demension demension = this.demensionService.getByCode(userRelObject.getDemCode());
            if (BeanUtils.isNotEmpty((Object)demension)) {
                demId = demension.getId();
            } else {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
            }
        }
        if (BeanUtils.isNotEmpty(list = this.orgPostService.getListByUserId(user.getId(), demId)) && BeanUtils.isNotEmpty((Object)userRelObject.getIsMain()) && userRelObject.getIsMain().booleanValue()) {
            ArrayList<OrgPost> list2 = new ArrayList<OrgPost>();
            list2.addAll(list);
            for (OrgPost orgPost : list2) {
                if (!BeanUtils.isNotEmpty((Object)orgPost.getIsCharge()) || 1 == orgPost.getIsCharge()) continue;
                list.remove(orgPost);
            }
        }
        return list;
    }

    @Override
    public Set<GroupIdentity> getImmeSuperior(UserRelObject userRelObject) throws Exception {
        HashSet<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<Org> orgs = this.getUserOrgs(userRelObject);
        for (Org org : orgs) {
            String orgId = org.getParentId();
            if (!StringUtil.isNotEmpty((String)orgId)) continue;
            identitys.addAll(OrgUtil.convertToGroupIdentity(this.getChargesByOrgId(orgId, !BeanUtils.isEmpty((Object)userRelObject.getIsMain()) && userRelObject.getIsMain() != false)));
        }
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getImmeUnders(UserRelObject userRelObject) throws Exception {
        HashSet<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<Org> orgs = this.getUserOrgs(userRelObject);
        QueryFilter queryFilter = QueryFilter.build();
        StringBuilder orgIds = new StringBuilder();
        boolean isFirst = true;
        for (Org org : orgs) {
            if (isFirst) {
                isFirst = false;
            } else {
                orgIds.append(",");
            }
            orgIds.append(org.getId());
        }
        if (StringUtil.isEmpty((String)orgIds.toString())) {
            return identitys;
        }
        queryFilter.addFilter("parentId", (Object)orgIds.toString(), QueryOP.IN, FieldRelation.AND);
        List chirldOrgs = this.orgService.query(queryFilter).getRows();
        for (Org org : chirldOrgs) {
            identitys.addAll(OrgUtil.convertToGroupIdentity(this.getUserListByOrgId(org.getId())));
        }
        return identitys;
    }

    @Override
    public List<OrgJob> getUserJobs(String json) throws Exception {
        User user = this.getUserByJson(json);
        return this.orgJobService.getListByUserId(user.getId());
    }

    @Override
    public List<UserGroup> getUserGroups(String json) throws Exception {
        User user = this.getUserByJson(json);
        return this.userGroupService.getByUserId(user.getUserId());
    }

    @Override
    public List<UserVo> getNewUsersFromAD(String dateStr) throws Exception {
        if (StringUtil.isEmpty((String)dateStr)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1adate\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("from", (Object)"AD", QueryOP.EQUAL, FieldRelation.AND);
        if (StringUtil.isNotEmpty((String)dateStr)) {
            dateStr = dateStr.trim().length() == 10 ? dateStr + " 00:00:00" : dateStr;
            LocalDateTime date = DateFormatUtil.parse((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
            queryFilter.addFilter("createTime", (Object)date, QueryOP.GREAT_EQUAL, FieldRelation.AND);
        }
        List list = this.query(queryFilter).getRows();
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public Set<GroupIdentity> getByRoleCodeAndOrgCode(String roleCode, String orgCode) throws Exception {
        Role role = this.roleService.getByAlias(roleCode);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + roleCode + "\u3011\u7684\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        Set<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<User> users = ((UserDao)this.baseMapper).getByOrgCodeAndroleCode(orgCode, roleCode);
        if (BeanUtils.isNotEmpty(users)) {
            identitys = OrgUtil.convertToGroupIdentity(users);
        }
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getByJobCodeAndOrgCode(String jobCode, String orgCode) throws Exception {
        OrgJob job = this.orgJobService.getByCode(jobCode);
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + jobCode + "\u3011\u7684\u804c\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        HashSet<GroupIdentity> identitys = new HashSet();
        List<User> users = ((UserDao)this.baseMapper).getByJobCodeAndOrgCode(orgCode, jobCode);
        identitys = OrgUtil.convertToGroupIdentity(users);
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getByPostCodeAndOrgCode(String postCode, String orgCode) throws Exception {
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + postCode + "\u3011\u7684\u5c97\u4f4d\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        Set<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<OrgUser> orgUsers = this.orgUserManager.getByPostCodeAndOrgCode(orgCode, postCode);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            ArrayList<User> list = new ArrayList<User>();
            for (OrgUser orgUser : orgUsers) {
                User user = (User)this.get((Serializable)((Object)orgUser.getUserId()));
                if (!BeanUtils.isNotEmpty((Object)user)) continue;
                list.add(user);
            }
            identitys = OrgUtil.convertToGroupIdentity(list);
        }
        return identitys;
    }

    @Override
    public List<UserVo> getUpUsersByUser(String account) throws Exception {
        String userId = this.getUserId(account, 1);
        if (BeanUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return OrgUtil.convertToUserVoList(this.getUpUsersByUserId(userId));
    }

    @Override
    public UserVo getUpUserByUserAndOrg(String account, String orgCode) throws Exception {
        return OrgUtil.convertToUserVo(this.getUpUserByUserIdAndOrgId(account, orgCode));
    }

    @Override
    public List<UserVo> getUnderUsersByUser(String account) throws Exception {
        String userId = this.getUserId(account, 1);
        if (BeanUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return OrgUtil.convertToUserVoList(this.getUnderUsersByUserId(userId));
    }

    @Override
    public List<UserVo> getUnderUserByUserAndOrg(String account, String orgCode) throws Exception {
        return OrgUtil.convertToUserVoList(this.getUnderUserByUserIdAndOrgId(account, orgCode));
    }

    @Override
    public List<User> getOrgUsers(String orgId, Boolean isMain) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)isMain)) {
            if (isMain.booleanValue()) {
                params.put("isMain", "1");
            } else {
                params.put("isMain", "0");
            }
        }
        params.put("orgId", orgId);
        return ((UserDao)this.baseMapper).getOrgUsers(params);
    }

    @Override
    @Transactional
    public void updatePhoto(String account, String photo) throws Exception {
        User user = ((UserDao)this.baseMapper).getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        user.setPhoto(photo);
        this.update((Model)user);
    }

    @Override
    public CommonResult<String> forbiddenUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, 0);
    }

    @Override
    public CommonResult<String> activateUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, 1);
    }

    @Override
    public CommonResult<String> leaveUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, -2);
    }

    @Override
    @Transactional
    public CommonResult<String> lockUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserLockStatus(userMark, 2);
    }

    @Override
    @Transactional
    public CommonResult<String> unLockUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserLockStatus(userMark, 1);
    }

    @Transactional
    private CommonResult<String> toDealUserState(UserMarkObject userMark, int state) throws SQLException {
        String successMsg;
        String dmsg;
        User user;
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        if (StringUtil.isNotEmpty((String)userMark.getAccount())) {
            String[] accounts;
            for (String account : accounts = userMark.getAccount().split(",")) {
                user = ((UserDao)this.baseMapper).getByAccount(account);
                if (BeanUtils.isNotEmpty((Object)user) && user.getStatus() != state) {
                    this.dealUserState(user, state);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (state == 1 || state == 0 ? (state == 1 ? "\u5df2\u6fc0\u6d3b" : "\u5df2\u88ab\u7981\u7528") : "\u5df2\u88ab\u79bb\u804c");
                msg.append("\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011" + dmsg + "\uff0c");
            }
        }
        if (StringUtil.isNotEmpty((String)userMark.getUserNumber())) {
            String[] numbers;
            for (String number : numbers = userMark.getUserNumber().split(",")) {
                user = ((UserDao)this.baseMapper).getByNumber(number);
                if (BeanUtils.isNotEmpty((Object)user) && user.getStatus() != state) {
                    this.dealUserState(user, state);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (state == 1 || state == 0 ? (state == 1 ? "\u5df2\u6fc0\u6d3b" : "\u5df2\u88ab\u7981\u7528") : "\u5df2\u88ab\u79bb\u804c");
                msg.append("\u7528\u6237\u5de5\u53f7\u3010" + number + "\u3011" + dmsg + "\uff0c");
            }
        }
        String string = state == 1 || state == 0 ? (state == 1 ? "\u6fc0\u6d3b\u7528\u6237\u6210\u529f\uff01" : "\u7528\u6237\u7981\u7528\u6210\u529f") : (successMsg = "\u79bb\u804c\u7528\u6237\u6210\u529f");
        if (StringUtil.isEmpty((String)userMark.getAccount()) && StringUtil.isEmpty((String)userMark.getUserNumber())) {
            isTrue = false;
            msg.append("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        return new CommonResult(isTrue, BeanUtils.isNotEmpty((Object)msg) ? msg.toString() : successMsg, (Object)"");
    }

    @Transactional
    private CommonResult<String> toDealUserLockStatus(UserMarkObject userMark, Integer lockStatus) throws SQLException {
        String successMsg;
        String dmsg;
        User user;
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        if (StringUtil.isNotEmpty((String)userMark.getAccount())) {
            String[] accounts;
            for (String account : accounts = userMark.getAccount().split(",")) {
                user = ((UserDao)this.baseMapper).getByAccount(account);
                if (BeanUtils.isNotEmpty((Object)user) && user.getLockedStatus() != lockStatus) {
                    user.setLockedStatus(lockStatus);
                    if (lockStatus == 1) {
                        user.setLockedTime(null);
                    } else {
                        user.setLockedTime(LocalDateTime.now());
                    }
                    this.update((Model)user);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (lockStatus == 1 ? "\u5df2\u6b63\u5e38" : (lockStatus == 2 ? "\u5df2\u88ab\u9501\u5b9a" : ""));
                msg.append("\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011" + dmsg + "\uff0c");
            }
        }
        if (StringUtil.isNotEmpty((String)userMark.getUserNumber())) {
            String[] numbers;
            for (String number : numbers = userMark.getUserNumber().split(",")) {
                user = ((UserDao)this.baseMapper).getByNumber(number);
                if (BeanUtils.isNotEmpty((Object)user) && user.getLockedStatus() != lockStatus) {
                    user.setLockedStatus(lockStatus);
                    if (lockStatus == 1) {
                        user.setLockedTime(null);
                    } else {
                        user.setLockedTime(LocalDateTime.now());
                    }
                    this.update((Model)user);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (lockStatus == 1 ? "\u5df2\u6b63\u5e38" : (lockStatus == 2 ? "\u5df2\u88ab\u9501\u5b9a" : ""));
                msg.append("\u7528\u6237\u5de5\u53f7\u3010" + number + "\u3011" + dmsg + "\uff0c");
            }
        }
        String string = lockStatus == 1 ? "\u89e3\u9501\u6210\u529f\uff01" : (successMsg = lockStatus == 2 ? "\u9501\u5b9a\u7528\u6237\u6210\u529f!" : "");
        if (StringUtil.isEmpty((String)userMark.getAccount()) && StringUtil.isEmpty((String)userMark.getUserNumber())) {
            isTrue = false;
            msg.append("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        return new CommonResult(isTrue, BeanUtils.isNotEmpty((Object)msg) ? msg.toString() : successMsg, (Object)"");
    }

    @Override
    public List<UserVo> getUserByPost(String postCode) {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1apostCode\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ID_", (Object)postCode, QueryOP.IN, FieldRelation.OR);
        queryFilter.addFilter("CODE_", (Object)postCode, QueryOP.IN, FieldRelation.OR);
        PageList query = this.orgPostManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
            return new ArrayList<UserVo>();
        }
        ArrayList<String> postCodes = new ArrayList<String>();
        for (OrgPost orgPost : query.getRows()) {
            postCodes.add(orgPost.getCode());
        }
        return OrgUtil.convertToUserVoList(((UserDao)this.baseMapper).getUserByPosts(postCodes));
    }

    @Override
    @Transactional
    public String exportUsers(boolean isOrg, boolean isRole, boolean isAll, QueryFilter queryFilter) throws Exception {
        String zipPath;
        String fileName;
        boolean isOtherAll = isAll && BeanUtils.isEmpty((Object)queryFilter.getQuerys());
        List userList = new ArrayList();
        if (isAll) {
            queryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            userList = this.queryNoPage(queryFilter);
        } else {
            PageList query = this.query(queryFilter);
            userList = query.getRows();
        }
        String zipFilePath = "";
        if (BeanUtils.isNotEmpty(userList)) {
            Field[] baseFields = UserDao.class.getDeclaredFields();
            fileName = "htuc_user_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
            zipPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + fileName).replace("/", File.separator);
            String excelPath = zipPath + File.separator;
            this.exportExcel(baseFields, userList, "\u7528\u6237\u5217\u8868", "user", excelPath);
            if (isOrg || isRole) {
                ArrayList<String> userIds = new ArrayList<String>();
                if (!isOtherAll) {
                    for (User user : userList) {
                        userIds.add(user.getId());
                    }
                }
                if (isOrg) {
                    this.exportOrg(userIds, baseFields, excelPath, fileName, isOtherAll);
                }
                if (isRole) {
                    this.exportRoles(userIds, baseFields, excelPath, isOtherAll);
                }
            }
        } else {
            throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        ZipUtil.zip((String)zipPath, (Boolean)true);
        zipFilePath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/").replace("/", File.separator) + fileName;
        return zipFilePath;
    }

    @Transactional
    private void dealUserState(User user, Integer status) throws SQLException {
        if (BeanUtils.isNotEmpty((Object)user)) {
            user.setStatus(status);
            this.update((Model)user);
        }
    }

    @Transactional
    private void exportOrg(List<String> userIds, Field[] baseFields, String excelPath, String fileName, boolean isOtherAll) throws Exception {
        QueryFilter orgUserQueryFilter = QueryFilter.build();
        if (!isOtherAll) {
            orgUserQueryFilter.addFilter("userId", userIds, QueryOP.IN, FieldRelation.AND);
        }
        orgUserQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List orgUsers = this.orgUserManager.queryNoPage(orgUserQueryFilter);
        if (BeanUtils.isNotEmpty((Object)orgUsers)) {
            this.exportExcel(baseFields, orgUsers, "\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u5217\u8868", "orgUser", excelPath);
            ArrayList<String> orgIds = new ArrayList<String>();
            ArrayList<String> postIds = new ArrayList<String>();
            for (int i = 0; i < orgUsers.size(); ++i) {
                orgIds.add(((OrgUser)orgUsers.get(i)).getOrgId());
                if (!StringUtil.isNotEmpty((String)((OrgUser)orgUsers.get(i)).getRelId())) continue;
                postIds.add(((OrgUser)orgUsers.get(i)).getRelId());
            }
            QueryFilter orgQueryFilter = QueryFilter.build();
            BeanUtils.removeDuplicate(orgIds);
            orgQueryFilter.addFilter("id", orgIds, QueryOP.IN, FieldRelation.AND);
            orgQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List orgs = this.orgManager.queryNoPage(orgQueryFilter);
            if (BeanUtils.isNotEmpty((Object)orgs)) {
                this.exportExcel(baseFields, orgs, "\u7ec4\u7ec7\u5217\u8868", "org", excelPath);
                ArrayList<String> demIds = new ArrayList<String>();
                for (Org org : orgs) {
                    demIds.add(org.getDemId());
                }
                this.exportDemension(baseFields, excelPath, demIds);
            }
            if (BeanUtils.isNotEmpty(postIds)) {
                this.exportJobAndPost(baseFields, excelPath, postIds);
            }
        }
    }

    @Transactional
    private void exportDemension(Field[] baseFields, String excelPath, List<String> demIds) throws Exception {
        BeanUtils.removeDuplicate(demIds);
        QueryFilter demQueryFilter = QueryFilter.build();
        demQueryFilter.addFilter("id", demIds, QueryOP.IN, FieldRelation.AND);
        demQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List dems = this.demensionManager.queryNoPage(demQueryFilter);
        if (BeanUtils.isNotEmpty((Object)dems)) {
            this.exportExcel(baseFields, dems, "\u7ef4\u5ea6\u5217\u8868", "demension", excelPath);
        }
    }

    @Transactional
    private void exportJobAndPost(Field[] baseFields, String excelPath, List<String> postIds) throws Exception {
        BeanUtils.removeDuplicate(postIds);
        QueryFilter postQueryFilter = QueryFilter.build();
        postQueryFilter.addFilter("id", postIds, QueryOP.IN, FieldRelation.AND);
        postQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List orgPosts = this.orgPostManager.queryNoPage(postQueryFilter);
        if (BeanUtils.isNotEmpty((Object)orgPosts)) {
            this.exportExcel(baseFields, orgPosts, "\u5c97\u4f4d\u5217\u8868", "post", excelPath);
            ArrayList<String> jobIds = new ArrayList<String>();
            for (OrgPost orgPost : orgPosts) {
                if (!StringUtil.isNotEmpty((String)orgPost.getRelDefId())) continue;
                jobIds.add(orgPost.getRelDefId());
            }
            QueryFilter jobQueryFilter = QueryFilter.build();
            jobQueryFilter.addFilter("id", jobIds, QueryOP.IN, FieldRelation.AND);
            jobQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List orgJobs = this.orgJobManager.queryNoPage(jobQueryFilter);
            if (BeanUtils.isNotEmpty((Object)orgJobs)) {
                this.exportExcel(baseFields, orgJobs, "\u804c\u52a1\u5217\u8868", "job", excelPath);
            }
        }
    }

    @Transactional
    private void exportRoles(List<String> userIds, Field[] baseFields, String excelPath, boolean isOtherAll) throws Exception {
        BeanUtils.removeDuplicate(userIds);
        QueryFilter userRoleQueryFilter = QueryFilter.build();
        if (!isOtherAll) {
            userRoleQueryFilter.addFilter("userId", userIds, QueryOP.IN, FieldRelation.AND);
        }
        userRoleQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List userRoles = this.userRoleManager.queryNoPage(userRoleQueryFilter);
        if (BeanUtils.isNotEmpty((Object)userRoles)) {
            this.exportExcel(baseFields, userRoles, "\u7528\u6237\u89d2\u8272\u5173\u7cfb\u5217\u8868", "userRole", excelPath);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRole userRole : userRoles) {
                roleIds.add(userRole.getRoleId());
            }
            QueryFilter roleQueryFilter = QueryFilter.build();
            roleQueryFilter.addFilter("id", roleIds, QueryOP.IN, FieldRelation.AND);
            roleQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List roles = this.roleManager.queryNoPage(roleQueryFilter);
            if (BeanUtils.isNotEmpty((Object)roles)) {
                this.exportExcel(baseFields, roles, "\u89d2\u8272\u5217\u8868", "role", excelPath);
            }
        }
    }

    private <E> void exportExcel(Field[] baseFields, List<E> list, String sheetName, String excelName, String excelPath) throws Exception {
        Field[] fields;
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        for (Field field : fields = list.get(0).getClass().getDeclaredFields()) {
            if (field.getModifiers() != 4) continue;
            exportMaps.put(field.getName(), field.getName());
        }
        for (Field field : baseFields) {
            if (field.getModifiers() != 4) continue;
            exportMaps.put(field.getName(), field.getName());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)sheetName, (int)24, exportMaps, list);
        ExcelUtil.saveExcel((HSSFWorkbook)book, (String)excelName, (String)excelPath);
    }

    @Override
    public List<User> getUserByTime(UserExportObject userExport) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(userExport.getBtime(), userExport.getEtime());
        StringBuilder sql = new StringBuilder();
        if (StringUtil.isNotEmpty((String)userExport.getJobCodes())) {
            sql.append(" and ID_ in( select aa.USER_ID_ from uc_org_user aa where aa.is_dele_ = '0' and aa.pos_id_ in (select bb.ID_ from uc_org_post bb where bb.is_dele_='0' and bb.job_id_ in (select cc.id_ from uc_org_job cc where cc.is_dele_='0'  and cc.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getJobCodes(), ","));
            sql.append(" ))) ");
        }
        if (StringUtil.isNotEmpty((String)userExport.getPostCodes())) {
            sql.append(" and ID_ in( select dd.USER_ID_ FROM uc_org_user dd where dd.is_dele_='0' and dd.pos_id_ in( select ee.ID_ from uc_org_post ee where ee.is_dele_='0' and ee.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getPostCodes(), ","));
            sql.append(" )) ");
        } else if (StringUtil.isNotEmpty((String)userExport.getOrgCodes())) {
            sql.append(" and ID_ in( select ff.USER_ID_ FROM uc_org_user ff where ff.is_dele_='0' and ff.org_id_ in( select gg.ID_ from uc_org gg where gg.is_dele_='0' and gg.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getOrgCodes(), ","));
            sql.append(" )) ");
        } else if (StringUtil.isNotEmpty((String)userExport.getDemCodes())) {
            sql.append(" and ID_ in( select hh.user_id_ FROM uc_org_user hh where hh.is_dele_='0' and hh.org_id_ in( select ii.ID_ from uc_org ii where ii.is_dele_='0' and ii.dem_id_ in(select jj.ID_ from uc_demension jj where jj.is_dele_='0' and jj.code_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getDemCodes(), ","));
            sql.append(" ))) ");
        }
        if (BeanUtils.isNotEmpty((Object)sql)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dimSql", sql.toString());
            queryFilter.setParams(params);
        }
        return ((UserDao)this.baseMapper).queryByDim((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<UserParams> getUserParamByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.userParamsService.queryNoPage(queryFilter);
    }

    @Override
    public List<UserRole> getUserRoleByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.userRoleManager.queryNoPage(queryFilter);
    }

    @Override
    public List<User> getChargesByOrg(String orgCode, Boolean isMain) throws Exception {
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org) && BeanUtils.isEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)orgCode))))) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u6216id\u3010" + orgCode + "\u4e0d\u5b58\u5728\u3011\uff01");
        }
        List<OrgUser> orgUser = this.orgUserService.getChargesByOrgId(org.getId(), isMain);
        if (BeanUtils.isNotEmpty(orgUser)) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (OrgUser oUser : orgUser) {
                userIds.add(oUser.getUserId());
            }
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("id", userIds, QueryOP.IN, FieldRelation.AND);
            return this.query(filter).getRows();
        }
        return null;
    }

    @Override
    public DataSyncVo getSyncDataByTime(DataSyncObject dataSync) throws Exception {
        DataSyncVo dataSyncVo = new DataSyncVo();
        String btime = dataSync.getBtime();
        String etime = dataSync.getEtime();
        if (dataSync.getIsUser().booleanValue()) {
            UserExportObject userExport = new UserExportObject();
            userExport.setBtime(btime);
            userExport.setEtime(etime);
            userExport.setDemCodes(dataSync.getDemCodes());
            userExport.setOrgCodes(dataSync.getOrgCodes());
            userExport.setJobCodes(dataSync.getJobCodes());
            userExport.setPostCodes(dataSync.getPostCodes());
            dataSyncVo.setUserList(this.getUserByTime(userExport));
        }
        OrgExportObject exportObject = new OrgExportObject();
        exportObject.setBtime(btime);
        exportObject.setEtime(etime);
        exportObject.setDemCodes(dataSync.getDemCodes());
        exportObject.setOrgCodes(dataSync.getOrgCodes());
        if (dataSync.getIsDem().booleanValue()) {
            dataSyncVo.setDemList(this.demensionService.getDemByTime(exportObject));
        }
        if (dataSync.getIsOrg().booleanValue()) {
            dataSyncVo.setOrgList(this.orgService.getOrgByTime(exportObject));
        }
        if (dataSync.getIsOrgAuth().booleanValue()) {
            dataSyncVo.setOrgAuthList(this.orgAuthService.getOrgAuthByTime(exportObject));
        }
        if (dataSync.getIsJob().booleanValue()) {
            dataSyncVo.setJobList(this.orgJobService.getJobByTime(btime, etime));
        }
        if (dataSync.getIsPost().booleanValue()) {
            dataSyncVo.setPostList(this.orgService.getOrgPostByTime(exportObject));
        }
        if (dataSync.getIsOrgUser().booleanValue()) {
            dataSyncVo.setOrgUserList(this.orgService.getOrgUserByTime(exportObject));
        }
        if (dataSync.getIsUnder().booleanValue()) {
            dataSyncVo.setUnderList(this.orgService.getUserUnderByTime(exportObject));
        }
        if (dataSync.getIsOrgRole().booleanValue()) {
            dataSyncVo.setOrgRoleList(this.orgService.getOrgRoleByTime(exportObject));
        }
        if (dataSync.getIsParams().booleanValue()) {
            dataSyncVo.setParamsList(this.paramsService.getParamsByTime(btime, etime));
        }
        if (dataSync.getIsUserParams().booleanValue()) {
            dataSyncVo.setUserParamList(this.getUserParamByTime(btime, etime));
        }
        if (dataSync.getIsOrgParams().booleanValue()) {
            dataSyncVo.setOrgParamList(this.orgService.getOrgParamByTime(exportObject));
        }
        if (dataSync.getIsRole().booleanValue()) {
            dataSyncVo.setRoleList(this.roleService.getRoleByTime(btime, etime));
        }
        if (dataSync.getIsUserRole().booleanValue()) {
            dataSyncVo.setUserRoleList(this.getUserRoleByTime(btime, etime));
        }
        if (dataSync.getIsGroup().booleanValue()) {
            dataSyncVo.setGroupList(this.userGroupService.getUserGroupByTime(btime, etime));
        }
        if (dataSync.getIsUserRel().booleanValue()) {
            dataSyncVo.setUserRelList(this.userRelService.getUserRelByTime(btime, etime));
        }
        return dataSyncVo;
    }

    private void cleanPhotoFolder(String account, String exceptFile) throws IOException {
        Path path = Paths.get(this.attachPath, account);
        if (Files.notExists(path, new LinkOption[0]) || StringUtil.isEmpty((String)exceptFile)) {
            return;
        }
        UserPhotoFileFindVisitor userPhotoFileFindVisitor = new UserPhotoFileFindVisitor(exceptFile);
        Files.walkFileTree(path, userPhotoFileFindVisitor);
        for (String fileName : userPhotoFileFindVisitor.getFilenameList()) {
            Files.delete(Paths.get(fileName, new String[0]));
        }
    }

    @Override
    @Transactional
    public void saveUser(UserPolymer userPolymer) throws Exception {
        UserVo user = userPolymer.getUser();
        String account = user.getAccount();
        if (userPolymer.getAdding().booleanValue()) {
            this.addUser(user);
        } else {
            this.updateUser(user);
        }
        this.cleanPhotoFolder(account, user.getPhoto());
        List<UserPolymerRole> roles = userPolymer.getRoles();
        int roleSize = BeanUtils.isEmpty(roles) ? 0 : roles.size();
        String[] roleCodes = new String[roleSize];
        for (int i = 0; i < roleSize; ++i) {
            UserPolymerRole userPolymerRole = roles.get(i);
            roleCodes[i] = userPolymerRole.getCode();
        }
        this.userRoleService.saveUserRole(account, roleCodes);
        List<UserPolymerOrgPos> orgsPoses = userPolymer.getOrgsPoses();
        this.orgUserService.saveOrgUser(account, orgsPoses);
    }

    @Override
    @Transactional
    public CommonResult<String> saveUser(UserVo user) {
        try {
            String account = user.getAccount();
            if (StringUtil.isEmpty((String)user.getAccount())) {
                throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
            }
            User u = this.getByAccount(user.getAccount());
            if (BeanUtils.isEmpty((Object)u)) {
                throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u6839\u636e\u3010" + user.getAccount() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
            }
            if (StringUtil.isNotEmpty((String)user.getBirthday())) {
                u.setBirthday(DateFormatUtil.parse((String)user.getBirthday(), (String)"yyyy-MM-dd").toLocalDate());
            } else {
                u.setBirthday(null);
            }
            u.setAddress(user.getAddress());
            u.setEducation(user.getEducation());
            u.setSex(user.getSex());
            u.setPhoto(user.getPhoto());
            u.setIdCard(user.getIdCard());
            this.update((Model)u);
            this.cleanPhotoFolder(account, user.getPhoto());
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object)e.getMessage());
        }
        return new CommonResult(true, "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u6210\u529f", (Object)"");
    }

    @Override
    public ChartOption getUserRelCharts(String json) throws Exception {
        User user = this.getUserByJson(json);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RuntimeException("\u6839\u636e\u7528\u6237\u6807\u8bc6\u4fe1\u606f\u83b7\u53d6\u4e0d\u5230\u7528\u6237\uff01");
        }
        String currentUserName = user.getFullname();
        String text = "\u3010" + currentUserName + "\u3011\u7684\u6c47\u62a5\u5173\u7cfb\u56fe";
        String subtext = "\u6570\u636e\u6765\u81ea\u534e\u6da6\u4e09\u4e5d\u7528\u6237\u4e2d\u5fc3";
        ArrayList<String> legend = new ArrayList<String>();
        legend.add("\u7ec4\u7ec7\u9886\u5bfc");
        legend.add("\u6c47\u62a5\u7ebf");
        String seriesName = "\u6c47\u62a5\u5173\u7cfb";
        ArrayNode categories = (ArrayNode)JsonUtil.toJsonNode((String)"[{name: '\u5f53\u524d\u7528\u6237'},{name: '\u7ec4\u7ec7\u9886\u5bfc'},{name:'\u6c47\u62a5\u7ebf'}]");
        ArrayList<ChartNode> nodes = new ArrayList<ChartNode>();
        ArrayList<ChartLink> links = new ArrayList<ChartLink>();
        ChartNode root = new ChartNode("root", 0, currentUserName + "\n" + "\uff08\u5f53\u524d\u7528\u6237\uff09", "\u5f53\u524d\u4eba", currentUserName + "\n" + "\uff08\u5f53\u524d\u7528\u6237\uff09", 35);
        nodes.add(root);
        HashMap<String, ChartNode> nodeIdMap = new HashMap<String, ChartNode>();
        ChartOption option = new ChartOption(text, subtext, legend, seriesName, categories);
        this.getUserRelOptions(root, option, nodes, links, user.getAccount(), nodeIdMap);
        this.getOrgOptions(root, option, nodes, links, user.getId(), nodeIdMap);
        option.setNodes(nodes);
        option.setLinks(links);
        return option;
    }

    private void getUserRelOptions(ChartNode root, ChartOption option, List<ChartNode> nodes, List<ChartLink> links, String account, Map<String, ChartNode> nodeIdMap) throws Exception {
        List<UserRel> rels = this.userRelService.getUserRels(account, null);
        for (UserRel userRel : rels) {
            if (userRel.getParentId().equals(userRel.getTypeId())) continue;
            ArrayList<ChartNode> relNodes = new ArrayList<ChartNode>();
            ArrayList<ChartLink> relLinks = new ArrayList<ChartLink>();
            UserRel pRel = (UserRel)this.userRelService.get((Serializable)((Object)userRel.getParentId()));
            if (!BeanUtils.isNotEmpty((Object)pRel) || pRel.getStatus() != 1) continue;
            ObjectNode proType = this.portalFeignService.getSysTypeById(pRel.getTypeId());
            String typeName = BeanUtils.isEmpty((Object)proType) ? "\u672a\u627e\u5230\uff01" : proType.get("name").asText();
            this.getSupRel(root, userRel, pRel, relNodes, relLinks, true, nodeIdMap, typeName);
            if (BeanUtils.isNotEmpty(relNodes)) {
                nodes.addAll(relNodes);
            }
            if (!BeanUtils.isNotEmpty(relLinks)) continue;
            links.addAll(relLinks);
        }
    }

    private void getSupRel(ChartNode root, UserRel nowRel, UserRel pRel, List<ChartNode> relNodes, List<ChartLink> relLinks, boolean isFirst, Map<String, ChartNode> nodeIdMap, String typeName) throws Exception {
        if (BeanUtils.isNotEmpty((Object)pRel)) {
            ChartNode node = nodeIdMap.get(pRel.getId());
            if (BeanUtils.isEmpty((Object)node)) {
                String label = this.getRelLabel(pRel);
                node = new ChartNode(pRel.getId(), 2, label, "\u6240\u5c5e\u6c47\u62a5\u7ebf\u3010" + typeName + "\u3011", label, 30);
                nodeIdMap.put(pRel.getId(), node);
                relNodes.add(node);
            }
            ChartLink link = new ChartLink("\u6c47\u62a5\u7ebf", isFirst ? root.getId() : nowRel.getId(), pRel.getId(), isFirst ? 5 : 3);
            relLinks.add(link);
            UserRel ppRel = (UserRel)this.userRelService.get((Serializable)((Object)pRel.getParentId()));
            if (BeanUtils.isNotEmpty((Object)ppRel) && ppRel.getStatus() == 1) {
                this.getSupRel(root, pRel, ppRel, relNodes, relLinks, false, nodeIdMap, typeName);
            }
        }
    }

    private String getRelLabel(UserRel rel) throws Exception {
        StringBuilder sbd = new StringBuilder();
        List<User> users = this.userRelService.getUsersByRel(rel.getAlias());
        sbd.append(rel.getName());
        sbd.append("\n");
        sbd.append("\uff08");
        switch (rel.getGroupType()) {
            case "user": {
                sbd.append("\u7528\u6237");
                break;
            }
            case "org": {
                sbd.append("\u7ec4\u7ec7");
                break;
            }
            case "pos": {
                sbd.append("\u5c97\u4f4d");
                break;
            }
            case "role": {
                sbd.append("\u89d2\u8272");
                break;
            }
            case "group": {
                sbd.append("\u7fa4\u7ec4");
            }
        }
        if (!"user".equals(rel.getGroupType())) {
            sbd.append("\u3010");
            sbd.append(BeanUtils.isNotEmpty(users) ? this.getUserNames(users) : "\u672a\u627e\u5230\u7528\u6237");
            sbd.append("\u3011");
        }
        sbd.append("\uff09");
        return sbd.toString();
    }

    private void getOrgOptions(ChartNode root, ChartOption option, List<ChartNode> nodes, List<ChartLink> links, String userId, Map<String, ChartNode> nodeIdMap) throws Exception {
        List<Org> orgs = this.orgService.getMainOrgListByUser(userId, null);
        for (Org org : orgs) {
            ArrayList<ChartNode> orgNodes = new ArrayList<ChartNode>();
            ArrayList<ChartLink> orgLinks = new ArrayList<ChartLink>();
            Org pOrg = (Org)this.orgService.get((Serializable)((Object)org.getParentId()));
            if (!BeanUtils.isNotEmpty((Object)pOrg)) continue;
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)pOrg.getDemId()));
            String demName = BeanUtils.isEmpty((Object)dem) ? "\u672a\u627e\u5230\uff01" : dem.getDemName();
            this.getSupOrg(root, org, pOrg, orgNodes, orgLinks, true, nodeIdMap, demName);
            if (BeanUtils.isNotEmpty(orgNodes)) {
                nodes.addAll(orgNodes);
            }
            if (!BeanUtils.isNotEmpty(orgLinks)) continue;
            links.addAll(orgLinks);
        }
    }

    private void getSupOrg(ChartNode root, Org nowOrg, Org pOrg, List<ChartNode> orgNodes, List<ChartLink> orgLinks, boolean isFirst, Map<String, ChartNode> nodeIdMap, String demName) throws Exception {
        if (BeanUtils.isNotEmpty((Object)pOrg)) {
            List<OrgPost> posts = this.orgPostService.getRelCharge(pOrg.getId(), true);
            ChartNode node = nodeIdMap.get(pOrg.getId());
            if (BeanUtils.isEmpty((Object)node)) {
                String label = this.getOrgLabel(pOrg, posts);
                node = new ChartNode(pOrg.getId(), 1, label, "\u6240\u5c5e\u7ef4\u5ea6\u3010" + demName + "\u3011", label, 30);
                nodeIdMap.put(pOrg.getId(), node);
                orgNodes.add(node);
            }
            ChartLink link = new ChartLink("\u7ec4\u7ec7\u9886\u5bfc", isFirst ? root.getId() : nowOrg.getId(), pOrg.getId(), isFirst ? 5 : 3);
            orgLinks.add(link);
            Org ppOrg = (Org)this.orgService.get((Serializable)((Object)pOrg.getParentId()));
            if (BeanUtils.isNotEmpty((Object)ppOrg)) {
                this.getSupOrg(root, pOrg, ppOrg, orgNodes, orgLinks, false, nodeIdMap, demName);
            }
        }
    }

    private String getOrgLabel(Org org, List<OrgPost> posts) throws Exception {
        StringBuilder sbd = new StringBuilder();
        sbd.append(org.getName());
        sbd.append("\n");
        sbd.append("\uff08");
        List<User> users = null;
        if (BeanUtils.isNotEmpty(posts)) {
            OrgPost post = posts.get(0);
            users = this.getListByPostId(post.getId());
            sbd.append(post.getName());
            String names = this.getUserNames(users);
            sbd.append("\u3010");
            sbd.append(StringUtil.isNotEmpty((String)names) ? names : "\u672a\u8bbe\u7f6e\u4eba\u5458");
            sbd.append("\u3011");
        } else {
            users = this.getChargesByOrg(org.getCode(), false);
            if (BeanUtils.isEmpty(users)) {
                sbd.append("\u672a\u8bbe\u7f6e\u8d23\u4efb\u5c97\u4f4d\u3001\u8d1f\u8d23\u4eba");
            } else {
                sbd.append("\u8d1f\u8d23\u4eba");
                sbd.append("\u3010");
                sbd.append(this.getUserNames(users));
                sbd.append("\u3011");
            }
        }
        sbd.append("\uff09");
        return sbd.toString();
    }

    private String getUserNames(List<User> users) {
        StringBuilder sbd = new StringBuilder();
        if (BeanUtils.isNotEmpty(users)) {
            boolean isFirst = true;
            for (User user : users) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbd.append("\uff0c");
                }
                sbd.append(user.getFullname());
            }
        }
        return sbd.toString();
    }

    @Override
    public IPage<User> getRoleUserQuery(QueryFilter filter) {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        return ((UserDao)this.baseMapper).getUserListByRoleCodeMap((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public IPage<User> getOrgUserQuery(QueryFilter<User> queryFilter) {
        return ((UserDao)this.baseMapper).getUserListByOrgQuery((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public boolean showADButton() {
        Properties sysProperties = this.propertiesService.getPropertiesByCode("ldaptime");
        boolean flag = false;
        if (BeanUtils.isNotEmpty((Object)sysProperties) && StringUtil.isNotEmpty((String)sysProperties.getValue())) {
            flag = true;
        }
        return flag;
    }

    private List<Org> getUserManagerOrgs(List<Org> orgs, String userId) throws Exception {
        ArrayList<Org> list = new ArrayList<Org>();
        for (Org org : orgs) {
            if (!this.isUserManagerInOrg(userId, org.getCode())) continue;
            list.add(org);
        }
        return list;
    }

    private boolean isUserManagerInOrg(String userId, String orgCode) throws Exception {
        boolean isIn = false;
        List<OrgPost> orgPosts = this.orgService.getPostsByOrgCodes(orgCode, true);
        if (BeanUtils.isNotEmpty(orgPosts)) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("orguser.user_id_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND);
            queryFilter.addFilter("orguser.pos_id_", (Object)orgPosts.get(0).getId(), QueryOP.EQUAL, FieldRelation.AND);
            List orgUserList = this.queryOrgUserRel(queryFilter);
            if (BeanUtils.isNotEmpty((Object)orgUserList)) {
                return true;
            }
            Org org = this.orgService.getByCode(orgCode);
            if (BeanUtils.isNotEmpty((Object)org)) {
                List<OrgUser> orgUsers = this.orgUserService.getListByOrgIdUserId(org.getId(), userId);
                for (OrgUser orgUser : orgUsers) {
                    if (orgUser.getIsCharge() == 0) continue;
                    return true;
                }
            }
        }
        return isIn;
    }

    @Override
    @Transactional
    public void setStatus(UserStatusVo userStatusVo) throws Exception {
        ((UserDao)this.baseMapper).updateStatusByAccounts(userStatusVo.getStatus(), userStatusVo.getAccounts(), LocalDateTime.now());
    }

    @Override
    public CommonResult<Boolean> isAccountExist(String account) throws Exception {
        Integer amount = ((UserDao)this.baseMapper).queryByAccount(account);
        return new CommonResult(true, "", (Object)(amount > 0 ? 1 : 0));
    }

    @Override
    public CommonResult<Boolean> isUserNumberExist(String account, String userNumber) throws Exception {
        Integer amount = ((UserDao)this.baseMapper).queryByUserNumber(account, userNumber);
        return new CommonResult(true, "", (Object)(amount > 0 ? 1 : 0));
    }

    @Override
    public CommonResult<String> uploadPortrait(String account, MultipartFile file) throws Exception {
        if (!file.isEmpty()) {
            String originalFilename = file.getOriginalFilename();
            String extName = this.getExtName(originalFilename);
            String finalName = UniqueIdUtil.getSuid() + extName;
            Path path = Paths.get(this.attachPath, account, finalName);
            Path parent = path.getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                File dir = new File(parent.toString());
                dir.mkdirs();
            }
            Files.copy(file.getInputStream(), path, new CopyOption[0]);
            return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)(account + "/" + finalName));
        }
        throw new SystemException("Upload file is empty.");
    }

    private String getExtName(String fileName) {
        Pattern regex = Pattern.compile("^.*(\\.\\w+)$");
        Matcher regexMatcher = regex.matcher(fileName);
        if (regexMatcher.matches()) {
            return regexMatcher.group(1);
        }
        return null;
    }

    @Override
    public Resource downloadPortrait(String account, String filename) throws Exception {
        return this.resourceLoader.getResource("file:" + Paths.get(this.attachPath, account, filename));
    }

    @Override
    public IPage<User> getDemUserQuery(QueryFilter filter) throws Exception {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        return ((UserDao)this.baseMapper).getDemUserQuery((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public IPage<User> getUserByOrgQuery(QueryFilter filter) throws Exception {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        return ((UserDao)this.baseMapper).getUserByOrgQuery((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public CommonResult<String> setTrigger(TriggerVo triggerVo, String ip) throws Exception {
        return new CommonResult(true, "\u4efb\u52a1\u6267\u884c\u8ba1\u5212\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public CommonResult<UserVo> getUserById(String userId) throws Exception {
        if (StringUtil.isEmpty((String)userId)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\uff1a\u201cuserId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\u4e3a\u3010" + userId + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
        }
        UserVo userVo = new UserVo(user);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)userVo);
    }

    @Override
    public PageList<User> queryByType(QueryFilter queryFilter) throws SystemException {
        this.copyQuerysInParams(queryFilter);
        this.handleQueryFilter(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty((Object)pageBean)) {
            pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(50), Boolean.valueOf(true));
        }
        IPage<User> query = ((UserDao)this.baseMapper).queryByType((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    private Class<? super T> getTypeClass() {
        Class rawType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        return rawType;
    }

    private void handleQueryFilter(QueryFilter queryFilter) throws SystemException {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            throw new SystemException("QueryFilter\u901a\u7528\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a.");
        }
    }

    @Override
    public List<UserVo> queryUser(QueryFilter queryFilter) {
        List users = this.queryNoPage(queryFilter);
        ArrayList<UserVo> userVos = new ArrayList<UserVo>();
        for (User user : users) {
            UserVo userVo = OrgUtil.convertToUserVo(user);
            userVos.add(userVo);
        }
        return userVos;
    }

    @Override
    public List<User> getSuperFromUnder(String userId, String orgId, String demId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (StringUtil.isNotEmpty((String)orgId)) {
            params.put("orgId", orgId);
        }
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
        }
        return ((UserDao)this.baseMapper).getSuperFromUnder(params);
    }

    @Override
    public List<User> getSuperiorFromUnder(String userId, String demId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
        }
        return ((UserDao)this.baseMapper).getSuperiorFromUnder(params);
    }

    @Override
    public Map<String, Object> getUserDetailed(String userId) {
        return ((UserDao)this.baseMapper).getUserDetailed(userId);
    }

    @Override
    public List<UserVo> getDepHeader(String userId, Boolean isMain) throws Exception {
        Org org = this.getOrgByUserId(userId);
        if (BeanUtils.isNotEmpty((Object)org)) {
            return this.getDepHeaderByOrgId(org.getId(), isMain);
        }
        return new ArrayList<UserVo>();
    }

    private Org getOrgByUserId(String userId) {
        User u = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isNotEmpty((Object)u)) {
            return this.orgService.getMainGroup(userId, "");
        }
        return new Org();
    }

    private ObjectNode getUserInfoByUserId(String userId) throws Exception {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        User u = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isNotEmpty((Object)u)) {
            objectNode.set("user", JsonUtil.toJsonNode((Object)u));
            Org org = this.orgService.getMainGroup(userId, "");
            if (BeanUtils.isNotEmpty((Object)org)) {
                objectNode.set("org", JsonUtil.toJsonNode((Object)org));
            }
        }
        return objectNode;
    }

    @Override
    public List<UserVo> getDepHeaderByOrg(String orgId, Boolean isMain) throws Exception {
        return this.getDepHeaderByOrgId(orgId, isMain);
    }

    private List<UserVo> getDepHeaderByOrgId(String orgId, Boolean isMain) throws Exception {
        if (BeanUtils.isNotEmpty((Object)orgId)) {
            List<OrgUser> chargesByOrgId = this.orgUserService.getChargesByOrgId(orgId, isMain);
            ArrayList<String> userIds = new ArrayList<String>();
            for (OrgUser orgUser : chargesByOrgId) {
                userIds.add(orgUser.getUserId());
            }
            if (userIds.size() > 0) {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("ID_", userIds, QueryOP.IN);
                PageList query = this.query(queryFilter);
                ArrayList<UserVo> voList = new ArrayList<UserVo>();
                for (User user : query.getRows()) {
                    if (BeanUtils.isEmpty((Object)user)) continue;
                    voList.add(new UserVo(user));
                }
                return voList;
            }
        }
        return null;
    }

    @Override
    public List<Group> getGroupsByUserId(String userId, String type) {
        List<OrgPost> listOrgRelDef;
        List<OrgJob> listOrgRel;
        List<Role> listRole;
        List<Org> listOrg;
        ArrayList<UcBaseModel> listMap = new ArrayList<UcBaseModel>();
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            user = this.getByAccount(userId);
        }
        if (BeanUtils.isEmpty((Object)user)) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u7528\u6237id\u6216\u8005\u8d26\u53f7\u672a\u627e\u5230\u7528\u6237");
        }
        userId = user.getId();
        if ((GroupTypeConstant.All.key().equals(type) || GroupTypeConstant.ORG.key().equals(type)) && BeanUtils.isNotEmpty(listOrg = this.orgService.getOrgListByUserId(userId))) {
            listMap.addAll(listOrg);
        }
        if ((GroupTypeConstant.All.key().equals(type) || GroupTypeConstant.ROLE.key().equals(type)) && BeanUtils.isNotEmpty(listRole = this.roleService.getListByUserId(userId))) {
            listMap.addAll(listRole);
        }
        if ((GroupTypeConstant.All.key().equals(type) || GroupTypeConstant.JOB.key().equals(type)) && BeanUtils.isNotEmpty(listOrgRel = this.orgJobService.getListByUserId(userId))) {
            listMap.addAll(listOrgRel);
        }
        if ((GroupTypeConstant.All.key().equals(type) || GroupTypeConstant.POSITION.key().equals(type)) && BeanUtils.isNotEmpty(listOrgRelDef = this.orgPostService.getListByUserId(userId, ""))) {
            listMap.addAll(listOrgRelDef);
        }
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (IGroup iGroup : listMap) {
            Group group = new Group();
            group.setGroupId(iGroup.getGroupId());
            group.setGroupCode(iGroup.getGroupCode());
            group.setName(iGroup.getName());
            group.setGroupType(iGroup.getGroupType());
            group.setIdentityType(iGroup.getIdentityType());
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public Map<String, Object> getUserDetailByAccountOrId(String userId) throws IOException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            user = this.getByAccount(userId);
        }
        if (BeanUtils.isEmpty((Object)user)) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u8d26\u53f7\u6216\u8005ID\u672a\u627e\u5230\u7528\u6237");
        }
        resultMap.put("user", user);
        List<Map<String, Object>> orgPostList = this.orgPostService.getUserByUserId(user.getId());
        if (BeanUtils.isEmpty(orgPostList)) {
            return resultMap;
        }
        HashMap<String, Map<String, Object>> postMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < orgPostList.size(); ++i) {
            if (i == orgPostList.size() - 1) {
                resultMap.put("role", orgPostList.get(i).get("roleName"));
                continue;
            }
            Map<String, Object> map = orgPostList.get(i);
            if (BeanUtils.isNotEmpty((Object)map.get("pathName")) && BeanUtils.isNotEmpty((Object)map.get("demName"))) {
                map.put("pathName", map.get("demName").toString() + map.get("pathName").toString());
            }
            if (BeanUtils.isNotEmpty((Object)map.get("postId"))) {
                postMap.put(map.get("postId").toString(), map);
            }
            if (!BeanUtils.isNotEmpty((Object)map.get("orgId"))) continue;
            if (BeanUtils.isNotEmpty(orgMap)) {
                for (Object org : orgMap.values()) {
                    Map obj = (Map)org;
                    if ("1".equals(obj.get("isMaster").toString()) || !"1".equals(map.get("isMaster").toString())) continue;
                    orgMap.clear();
                    orgMap.put(map.get("orgId").toString(), map);
                }
                Demension defaultDemension = this.demensionService.getDefaultDemension();
                if (!BeanUtils.isNotEmpty((Object)defaultDemension) || !map.get("demName").toString().equals(defaultDemension.getDemName()) || !"1".equals(map.get("isMaster").toString())) continue;
                orgMap.clear();
                orgMap.put(map.get("orgId").toString(), map);
                continue;
            }
            orgMap.put(map.get("orgId").toString(), map);
        }
        resultMap.put("post", postMap);
        resultMap.put("org", orgMap.size() == 0 ? "" : JsonUtil.objectToArray((JsonNode)JsonUtil.toJsonNode(orgMap)));
        return resultMap;
    }

    private Map<String, String> getParentOrg(String parentId) {
        Org org = (Org)this.orgService.get((Serializable)((Object)parentId));
        if (BeanUtils.isNotEmpty((Object)org)) {
            String orgKind = org.getOrgKind();
            HashMap<String, String> parentOgn = new HashMap<String, String>();
            if (orgKind.equals("ogn")) {
                parentOgn.put("id", org.getId());
                parentOgn.put("code", org.getCode());
                parentOgn.put("name", org.getName());
                return parentOgn;
            }
            if (orgKind.equals("dept")) {
                String parentOrgParentId = org.getParentId();
                return this.getParentOrg(parentOrgParentId);
            }
        }
        return null;
    }

    @Override
    public List<User> getUserByName(String query) {
        return ((UserDao)this.baseMapper).getUserByName(query);
    }

    @Override
    public Map<String, Object> calculateNodeUser(Map<String, Object> result) {
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            List<Object> recievers = new ArrayList();
            ArrayList<ObjectNode> bpmIdentityList = new ArrayList<ObjectNode>();
            try {
                recievers = this.extractUser((List)entry.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (IUser user : recievers) {
                ObjectNode bpmIdentity = JsonUtil.getMapper().createObjectNode();
                bpmIdentity.put("type", "user");
                bpmIdentity.put("id", user.getUserId());
                bpmIdentity.put("name", user.getFullname());
                bpmIdentityList.add(bpmIdentity);
            }
            result.put(entry.getKey(), bpmIdentityList);
        }
        return result;
    }

    private List<IUser> extractUser(List<Map<String, Object>> bpmIdentities) throws Exception {
        PageList users;
        ArrayList<IUser> results = new ArrayList<IUser>();
        String userIds = "";
        String accounts = "";
        String orbyaccounts = "";
        if (BeanUtils.isEmpty(bpmIdentities)) {
            return results;
        }
        for (Map<String, Object> bpmIdentity : bpmIdentities) {
            if (bpmIdentity.get("type").toString().equals("group")) {
                users = this.getUserListByGroup(bpmIdentity);
                results.addAll((Collection<IUser>)users);
                continue;
            }
            if (!"user".equals(bpmIdentity.get("type").toString()) && !bpmIdentity.get("type").toString().equals("groupUser")) continue;
            if (BeanUtils.isNotEmpty((Object)bpmIdentity.get("id"))) {
                userIds = userIds + bpmIdentity.get("id").toString() + ",";
                continue;
            }
            accounts = accounts + bpmIdentity.get("code").toString() + ",";
            orbyaccounts = orbyaccounts + "'" + bpmIdentity.get("code").toString() + "'" + ",";
        }
        if (StringUtil.isNotEmpty((String)userIds)) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("id_", (Object)userIds, QueryOP.IN);
            queryFilter.addFilter("status_", (Object)1, QueryOP.EQUAL);
            PageList users2 = this.query(queryFilter);
            results.addAll(users2.getRows());
        }
        if (StringUtil.isNotEmpty((String)accounts)) {
            StringBuffer orbyaccount = new StringBuffer(orbyaccounts);
            orbyaccount.deleteCharAt(orbyaccount.length() - 1);
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("account_", (Object)accounts, QueryOP.IN);
            queryFilter.addParams("orderBySql", (Object)("FIELD(account_," + orbyaccount + ")"));
            queryFilter.addFilter("status_", (Object)1, QueryOP.EQUAL);
            users = this.query(queryFilter);
            results.addAll(users.getRows());
        }
        return results;
    }

    private List<User> getUserListByGroup(Map<String, Object> bpmIdentityMap) throws Exception {
        List<User> result = new ArrayList<User>();
        if (BeanUtils.isEmpty(bpmIdentityMap)) {
            return result;
        }
        String groupType = MapUtil.getString(bpmIdentityMap, (String)"groupType");
        if (StringUtil.isEmpty((String)groupType)) {
            return result;
        }
        String groupId = MapUtil.getString(bpmIdentityMap, (String)"id");
        String groupCode = MapUtil.getString(bpmIdentityMap, (String)"code");
        if (groupType.equals(GroupTypeConstant.ORG.key())) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            if (StringUtil.isNotEmpty((String)groupId)) {
                queryFilter.addFilter("orgId", (Object)groupId, QueryOP.EQUAL);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                queryFilter.addFilter("orgCode", (Object)groupCode, QueryOP.EQUAL);
            } else {
                return result;
            }
            IPage<User> demUserQuery = this.getDemUserQuery(queryFilter);
            result = demUserQuery.getRecords();
        }
        if (groupType.equals(GroupTypeConstant.ROLE.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUsersByRoleId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUsersByRoleCode(groupCode);
            } else {
                return result;
            }
        }
        if (groupType.equals(GroupTypeConstant.POSITION.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUserByPostId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUserByPostCode(groupCode);
            } else {
                return result;
            }
        }
        if (groupType.equals(GroupTypeConstant.JOB.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUsersByJobId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUsersByJobCode(groupCode);
            } else {
                return result;
            }
        }
        return result;
    }

    private List<User> getUsersByJobId(String ids) {
        String[] idArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String id : idArray = ids.split(",")) {
            List<User> users;
            OrgJob job = (OrgJob)this.orgJobManager.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)job) || !BeanUtils.isNotEmpty(users = this.getListByJobId(job.getId()))) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    public List<User> getUsersByJobCode(String codes) throws Exception {
        String[] codeArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String code : codeArray = codes.split(",")) {
            List<User> users;
            OrgJob job = this.orgJobManager.getByCode(code);
            if (!BeanUtils.isNotEmpty((Object)job) || !BeanUtils.isNotEmpty(users = this.getListByJobId(job.getId()))) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    private List<User> getUserByPostCode(String postCode) {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1apostCode\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RequiredException("\u5c97\u4f4d\u7f16\u7801\u3010" + postCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return ((UserDao)this.baseMapper).getUserByPost(postCode);
    }

    private List<User> getUserByPostId(String postId) {
        Assert.notNull((Object)postId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        OrgPost orgPost = (OrgPost)this.orgPostService.get((Serializable)((Object)postId));
        if (BeanUtils.isEmpty((Object)orgPost)) {
            throw new RequiredException("\u4e0d\u5b58\u5728\u5c97\u4f4dID\u4e3a\u3010" + postId + "\u3011\u7684\u6570\u636e");
        }
        return ((UserDao)this.baseMapper).getUserByPost(orgPost.getCode());
    }

    private List<User> getUsersByRoleId(String ids) throws Exception {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RequiredException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        String[] idArray = ids.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        boolean isFirst = true;
        for (String id : idArray) {
            List<User> users = this.getUserListByRoleId(id);
            if (BeanUtils.isNotEmpty(users)) {
                list.addAll(users);
                isTrue = true;
                continue;
            }
            if (!isFirst) {
                msg.append(",");
            } else {
                isFirst = false;
            }
            msg.append(id);
        }
        if (!isTrue) {
            throw new RequiredException("\u6839\u636e\u89d2\u8272ID\u3010" + msg + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    private List<User> getUsersByRoleCode(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        String[] codeArray = codes.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        boolean isFirst = true;
        for (String code : codeArray) {
            List<User> users = this.getUserListByRoleCode(code);
            if (BeanUtils.isNotEmpty(users)) {
                list.addAll(users);
                isTrue = true;
                continue;
            }
            if (!isFirst) {
                msg.append(",");
            } else {
                isFirst = false;
            }
            msg.append(code);
        }
        if (!isTrue) {
            throw new RequiredException("\u6839\u636e\u89d2\u8272\u7f16\u7801\u3010" + msg + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    @Override
    public CommonResult<UserVo> getUserByOpenId(String openId) {
        try {
            if (StringUtil.isEmpty((String)openId)) {
                return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\uff1a\u201copenId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
            }
            User user = ((UserDao)this.baseMapper).getUserByOpenId(openId);
            if (BeanUtils.isEmpty((Object)user)) {
                return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5fae\u4fe1\u4e3a\u3010" + openId + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
            }
            UserVo userVo = new UserVo(user);
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)userVo);
        }
        catch (Exception e) {
            return new CommonResult(true, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c" + e.getMessage(), null);
        }
    }

    @Override
    public Map<String, Map<String, String>> getUserRightMapByIds(Set<String> ids) {
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        QueryFilter orgPostFiler = QueryFilter.build();
        orgPostFiler.addFilter("user_id_", new ArrayList<String>(ids), QueryOP.IN);
        PageList orgPostQuery = this.orgUserService.query(orgPostFiler);
        for (String string : ids) {
            HashMap<String, HashSet<String>> userMap = new HashMap<String, HashSet<String>>();
            userMap.put("user", new HashSet<String>(Collections.singletonList(string)));
            resultMap.put(string, userMap);
        }
        HashSet<String> allPostIds = new HashSet<String>();
        if (BeanUtils.isNotEmpty((Object)orgPostQuery)) {
            for (OrgUser orgUser : orgPostQuery.getRows()) {
                Map userMap = (Map)resultMap.get(orgUser.getUserId());
                Iterator orgSet = userMap.containsKey(GroupTypeConstant.ORG.key()) ? (Set)userMap.get(GroupTypeConstant.ORG.key()) : new HashSet<String>();
                orgSet.add(orgUser.getOrgId());
                userMap.put(GroupTypeConstant.ORG.key(), orgSet);
                if (StringUtil.isNotEmpty((String)orgUser.getRelId())) {
                    HashSet<String> postSet = userMap.containsKey(GroupTypeConstant.POSITION.key()) ? (Set)userMap.get(GroupTypeConstant.POSITION.key()) : new HashSet<String>();
                    postSet.add(orgUser.getRelId());
                    userMap.put(GroupTypeConstant.POSITION.key(), postSet);
                    allPostIds.add(orgUser.getRelId());
                }
                resultMap.put(orgUser.getUserId(), userMap);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!allPostIds.isEmpty()) {
            QueryFilter postFilter = QueryFilter.build();
            postFilter.addFilter("ID_", new ArrayList(allPostIds), QueryOP.IN);
            PageList postQuery = this.orgPostService.query(postFilter);
            if (BeanUtils.isNotEmpty((Object)postQuery)) {
                for (OrgPost post : postQuery.getRows()) {
                    hashMap.put(post.getId(), post.getRelDefId());
                }
            }
        }
        QueryFilter roleFiler = QueryFilter.build();
        roleFiler.addFilter("user_id_", new ArrayList<String>(ids), QueryOP.IN);
        roleFiler.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList roleQuery = this.userRoleService.query(roleFiler);
        if (BeanUtils.isNotEmpty((Object)roleQuery)) {
            for (UserRole userRole : roleQuery.getRows()) {
                Map userMap = (Map)resultMap.get(userRole.getUserId());
                HashSet<String> roleSet = userMap.containsKey(GroupTypeConstant.ROLE.key()) ? (Set)userMap.get(GroupTypeConstant.ROLE.key()) : new HashSet<String>();
                roleSet.add(userRole.getRoleId());
                userMap.put(GroupTypeConstant.ROLE.key(), roleSet);
                resultMap.put(userRole.getUserId(), userMap);
            }
        }
        HashMap<String, Map<String, String>> userRightMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry next : resultMap.entrySet()) {
            Map value = (Map)next.getValue();
            HashMap rightMapStr = new HashMap();
            if (value.containsKey(GroupTypeConstant.POSITION.key())) {
                HashSet jobSet = new HashSet();
                for (String postId : (Set)value.get(GroupTypeConstant.POSITION.key())) {
                    jobSet.add(hashMap.get(postId));
                }
                value.put(GroupTypeConstant.JOB.key(), jobSet);
            }
            for (Map.Entry item : value.entrySet()) {
                rightMapStr.put(item.getKey(), StringUtil.convertListToSingleQuotesString((Set)((Set)item.getValue())));
            }
            userRightMap.put((String)next.getKey(), rightMapStr);
        }
        return userRightMap;
    }

    private boolean checkEmail(String email) {
        try {
            String check = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            return matcher.matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public CommonResult<UserVo> getUserByMobile(String mobile) {
        User user = ((UserDao)this.baseMapper).getByMobile(mobile);
        if (BeanUtils.isEmpty((Object)user)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e3a\u3010" + mobile + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
        }
        UserVo userVo = new UserVo(user);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)userVo);
    }

    @Override
    public ArrayNode getUserInfoBySignData(ArrayNode customSignDatas) throws Exception {
        for (JsonNode jsonNode : customSignDatas) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            String executor = objectNode.get("executor").asText();
            JsonNode executorJson = JsonUtil.toJsonNode((String)executor);
            executorJson = executorJson.get(0);
            ObjectNode resultObj = this.getUserInfoByUserId(executorJson.get("id").asText());
            ObjectNode executorObject = (ObjectNode)executorJson;
            executorObject.put("orgName", resultObj.has("org") ? resultObj.get("org").get("name").asText() : "");
            executorObject.put("account", resultObj.has("user") ? resultObj.get("user").get("account").asText() : "");
            objectNode.set("executor", (JsonNode)executorObject);
        }
        return customSignDatas;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserDao)this.baseMapper).removePhysical();
    }

    @Override
    public IPage<User> getGroupUsersPage(UserGroup userGroup, QueryFilter queryFilter) {
        String[] userIds = new String[]{""};
        String[] orgIds = new String[]{""};
        String[] roleIds = new String[]{""};
        String[] posIds = new String[]{""};
        boolean isEmptyGroup = true;
        this.copyQuerysInParams(queryFilter);
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty((Object)userGroup)) {
            if (StringUtil.isNotEmpty((String)userGroup.getUserId())) {
                userIds = userGroup.getUserId().split(",");
                params.put("userIds", userIds);
                isEmptyGroup = false;
            }
            if (StringUtil.isNotEmpty((String)userGroup.getOrgId())) {
                orgIds = userGroup.getOrgId().split(",");
                params.put("orgIds", orgIds);
                isEmptyGroup = false;
            }
            if (StringUtil.isNotEmpty((String)userGroup.getRoleId())) {
                roleIds = userGroup.getRoleId().split(",");
                params.put("roleIds", roleIds);
                isEmptyGroup = false;
            }
            if (StringUtil.isNotEmpty((String)userGroup.getPosId())) {
                posIds = userGroup.getPosId().split(",");
                params.put("posIds", posIds);
                isEmptyGroup = false;
            }
        }
        if (BeanUtils.isEmpty((Object)params) || isEmptyGroup) {
            return null;
        }
        PageBean pageBean = queryFilter.getPageBean();
        IPage<User> groupUsersPage = ((UserDao)this.baseMapper).getGroupUsersPage((IPage<User>)this.convert2IPage(pageBean), params);
        return groupUsersPage;
    }

    @Override
    public CommonResult<String> getTokenByUserName(String userName) {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(userName);
        String token = this.jwtTokenHandler.generateToken(userDetails);
        return new CommonResult(true, "\u83b7\u53d6Token\u6210\u529f\uff01", (Object)token);
    }

    @Override
    public void userExport(List<String> users, HttpServletResponse httpServletResponse) throws Exception {
        long start = System.currentTimeMillis();
        ArrayList list = new ArrayList();
        AtomicBoolean res = new AtomicBoolean(false);
        StringBuffer bf = new StringBuffer();
        ForkJoinPool myPool = new ForkJoinPool(8);
        ((ForkJoinTask)myPool.submit(() -> users.parallelStream().forEach(user -> {
            Map u = null;
            try {
                u = JsonUtil.toMap((String)user);
            }
            catch (IOException e) {
                bf.append(e.getMessage());
                res.set(true);
            }
            List<Map<String, Object>> maps = this.putInfo(u);
            maps.parallelStream().forEach(item -> list.add(item));
        }))).get();
        if (res.get()) {
            throw new BaseException(bf.toString());
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("\u603b\u6d88\u8017\u65f6\u95f4\uff1a" + duration / 1000L + "\u79d2");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("pathName", "\u7ec4\u7ec7\u5355\u5143\u540d\u79f0");
        map.put("fullname", "\u59d3\u540d");
        map.put("sex", "\u6027\u522b");
        map.put("mobile", "\u624b\u673a\u53f7\u7801");
        map.put("account", "\u8d26\u53f7");
        map.put("status", "\u5458\u5de5\u72b6\u6001");
        map.put("address", "\u5730\u5740");
        map.put("postName", "\u5c97\u4f4d");
        map.put("jobName", "\u804c\u52a1");
        map.put("weixin", "\u5fae\u4fe1\u53f7");
        map.put("email", "\u90ae\u7bb1");
        map.put("isCharge", "\u90e8\u95e8\u8d1f\u8d23\u4eba");
        map.put("isMaster", "\u662f\u5426\u4e3b\u7ec4\u7ec7");
        HSSFWorkbook sheets = ExcelUtil.exportExcel((String)String.valueOf(start), (int)17, map, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)sheets, (String)String.valueOf(start), (HttpServletResponse)httpServletResponse);
    }

    @Override
    public IPage<User> selectShiftUser(QueryFilter queryFilter) {
        queryFilter.addFilter("u.is_dele_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        queryFilter.addFilter("su.is_dele_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        return ((UserDao)this.baseMapper).selectShiftUser((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    private List<Map<String, Object>> putInfo(Map<String, Object> u) {
        String userId = u.get("id").toString();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(200);
        List<OrgUser> orgUserList = this.orgUserManager.getListPostAndJob(userId);
        orgUserList.parallelStream().forEach(orgUser -> {
            Map<String, Object> map = this.userInfoToMap(u, orgUser.getIsMaster(), orgUser.getIsCharge());
            map.put("pathName", orgUser.getPathName());
            map.put("jobName", orgUser.getJobName());
            map.put("postName", orgUser.getPostName());
            list.add(map);
        });
        if (list.size() == 0) {
            Map<String, Object> map = this.userInfoToMap(u, -1, -1);
            list.add(map);
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    private Map<String, Object> userInfoToMap(Map<String, Object> u, Integer isMaster, Integer isCharge) {
        String status;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fullname", u.get("fullname"));
        map.put("sex", u.get("sex"));
        map.put("mobile", u.get("mobile"));
        map.put("address", u.get("address"));
        map.put("account", u.get("account"));
        map.put("email", u.get("email"));
        map.put("weixin", u.get("weixin"));
        switch (status = u.get("status").toString()) {
            case "1": {
                map.put("status", "\u5728\u804c");
                break;
            }
            case "0": {
                map.put("status", "\u7981\u7528");
                break;
            }
            case "-1": {
                map.put("status", "\u5f85\u6fc0\u6d3b");
                break;
            }
            case "-2": {
                map.put("status", "\u79bb\u804c");
            }
        }
        switch (isMaster) {
            case 0: {
                map.put("isMaster", "0");
                break;
            }
            case 1: {
                map.put("isMaster", "1");
                break;
            }
            default: {
                map.put("isMaster", "");
            }
        }
        switch (isCharge) {
            case 0: {
                map.put("isCharge", "\u5426");
                break;
            }
            case 1: {
                map.put("isCharge", "\u662f");
                break;
            }
            case 2: {
                map.put("isCharge", "\u4e3b");
                break;
            }
            default: {
                map.put("isCharge", "");
            }
        }
        return map;
    }

    @Override
    public List<User> getUsersNotYetSyncWxWork() {
        return ((UserDao)this.baseMapper).getUsersNotYetSyncWxWork();
    }

    @Override
    public User getUserByWxWorkId(String wxWorkId) {
        return ((UserDao)this.baseMapper).getUserByWxWorkId(wxWorkId);
    }

    @Override
    public List<User> getUsersNotYetSyncDingtalk() {
        return ((UserDao)this.baseMapper).getUsersNotYetSyncDingtalk();
    }

    @Override
    public User getUserByDingtalkId(String dingtalkId) {
        return ((UserDao)this.baseMapper).getUserByDingtalkId(dingtalkId);
    }

    @Override
    public User getUserByYkzEmployeeCode(String employeeCode) {
        List<User> list = ((UserDao)this.baseMapper).getUserByYkzEmployeeCode(employeeCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<User> getByAccounts(List<String> accounts) throws Exception {
        return ((UserDao)this.baseMapper).getByAccounts(accounts);
    }

    @Override
    public boolean insertBatch(List<User> list) {
        return this.saveBatch(list);
    }

    @Override
    public boolean updateBatch(List<User> list) {
        return ((UserDao)this.baseMapper).updateBatch(list);
    }

    @Override
    public List<User> getByCompanyRole(String company, String role) {
        List<User> list = ((UserDao)this.baseMapper).getUserListByOrgCode(company);
        List<User> roleList = this.getUserListByRoleCode(role);
        List<User> intersection = list.stream().filter(t -> roleList.stream().anyMatch(t2 -> t2.getId().equals(t.getId()))).collect(Collectors.toList());
        return intersection;
    }

    @Override
    public List<UserVo> getLeaderStep(String userId, Integer grade, boolean res) throws Exception {
        List<User> superFromUnder;
        List<Org> orgList = this.orgService.getParantMainOrgAll(userId);
        Collections.sort(orgList, new Comparator<Org>(){

            @Override
            public int compare(Org o1, Org o2) {
                if (Integer.parseInt(o1.getGrade()) > Integer.parseInt(o2.getGrade())) {
                    return -1;
                }
                if (o1.getGrade().equals(o2.getGrade())) {
                    return 0;
                }
                return 1;
            }
        });
        ArrayList<UserVo> list = new ArrayList<UserVo>();
        if (res && BeanUtils.isNotEmpty(superFromUnder = this.getSuperFromUnder(userId, null, null))) {
            for (User user : superFromUnder) {
                list.add(new UserVo(user));
            }
        }
        orgList = this.handleOrgList(orgList, grade);
        for (int i = 0; i < orgList.size(); ++i) {
            List<UserVo> vo;
            Org item = orgList.get(i);
            if (grade > Integer.parseInt(item.getGrade()) || !BeanUtils.isNotEmpty(vo = this.getDepHeaderByOrg(item.getId(), true))) continue;
            list.addAll(vo);
        }
        return list;
    }

    private ArrayList<Org> handleOrgList(List<Org> orgList, Integer grade) {
        ArrayList<Org> newArr = new ArrayList<Org>();
        Integer i = 5;
        while (i >= grade) {
            HashMap<String, Org> orgMap = new HashMap<String, Org>();
            for (Org org : orgList) {
                if (Integer.parseInt(org.getGrade()) != i) continue;
                orgMap.put(org.getId(), org);
            }
            if (!BeanUtils.isEmpty(orgMap)) {
                if (orgMap.size() == 1) {
                    for (String s : orgMap.keySet()) {
                        newArr.add((Org)orgMap.get(s));
                    }
                } else {
                    LinkedList orgLinkedList = new LinkedList();
                    Integer time = 0;
                    while (orgMap.size() >= 1) {
                        for (String key : orgMap.keySet()) {
                            if (!orgMap.containsKey(((Org)orgMap.get(key)).getParentId())) {
                                orgLinkedList.addLast(orgMap.remove(key));
                                time = 0;
                                break;
                            }
                            Integer n = time;
                            Integer n2 = time = Integer.valueOf(time + 1);
                        }
                        if (time <= orgMap.size()) continue;
                        for (String s : orgMap.keySet()) {
                            orgLinkedList.addLast(orgMap.get(s));
                        }
                    }
                    while (orgLinkedList.size() > 0) {
                        newArr.add((Org)orgLinkedList.removeLast());
                    }
                }
            }
            Integer n = i;
            i = i - 1;
            Integer n3 = i;
        }
        return newArr;
    }

    @Override
    public List<User> getFgUsers(String orgId, String orgParam, String userParam) {
        List<User> list = new ArrayList<User>();
        OrgParams orgParams = this.orgParamsService.getByOrgIdAndAlias(orgId, orgParam);
        if (BeanUtils.isNotEmpty((Object)orgParams) && StringUtil.isNotEmpty((String)orgParams.getValue())) {
            String value = orgParams.getValue();
            String sql = "SELECT USER_ID_ from UC_USER_PARAMS  WHERE CODE_ ='" + userParam + "' AND VALUE_='" + value + "'";
            list = ((UserDao)this.baseMapper).selectList((Wrapper)Wrappers.lambdaQuery().inSql(User::getId, sql));
        }
        return list;
    }

    @Override
    public List<UserVo> getLeaderStepByOrgId(String orgId, Integer grade) throws Exception {
        Org org = (Org)this.orgService.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org)) {
            return new ArrayList<UserVo>();
        }
        ArrayList<UserVo> list = new ArrayList<UserVo>();
        List<UserVo> leadIds = this.getDepHeaderByOrg(orgId, true);
        if (BeanUtils.isNotEmpty(leadIds)) {
            list.addAll(leadIds);
        }
        if (Integer.parseInt(org.getGrade()) > grade) {
            Org parent;
            String parentId = org.getParentId();
            while (!BeanUtils.isEmpty((Object)(parent = (Org)this.orgService.get((Serializable)((Object)parentId)))) && Integer.parseInt(parent.getGrade()) >= grade) {
                List<UserVo> userIds = this.getDepHeaderByOrgId(parent.getId(), true);
                if (BeanUtils.isNotEmpty(userIds)) {
                    for (UserVo userId : userIds) {
                        if (!this.isUserNotInList(list, userId)) continue;
                        list.add(userId);
                    }
                }
                parentId = parent.getParentId();
            }
        }
        if (BeanUtils.isEmpty(list)) {
            return new ArrayList<UserVo>();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean syncUser() throws Exception {
        ArrayList<zsUserVO> userList;
        Role role;
        ArrayList<OrgUserVO> orgUsers;
        List users;
        Map<String, List<Org>> map;
        block51: {
            Iterator iterator;
            ObjectMapper mapper;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(UcBaseModel::getIsDelete, (Object)"0");
            List orgs = this.orgManager.list((Wrapper)wrapper);
            map = orgs.stream().collect(Collectors.groupingBy(Org::getCode));
            Optional<Org> minGradeOrg = orgs.stream().filter(o -> o.getGrade().equals("1")).min(Comparator.comparing(Org::getCode));
            if (!minGradeOrg.isPresent()) return true;
            Org org = minGradeOrg.get();
            String intoUrl = this.teijianConfig.getUrl() + this.teijianConfig.getUserInterface() + "?orgCode=%s";
            if (orgs.isEmpty()) {
                return true;
            }
            users = ((UserDao)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{User::getAccount})).stream().map(User::getAccount).collect(Collectors.toList());
            orgUsers = new ArrayList<OrgUserVO>();
            role = this.roleManager.getByAlias("ybry");
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                String orgCode = org.getCode();
                if (orgCode == null || orgCode.trim().isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                String encodedCode = URLEncoder.encode(orgCode, StandardCharsets.UTF_8.toString());
                String url = String.format(intoUrl, encodedCode);
                HttpGet request = new HttpGet(url);
                try {
                    Throwable throwable;
                    CloseableHttpResponse response;
                    block49: {
                        boolean bl;
                        block50: {
                            response = httpClient.execute((HttpUriRequest)request);
                            throwable = null;
                            int statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode == 200) break block49;
                            bl = false;
                            if (response == null) return bl;
                            if (throwable == null) break block50;
                            try {
                                response.close();
                                return bl;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return bl;
                            }
                        }
                        response.close();
                        return bl;
                    }
                    try {
                        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        mapper = new ObjectMapper();
                        JsonNode root = mapper.readTree(responseBody);
                        JsonNode dataList = root.path("dataList");
                        userList = new ArrayList<zsUserVO>();
                        if (!dataList.isArray()) break block51;
                        iterator = dataList.iterator();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        if (response != null) {
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                response.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    boolean bl = false;
                    if (httpClient == null) return bl;
                    if (var11_12 != null) {
                        try {
                            httpClient.close();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            var11_12.addSuppressed(throwable);
                            return bl;
                        }
                    }
                    httpClient.close();
                    return bl;
                }
            }
            catch (Exception e) {
                this.log.error("HTTP\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
                return false;
            }
            while (iterator.hasNext()) {
                JsonNode userNode = (JsonNode)iterator.next();
                try {
                    zsUserVO user2 = (zsUserVO)mapper.treeToValue((TreeNode)userNode, zsUserVO.class);
                    userList.add(user2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        List<zsUserVO> addUserList = userList.stream().filter(user -> !users.contains(user.getUserCode())).collect(Collectors.toList());
        Iterator iterator = addUserList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.addOrgAndRole(addUserList, role, orgUsers);
                return true;
            }
            zsUserVO userVO = (zsUserVO)iterator.next();
            OrgUserVO orgUserVO = new OrgUserVO();
            orgUserVO.setAccount(userVO.getUserCode());
            List<Org> list = map.get(userVO.getOrgCode());
            if (list != null && !list.isEmpty()) {
                Org orgId = list.get(0);
                orgUserVO.setOrgId(orgId.getId());
            }
            orgUsers.add(orgUserVO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrgAndRole(List<zsUserVO> addUserList, Role role, List<OrgUserVO> orgs) {
        ArrayList addUser = new ArrayList();
        addUserList.forEach(add -> {
            User user = new User();
            user.setAccount(add.getUserCode());
            user.setMobile(add.getPhone());
            user.setFullname(add.getName());
            user.setCreateTime(LocalDateTime.now());
            user.setFrom("restful");
            user.setPassword(this.passwordEncoder.encode((CharSequence)"Artfess@023"));
            user.setPwdCreateTime(LocalDateTime.now());
            user.setStatus(add.getStatus());
            addUser.add(user);
        });
        this.saveBatch(addUser);
        ArrayList roleList = new ArrayList();
        ArrayList orgUserList = new ArrayList();
        addUser.forEach(add -> {
            String roleId = "1";
            if (BeanUtils.isNotEmpty((Object)role)) {
                roleId = role.getId();
            }
            UserRole userRole = new UserRole();
            userRole.setId(UniqueIdUtil.getSuid());
            userRole.setRoleId(roleId);
            userRole.setUserId(add.getId());
            roleList.add(userRole);
            orgs.forEach(o -> {
                if (o.getAccount().equals(add.getAccount())) {
                    OrgUser orgUser = new OrgUser();
                    orgUser.setUserId(add.getId());
                    orgUser.setOrgId(o.getOrgId());
                    orgUser.setIsMaster(1);
                    orgUserList.add(orgUser);
                }
            });
        });
        this.userRoleManager.saveBatch(roleList);
        this.orgUserManager.saveBatch(orgUserList);
    }

    private void getUserVoList(List<YhOrgVo> orgVoList, List<YhUserVo> userVoList) {
        orgVoList.stream().forEach(yhOrgVo -> {
            if (!CollectionUtils.isEmpty(yhOrgVo.getUserList())) {
                userVoList.addAll(yhOrgVo.getUserList());
            }
            if (CollectionUtils.isEmpty(yhOrgVo.getChildren())) {
                return;
            }
            this.getUserVoList(yhOrgVo.getChildren(), userVoList);
        });
    }

    private boolean isUserNotInList(List<UserVo> list, UserVo user) {
        for (UserVo userVo : list) {
            if (!userVo.getId().equals(user.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public User addUserFromExterUni(UserVo user) throws Exception {
        if (StringUtil.isEmpty((String)user.getAccount())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getFullname())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u540d\u79f0\u3010fullname\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getPassword())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u767b\u5f55\u5bc6\u7801\u3010password\u3011\u5fc5\u586b\uff01");
        }
        if (((UserDao)this.baseMapper).getCountByAccount(user.getAccount()) > 0) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5e10\u53f7\u3010" + user.getAccount() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        User u = this.getByNumber(user.getUserNumber());
        if (BeanUtils.isNotEmpty((Object)u)) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5de5\u53f7\u3010" + user.getUserNumber() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (StringUtil.isNotEmpty((String)user.getMobile()) && BeanUtils.isNotEmpty((Object)(u = this.getByMobile(user.getMobile())))) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u624b\u673a\u53f7\u3010" + user.getMobile() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        if (!this.checkEmail(user.getEmail()) && !StringUtil.isEmpty((String)user.getEmail())) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        User newUser = UserVo.parser(user);
        newUser.setStatus(1);
        if (BeanUtils.isEmpty((Object)user.getId())) {
            newUser.setId(UniqueIdUtil.getSuid());
        } else {
            if (BeanUtils.isNotEmpty(this.getUserById(user.getId()))) {
                throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\u3010" + user.getId() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            }
            newUser.setId(user.getId());
        }
        newUser.setCreateTime(LocalDateTime.now());
        newUser.setFrom("restful");
        String password = user.getPassword();
        if (StringUtil.isEmpty((String)user.getPassword())) {
            password = this.pwdStrategyManager.getDefault().getInitPwd();
        }
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)password));
        newUser.setPwdCreateTime(LocalDateTime.now());
        Integer status = BeanUtils.isNotEmpty((Object)user.getStatus()) ? user.getStatus() : 1;
        if (status != 1 && status != -1 && status != -2 && status != 0) {
            status = 1;
        }
        newUser.setStatus(status);
        try {
            this.create((Model)newUser);
            Role role = this.roleManager.getByAlias("ybry");
            String roleId = "1";
            if (BeanUtils.isNotEmpty((Object)role)) {
                roleId = role.getId();
            }
            UserRole userRole = new UserRole();
            userRole.setId(UniqueIdUtil.getSuid());
            userRole.setRoleId(roleId);
            userRole.setUserId(newUser.getId());
            this.userRoleManager.save(userRole);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return newUser;
    }
}

