/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.exception.BaseException;
import com.artfess.file.util.LibreOfficeConverterUtils;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
public class LibreOfficeToPdf {
    @Resource
    private LibreOfficeConverterUtils libreOfficeConverterUtils;

    public boolean libreOfficeToPDF(String inputFilePath, String outputFilePath) {
        return this.office2pdf(inputFilePath, outputFilePath);
    }

    public boolean libreOfficeToPDF(String inputFilePath, String outputFilePath, boolean remoteStatus) {
        if (remoteStatus) {
            return this.office2pdf(inputFilePath, outputFilePath);
        }
        return this.localOffice2pdf(inputFilePath, outputFilePath);
    }

    public boolean office2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = LibreOfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    this.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                this.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath);
                flag = true;
            }
        }
        return flag;
    }

    public void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String outputExtension = FilenameUtils.getExtension((String)outputFile.getName());
        try {
            this.libreOfficeConverterUtils.convert(inputFile, outputFile);
        }
        catch (NullPointerException e) {
            throw new BaseException("\u672a\u627e\u5230\u670d\u52a1\u7aef\u7684\u9644\u4ef6\u9884\u89c8\u7ec4\u4ef6.", (Throwable)e);
        }
    }

    public boolean localOffice2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = LibreOfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    this.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                this.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath);
                flag = true;
            }
        }
        return flag;
    }

    public static String getOutputFilePath(String inputFilePath) {
        return inputFilePath.replaceAll("." + LibreOfficeToPdf.getPostfix(inputFilePath), ".pdf");
    }

    public static String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}

