/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.model.MessageType;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageTypeManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg/messageType/v1"})
@Api(tags={"\u6d88\u606f\u5206\u7c7b"})
@ApiGroup(group={"group_application"})
public class MessageTypeController
extends BaseController<MessageTypeManager, MessageType> {
    @Resource
    MessageTypeManager messageTypeManager;
    @Resource
    MsgTemplateManager msgTemplateManager;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6d88\u606f\u5206\u7c7b\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u6d88\u606f\u5206\u7c7b\u5217\u8868")
    public PageList<MessageType> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<MessageType> queryFilter) throws Exception {
        return this.messageTypeManager.query(queryFilter);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9", httpMethod="GET", notes="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9")
    public MessageType getById(@ApiParam(name="id", value="id", required=true) @RequestParam String id) {
        MessageType messageType = (MessageType)((Object)this.messageTypeManager.getById((Serializable)((Object)id)));
        return messageType;
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u6d88\u606f\u5206\u7c7b", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u6d88\u606f\u5206\u7c7b")
    public CommonResult<String> save(@ApiParam(name="MessageType", value="\u6d88\u606f\u5206\u7c7b", required=true) @RequestBody MessageType messageType) throws Exception {
        String msg = "\u6dfb\u52a0\u6d88\u606f\u5206\u7c7b\u6210\u529f";
        boolean isExist = false;
        if (ObjectUtils.isNotEmpty((Object)((Object)messageType))) {
            PageList query;
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            String id = messageType.getId();
            String code = messageType.getCode();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                queryFilter.addFilter("id_", (Object)id, QueryOP.NOT_IN);
            }
            if (StringUtils.isNotBlank((CharSequence)code)) {
                queryFilter.addFilter("code_", (Object)code, QueryOP.EQUAL);
            }
            boolean bl = isExist = (query = ((MessageTypeManager)this.baseService).query(queryFilter)).getRows().size() > 0;
        }
        if (isExist) {
            return new CommonResult(false, "\u5206\u7c7b\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u6dfb\u52a0\u5931\u8d25", null);
        }
        if (StringUtil.isEmpty((String)messageType.getId())) {
            HashMap<String, String> map = new HashMap<String, String>();
            IUser user = ContextUtil.getCurrentUser();
            if (ObjectUtils.isNotEmpty((Object)user)) {
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence = ((MessageTypeManager)this.baseService).getNextSequence(map);
            messageType.setSn((short)nextSequence);
            ((MessageTypeManager)this.baseService).create((Model)messageType);
        } else {
            ((MessageTypeManager)this.baseService).update((Model)messageType);
            msg = "\u66f4\u65b0\u6d88\u606f\u5206\u7c7b\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u6d88\u606f\u5206\u7c7b", httpMethod="DELETE", notes="\u5220\u9664\u6d88\u606f\u5206\u7c7b")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        String code = ((MessageType)this.messageTypeManager.get((Serializable)((Object)id))).getCode();
        MsgTemplate msgTemplate = this.msgTemplateManager.gettypeKey(code);
        if (msgTemplate == null) {
            this.messageTypeManager.remove((Serializable)((Object)id));
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        return new CommonResult(false, "\u8be5\u5206\u7c7b\u5df2\u88ab\u5e94\u7528\uff0c\u5220\u9664\u5931\u8d25\uff01");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d88\u606f\u5206\u7c7b", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d88\u606f\u5206\u7c7b")
    public CommonResult<String> removes(String ... ids) throws Exception {
        String msg = "\u5220\u9664\u6d88\u606f\u5206\u7c7b\u6210\u529f";
        for (int i = 0; i < ids.length; ++i) {
            String name = ((MessageType)this.messageTypeManager.get((Serializable)((Object)ids[i]))).getName();
            String code = ((MessageType)this.messageTypeManager.get((Serializable)((Object)ids[i]))).getCode();
            MsgTemplate msgTemplate = this.msgTemplateManager.gettypeKey(code);
            if (msgTemplate != null) {
                msg = name + "\u5220\u9664\u6d88\u606f\u5206\u7c7b\u5931\u8d25";
                continue;
            }
            this.messageTypeManager.removeByIds(Arrays.asList(ids[i]));
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        this.messageTypeManager.updateSequence(params);
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @GetMapping(value={"/getHasRightMessageType"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u5206\u7c7b", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u5206\u7c7b")
    public List<MessageType> getHasRightMeetingRoom() throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        return this.messageTypeManager.query(queryFilter).getRows();
    }
}

